/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojavax.SimpleDocRefAuthor;

public class SimpleDocRefAuthorTest
extends TestCase {
    SimpleDocRefAuthor auth1;
    SimpleDocRefAuthor auth2;
    SimpleDocRefAuthor ed1;
    SimpleDocRefAuthor ed2;
    SimpleDocRefAuthor con1;
    SimpleDocRefAuthor con2;
    String name = "Hubert Hubertson";

    public SimpleDocRefAuthorTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.auth1 = new SimpleDocRefAuthor(this.name, false, false);
        this.auth2 = new SimpleDocRefAuthor(this.name);
        this.ed1 = new SimpleDocRefAuthor(this.name, false, true);
        this.ed2 = new SimpleDocRefAuthor(this.name + " (ed.)");
        this.con1 = new SimpleDocRefAuthor(this.name, true, false);
        this.con2 = new SimpleDocRefAuthor(this.name + " (consortium)");
    }

    protected void tearDown() throws Exception {
        this.con2 = null;
        this.con1 = null;
        this.ed2 = null;
        this.ed1 = null;
        this.auth2 = null;
        this.auth1 = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleDocRefAuthorTest.class);
        return suite;
    }

    public void testGetName() {
        System.out.println("testGetName");
        SimpleDocRefAuthorTest.assertEquals((String)this.name, (String)this.auth1.getName());
        SimpleDocRefAuthorTest.assertEquals((String)this.name, (String)this.auth2.getName());
        SimpleDocRefAuthorTest.assertEquals((String)this.name, (String)this.ed1.getName());
        SimpleDocRefAuthorTest.assertEquals((String)this.name, (String)this.ed2.getName());
        SimpleDocRefAuthorTest.assertEquals((String)this.name, (String)this.con1.getName());
        SimpleDocRefAuthorTest.assertEquals((String)this.name, (String)this.con2.getName());
    }

    public void testGetExtendedName() {
        System.out.println("testGetExtendedName");
        SimpleDocRefAuthorTest.assertEquals((String)this.name, (String)this.auth1.getExtendedName());
        SimpleDocRefAuthorTest.assertEquals((String)this.ed1.getExtendedName(), (String)this.ed2.getExtendedName());
        SimpleDocRefAuthorTest.assertEquals((String)(this.name + " (ed.)"), (String)this.ed1.getExtendedName());
        SimpleDocRefAuthorTest.assertEquals((String)this.con1.getExtendedName(), (String)this.con2.getExtendedName());
        SimpleDocRefAuthorTest.assertEquals((String)(this.name + " (consortium)"), (String)this.con1.getExtendedName());
    }

    public void testIsEditor() {
        SimpleDocRefAuthorTest.assertTrue((boolean)this.ed1.isEditor());
        SimpleDocRefAuthorTest.assertTrue((boolean)this.ed2.isEditor());
        SimpleDocRefAuthorTest.assertFalse((boolean)this.auth1.isEditor());
        SimpleDocRefAuthorTest.assertFalse((boolean)this.auth2.isEditor());
        SimpleDocRefAuthorTest.assertFalse((boolean)this.con1.isEditor());
        SimpleDocRefAuthorTest.assertFalse((boolean)this.con2.isEditor());
    }

    public void testIsConsortium() {
        System.out.println("testIsConsortium");
        SimpleDocRefAuthorTest.assertTrue((boolean)this.con1.isConsortium());
        SimpleDocRefAuthorTest.assertTrue((boolean)this.con2.isConsortium());
        SimpleDocRefAuthorTest.assertFalse((boolean)this.auth1.isConsortium());
        SimpleDocRefAuthorTest.assertFalse((boolean)this.auth2.isConsortium());
        SimpleDocRefAuthorTest.assertFalse((boolean)this.ed1.isConsortium());
        SimpleDocRefAuthorTest.assertFalse((boolean)this.ed2.isConsortium());
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleDocRefAuthorTest.assertTrue((this.con1.compareTo(this.con2) == 0 ? 1 : 0) != 0);
        SimpleDocRefAuthorTest.assertTrue((this.con2.compareTo(this.con1) == 0 ? 1 : 0) != 0);
        SimpleDocRefAuthorTest.assertTrue((this.ed1.compareTo(this.ed2) == 0 ? 1 : 0) != 0);
        SimpleDocRefAuthorTest.assertTrue((this.ed2.compareTo(this.ed1) == 0 ? 1 : 0) != 0);
        SimpleDocRefAuthorTest.assertTrue((this.auth1.compareTo(this.auth2) == 0 ? 1 : 0) != 0);
        SimpleDocRefAuthorTest.assertTrue((this.auth2.compareTo(this.auth1) == 0 ? 1 : 0) != 0);
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleDocRefAuthorTest.assertTrue((boolean)this.ed1.equals(this.ed2));
        SimpleDocRefAuthorTest.assertTrue((boolean)this.auth1.equals(this.auth2));
        SimpleDocRefAuthorTest.assertTrue((boolean)this.con1.equals(this.con2));
        SimpleDocRefAuthorTest.assertTrue((boolean)this.con2.equals(this.con1));
        SimpleDocRefAuthorTest.assertTrue((boolean)this.ed2.equals(this.ed1));
        SimpleDocRefAuthorTest.assertTrue((boolean)this.auth2.equals(this.auth1));
        SimpleDocRefAuthorTest.assertFalse((boolean)this.ed1.equals(this.con1));
        SimpleDocRefAuthorTest.assertFalse((boolean)this.ed1.equals(this.auth1));
        SimpleDocRefAuthorTest.assertFalse((boolean)this.con1.equals(this.ed1));
        SimpleDocRefAuthorTest.assertFalse((boolean)this.auth1.equals(this.ed1));
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        SimpleDocRefAuthorTest.assertEquals((int)this.con1.hashCode(), (int)this.con2.hashCode());
        SimpleDocRefAuthorTest.assertEquals((int)this.auth1.hashCode(), (int)this.auth2.hashCode());
        SimpleDocRefAuthorTest.assertEquals((int)this.ed1.hashCode(), (int)this.ed2.hashCode());
    }

    public void testToString() {
        System.out.println("testToString");
        SimpleDocRefAuthorTest.assertEquals((String)this.auth2.toString(), (String)this.auth2.getExtendedName());
    }
}

