/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojavax.DocRefAuthor;
import org.biojavax.SimpleCrossRef;
import org.biojavax.SimpleDocRef;
import org.biojavax.SimpleDocRefAuthor;
import org.biojavax.utils.CRC64Checksum;

public class SimpleDocRefTest
extends TestCase {
    SimpleDocRef ref;
    List authors = Collections.singletonList(new SimpleDocRefAuthor("Hubert Hubertson", false, false));
    String location = "Journal of Voodo Virology (7) 222-265";
    String title = "ADE, myth or lie?";

    public SimpleDocRefTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.ref = new SimpleDocRef(this.authors, this.location, this.title);
    }

    protected void tearDown() throws Exception {
        this.ref = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleDocRefTest.class);
        return suite;
    }

    public void testSetRemark() {
        System.out.println("testSetRemark");
        try {
            this.ref.setRemark(null);
        }
        catch (Exception e) {
            SimpleDocRefTest.fail((String)("Should be able to set remark to null without" + e.getClass().getName()));
        }
        try {
            String remark = "Remarkable!";
            this.ref.setRemark(remark);
            SimpleDocRefTest.assertEquals((String)remark, (String)this.ref.getRemark());
        }
        catch (Exception e) {
            SimpleDocRefTest.fail((String)("Should be able to set remark without" + e.getClass().getName()));
        }
    }

    public void testSetCrossref() {
        System.out.println("testSetCrossref");
        try {
            this.ref.setCrossref(null);
        }
        catch (Exception e) {
            SimpleDocRefTest.fail((String)("Should be able to set crossref to null without" + e.getClass().getName()));
        }
        try {
            SimpleCrossRef xref = new SimpleCrossRef("another DB", "AC123456", 1);
            this.ref.setCrossref(xref);
            SimpleDocRefTest.assertEquals((Object)xref, (Object)this.ref.getCrossref());
        }
        catch (Exception e) {
            SimpleDocRefTest.fail((String)("Should be able to set crossref without" + e.getClass().getName()));
        }
    }

    public void testGetAuthors() {
        System.out.println("testGetAuthors");
        SimpleDocRefTest.assertNotNull((Object)this.ref.getAuthors());
    }

    public void testGetAuthorList() {
        System.out.println("testGetAuthorList");
        SimpleDocRefTest.assertEquals((String)DocRefAuthor.Tools.generateAuthorString(this.authors, true), (String)this.ref.getAuthors());
    }

    public void testGetCRC() {
        System.out.println("testGetCRC");
        SimpleDocRef ref2 = new SimpleDocRef(this.authors, this.location, this.title);
        SimpleDocRefTest.assertNotNull((Object)this.ref.getCRC());
        SimpleDocRefTest.assertEquals((String)this.ref.getCRC(), (String)ref2.getCRC());
        StringBuffer sb = new StringBuffer();
        sb.append(this.ref.getAuthors());
        sb.append(this.ref.getTitle() == null || this.ref.getTitle().equals("") ? "<undef>" : this.ref.getTitle());
        sb.append(this.ref.getLocation() == null || this.ref.getLocation().equals("") ? "<undef>" : this.ref.getLocation());
        CRC64Checksum cs = new CRC64Checksum();
        cs.update(sb.toString().getBytes(), 0, sb.length());
        SimpleDocRefTest.assertEquals((String)((Object)cs).toString(), (String)this.ref.getCRC());
    }

    public void testGetRemark() {
        System.out.println("testGetRemark");
        SimpleDocRefTest.assertNull((Object)this.ref.getRemark());
    }

    public void testGetCrossref() {
        System.out.println("testGetCrossref");
        SimpleDocRefTest.assertNull((Object)this.ref.getCrossref());
    }

    public void testGetLocation() {
        System.out.println("testGetLocation");
        SimpleDocRefTest.assertNotNull((Object)this.ref.getLocation());
        SimpleDocRefTest.assertEquals((String)this.ref.getLocation(), (String)this.location);
    }

    public void testGetTitle() {
        System.out.println("testGetTitle");
        SimpleDocRefTest.assertEquals((String)this.title, (String)this.ref.getTitle());
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleDocRef before = new SimpleDocRef(this.authors, "A", this.title);
        SimpleDocRefTest.assertTrue((before.compareTo(this.ref) < 0 ? 1 : 0) != 0);
        SimpleDocRefTest.assertTrue((this.ref.compareTo(before) > 0 ? 1 : 0) != 0);
        before = new SimpleDocRef(Collections.singletonList(new SimpleDocRefAuthor("A", false, false)), this.location, this.title);
        SimpleDocRefTest.assertTrue((before.compareTo(this.ref) < 0 ? 1 : 0) != 0);
        SimpleDocRefTest.assertTrue((this.ref.compareTo(before) > 0 ? 1 : 0) != 0);
        before = new SimpleDocRef(this.authors, this.location, "AAA");
        SimpleDocRefTest.assertTrue((before.compareTo(this.ref) < 0 ? 1 : 0) != 0);
        SimpleDocRefTest.assertTrue((this.ref.compareTo(before) > 0 ? 1 : 0) != 0);
        before = new SimpleDocRef(this.authors, this.location, null);
        SimpleDocRefTest.assertTrue((before.compareTo(this.ref) < 0 ? 1 : 0) != 0);
        SimpleDocRefTest.assertTrue((this.ref.compareTo(before) > 0 ? 1 : 0) != 0);
        SimpleDocRef equal = new SimpleDocRef(this.authors, this.location, this.title);
        SimpleDocRefTest.assertTrue((this.ref.compareTo(this.ref) == 0 ? 1 : 0) != 0);
        SimpleDocRefTest.assertTrue((this.ref.compareTo(equal) == 0 ? 1 : 0) != 0);
        SimpleDocRefTest.assertTrue((equal.compareTo(this.ref) == 0 ? 1 : 0) != 0);
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleDocRefTest.assertTrue((boolean)this.ref.equals(this.ref));
        SimpleDocRefTest.assertTrue((boolean)this.ref.equals(new SimpleDocRef(this.authors, this.location, this.title)));
        SimpleDocRefTest.assertTrue((boolean)new SimpleDocRef(this.authors, this.location, this.title).equals(this.ref));
        SimpleDocRefTest.assertFalse((boolean)new SimpleDocRef(this.authors, "A", this.title).equals(this.ref));
        SimpleDocRefTest.assertFalse((boolean)this.ref.equals(new SimpleDocRef(this.authors, "A", this.title)));
        SimpleDocRefTest.assertFalse((boolean)this.ref.equals(new SimpleDocRef(this.authors, this.location, "The long awaited biojava book!")));
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        SimpleDocRefTest.assertEquals((int)this.ref.hashCode(), (int)new SimpleDocRef(this.authors, this.location, this.title).hashCode());
    }

    public void testToString() {
        System.out.println("testToString");
        SimpleDocRefTest.assertEquals((String)("Hubert Hubertson; " + this.location), (String)this.ref.toString());
    }
}

