/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNamespace;

public class SimpleNamespaceTest
extends TestCase {
    SimpleNamespace ns;
    SimpleNamespace ns2;
    String name = "test space";
    String acronym = "by any other name";
    String authority = "respect mah authoritaaah!!!";
    String desc = "description";
    String uriString = "file:///foo.bar";

    public SimpleNamespaceTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.ns = (SimpleNamespace)RichObjectFactory.getObject(SimpleNamespace.class, new Object[]{this.name});
        this.ns2 = (SimpleNamespace)RichObjectFactory.getObject(SimpleNamespace.class, new Object[]{this.name});
    }

    protected void tearDown() throws Exception {
        this.ns = null;
        this.ns2 = null;
        RichObjectFactory.clearLRUCache(SimpleNamespace.class);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleNamespaceTest.class);
        return suite;
    }

    public void testSetAcronym() {
        System.out.println("testSetAcronym");
        try {
            this.ns.setAcronym(this.acronym);
            SimpleNamespaceTest.assertEquals((String)this.acronym, (String)this.ns.getAcronym());
        }
        catch (ChangeVetoException ex) {
            SimpleNamespaceTest.fail((String)("Was not expecting " + ex.getClass().getName()));
        }
    }

    public void testSetAuthority() {
        System.out.println("testSetAuthority");
        try {
            this.ns.setAuthority(this.authority);
            SimpleNamespaceTest.assertEquals((String)this.authority, (String)this.ns.getAuthority());
        }
        catch (ChangeVetoException ex) {
            SimpleNamespaceTest.fail((String)("Was not expecting " + ex.getClass().getName()));
        }
    }

    public void testSetDescription() {
        System.out.println("testSetDescription");
        try {
            this.ns.setDescription(this.desc);
            SimpleNamespaceTest.assertEquals((String)this.desc, (String)this.ns.getDescription());
        }
        catch (ChangeVetoException ex) {
            SimpleNamespaceTest.fail((String)("Was not expecting " + ex.getClass().getName()));
        }
    }

    public void testSetURI() throws URISyntaxException {
        System.out.println("testSetURI");
        URI uri = new URI(this.uriString);
        try {
            this.ns.setURI(uri);
            SimpleNamespaceTest.assertEquals((Object)uri, (Object)this.ns.getURI());
        }
        catch (ChangeVetoException ex) {
            SimpleNamespaceTest.fail((String)("Was not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetAcronym() {
        System.out.println("testGetAcronym");
        SimpleNamespaceTest.assertEquals((String)this.acronym, (String)this.ns.getAcronym());
    }

    public void testGetAuthority() {
        System.out.println("testGetAuthority");
        SimpleNamespaceTest.assertEquals((String)this.authority, (String)this.ns.getAuthority());
    }

    public void testGetDescription() {
        System.out.println("testGetDescription");
        try {
            this.ns.setDescription(this.desc);
        }
        catch (Exception ex) {
            SimpleNamespaceTest.fail((String)("Was not expecting " + ex.getClass().getName()));
        }
        SimpleNamespaceTest.assertEquals((String)this.desc, (String)this.ns.getDescription());
    }

    public void testGetName() {
        System.out.println("testGetName");
        SimpleNamespaceTest.assertEquals((String)this.name, (String)this.ns.getName());
    }

    public void testGetURI() {
        System.out.println("testGetURI");
        SimpleNamespaceTest.assertEquals((String)this.uriString, (String)this.ns.getURI().toString());
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleNamespaceTest.assertTrue((this.ns.compareTo(RichObjectFactory.getDefaultNamespace()) > 1 ? 1 : 0) != 0);
        SimpleNamespaceTest.assertTrue((RichObjectFactory.getDefaultNamespace().compareTo(this.ns) < 1 ? 1 : 0) != 0);
        SimpleNamespaceTest.assertTrue((this.ns.compareTo(this.ns2) == 0 ? 1 : 0) != 0);
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleNamespaceTest.assertTrue((this.ns == this.ns2 ? 1 : 0) != 0);
        SimpleNamespaceTest.assertTrue((boolean)this.ns.equals(this.ns2));
        SimpleNamespaceTest.assertFalse((boolean)this.ns.equals(RichObjectFactory.getDefaultNamespace()));
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        SimpleNamespaceTest.assertTrue((this.ns.hashCode() == this.ns2.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() {
        System.out.println("testToString");
        SimpleNamespaceTest.assertEquals((String)this.name, (String)this.ns.toString());
    }
}

