/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNote;
import org.biojavax.ontology.ComparableOntology;
import org.biojavax.ontology.ComparableTerm;

public class SimpleNoteTest
extends TestCase {
    ComparableOntology ont = RichObjectFactory.getDefaultOntology();
    SimpleNote note;
    SimpleNote note2;
    SimpleNote note3;
    SimpleNote note4;
    ComparableTerm term = this.ont.getOrCreateTerm("test_term");
    String value = "test_val";
    int rank = 1;

    public SimpleNoteTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.note = new SimpleNote(this.term, this.value, this.rank);
        this.note2 = new SimpleNote(this.term, this.value, this.rank);
        this.note3 = new SimpleNote(this.term, "another_val", this.rank);
        this.note4 = new SimpleNote(this.term, this.value, 22);
    }

    protected void tearDown() throws Exception {
        this.note4 = null;
        this.note3 = null;
        this.note2 = null;
        this.note = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleNoteTest.class);
        return suite;
    }

    public void testGetTerm() {
        System.out.println("testGetTerm");
        SimpleNoteTest.assertEquals((Object)this.term, (Object)this.note.getTerm());
    }

    public void testSetTerm() {
        System.out.println("testSetTerm");
        try {
            this.note.setTerm(null);
            SimpleNoteTest.fail((String)"Should have got IllegalArgumentException");
        }
        catch (Exception ex) {
            // empty catch block
        }
        ComparableTerm term2 = this.ont.getOrCreateTerm("term2");
        try {
            this.note.setTerm(term2);
            SimpleNoteTest.assertEquals((Object)term2, (Object)this.note.getTerm());
        }
        catch (Exception ex) {
            SimpleNoteTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetValue() {
        System.out.println("testGetValue");
        SimpleNoteTest.assertEquals((String)this.value, (String)this.note.getValue());
    }

    public void testSetValue() {
        System.out.println("testSetValue");
        String otherVal = "something else";
        try {
            this.note.setValue(otherVal);
            SimpleNoteTest.assertEquals((String)otherVal, (String)this.note.getValue());
        }
        catch (Exception ex) {
            SimpleNoteTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetRank() {
        System.out.println("testGetRank");
        SimpleNoteTest.assertEquals((int)this.rank, (int)this.note.getRank());
    }

    public void testSetRank() {
        System.out.println("testSetRank");
        try {
            this.note.setRank(100);
            SimpleNoteTest.assertEquals((int)100, (int)this.note.getRank());
        }
        catch (Exception ex) {
            SimpleNoteTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleNoteTest.assertTrue((this.note.compareTo(this.note2) == 0 ? 1 : 0) != 0);
        SimpleNoteTest.assertTrue((this.note.compareTo(this.note3) == 0 ? 1 : 0) != 0);
        SimpleNoteTest.assertTrue((this.note.compareTo(this.note4) < 1 ? 1 : 0) != 0);
        SimpleNoteTest.assertTrue((this.note4.compareTo(this.note) > 1 ? 1 : 0) != 0);
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleNoteTest.assertTrue((boolean)this.note.equals(this.note2));
        SimpleNoteTest.assertTrue((boolean)this.note.equals(this.note3));
        SimpleNoteTest.assertFalse((boolean)this.note.equals(this.note4));
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        SimpleNoteTest.assertEquals((int)this.note.hashCode(), (int)this.note2.hashCode());
    }

    public void testToString() {
        System.out.println("testToString");
        String expected = "(#" + this.rank + ") " + this.term + ": " + this.value;
        SimpleNoteTest.assertEquals((String)expected, (String)this.note.toString());
    }
}

