/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.RankedCrossRef;
import org.biojavax.SimpleCrossRef;
import org.biojavax.SimpleRankedCrossRef;

public class SimpleRankedCrossRefTest
extends TestCase {
    SimpleCrossRef ref;
    RankedCrossRef xref;
    RankedCrossRef xref2;
    int rank = 1;
    ChangeListener.ChangeEventRecorder cr;

    public SimpleRankedCrossRefTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.ref = new SimpleCrossRef("dbname", "AC123456", 1);
        this.xref = new SimpleRankedCrossRef(this.ref, this.rank);
        this.cr = new ChangeListener.ChangeEventRecorder();
        this.xref.addChangeListener(this.cr);
    }

    protected void tearDown() throws Exception {
        this.ref = null;
        this.xref.removeChangeListener(this.cr);
        this.xref = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleRankedCrossRefTest.class);
        return suite;
    }

    public void testGetCrossRef() {
        System.out.println("testGetCrossRef");
        SimpleRankedCrossRefTest.assertEquals((Object)this.ref, (Object)this.xref.getCrossRef());
    }

    public void testSetRank() {
        System.out.println("testSetRank");
        try {
            this.xref.setRank(2);
            ChangeEvent ev = this.cr.getEvent();
            SimpleRankedCrossRefTest.assertNotNull((Object)ev);
            SimpleRankedCrossRefTest.assertEquals((Object)RankedCrossRef.RANK, (Object)ev.getType());
            SimpleRankedCrossRefTest.assertEquals((Object)new Integer(1), (Object)ev.getPrevious());
            SimpleRankedCrossRefTest.assertEquals((Object)new Integer(2), (Object)ev.getChange());
            this.xref.setRank(1);
        }
        catch (ChangeVetoException cve) {
            SimpleRankedCrossRefTest.fail((String)("Unexpected exception: " + cve));
        }
    }

    public void testGetRank() {
        System.out.println("testGetRank");
        SimpleRankedCrossRefTest.assertEquals((int)this.rank, (int)this.xref.getRank());
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleRankedCrossRefTest.assertTrue((boolean)this.xref.equals(this.xref));
        SimpleRankedCrossRefTest.assertFalse((boolean)this.xref.equals(this.ref));
        this.xref2 = new SimpleRankedCrossRef(this.ref, this.rank);
        SimpleRankedCrossRefTest.assertTrue((boolean)this.xref.equals(this.xref2));
        SimpleRankedCrossRefTest.assertTrue((boolean)this.xref2.equals(this.xref));
        this.xref2 = new SimpleRankedCrossRef(this.ref, 100);
        SimpleRankedCrossRefTest.assertFalse((boolean)this.xref.equals(this.xref2));
        SimpleRankedCrossRefTest.assertFalse((boolean)this.xref2.equals(this.xref));
        SimpleCrossRef ref2 = new SimpleCrossRef("dbname", "AC123456", 1);
        this.xref2 = new SimpleRankedCrossRef(ref2, this.rank);
        SimpleRankedCrossRefTest.assertTrue((boolean)this.xref.equals(this.xref2));
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleRankedCrossRefTest.assertTrue((this.xref.compareTo(this.xref) == 0 ? 1 : 0) != 0);
        this.xref2 = new SimpleRankedCrossRef(this.ref, this.rank);
        SimpleRankedCrossRefTest.assertTrue((this.xref.compareTo(this.xref2) == 0 ? 1 : 0) != 0);
        SimpleRankedCrossRefTest.assertTrue((this.xref2.compareTo(this.xref) == 0 ? 1 : 0) != 0);
        this.xref2 = new SimpleRankedCrossRef(this.ref, 100);
        SimpleRankedCrossRefTest.assertTrue((this.xref.compareTo(this.xref2) < 0 ? 1 : 0) != 0);
        SimpleRankedCrossRefTest.assertTrue((this.xref2.compareTo(this.xref) > 0 ? 1 : 0) != 0);
        SimpleCrossRef ref2 = new SimpleCrossRef("dbname", "AC123459", 1);
        this.xref2 = new SimpleRankedCrossRef(ref2, this.rank);
        SimpleRankedCrossRefTest.assertTrue((this.xref.compareTo(this.xref2) < 0 ? 1 : 0) != 0);
        SimpleRankedCrossRefTest.assertTrue((this.xref2.compareTo(this.xref) > 0 ? 1 : 0) != 0);
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        this.xref2 = new SimpleRankedCrossRef(this.ref, this.rank);
        SimpleRankedCrossRefTest.assertTrue((this.xref.hashCode() == this.xref2.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() {
        System.out.println("testToString");
        String expected = "(#" + this.rank + ") " + this.ref;
        SimpleRankedCrossRefTest.assertEquals((String)expected, (String)this.xref.toString());
    }
}

