/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.DocRef;
import org.biojavax.RankedDocRef;
import org.biojavax.SimpleDocRef;
import org.biojavax.SimpleDocRefAuthor;
import org.biojavax.SimpleRankedDocRef;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.SimpleRichLocation;

public class SimpleRankedDocRefTest
extends TestCase {
    DocRef dr;
    SimpleRankedDocRef ref;
    SimpleRankedDocRef ref2;
    int rank = 1;
    Integer start = new Integer(1);
    Integer end = new Integer(25);
    ChangeListener.ChangeEventRecorder cr;

    public SimpleRankedDocRefTest(String testName) {
        super(testName);
        this.dr = new SimpleDocRef(Collections.singletonList(new SimpleDocRefAuthor("Hubert Hubertson", false, false)), "Journal of Voodoo Virology", "Viruses, what are they good for?");
    }

    protected void setUp() throws Exception {
        this.ref = new SimpleRankedDocRef(this.dr, this.start, this.end, this.rank);
        this.cr = new ChangeListener.ChangeEventRecorder();
        this.ref.addChangeListener(this.cr);
    }

    protected void tearDown() throws Exception {
        this.ref.removeChangeListener(this.cr);
        this.ref = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleRankedDocRefTest.class);
        return suite;
    }

    public void testSetRank() {
        System.out.println("testSetRank");
        try {
            this.ref.setRank(2);
            ChangeEvent ev = this.cr.getEvent();
            SimpleRankedDocRefTest.assertNotNull((Object)ev);
            SimpleRankedDocRefTest.assertEquals((Object)RankedDocRef.RANK, (Object)ev.getType());
            SimpleRankedDocRefTest.assertEquals((Object)new Integer(1), (Object)ev.getPrevious());
            SimpleRankedDocRefTest.assertEquals((Object)new Integer(2), (Object)ev.getChange());
            this.ref.setRank(1);
        }
        catch (ChangeVetoException cve) {
            SimpleRankedDocRefTest.fail((String)("Unexpected exception: " + cve));
        }
    }

    public void testGetRank() {
        System.out.println("testGetRank");
        SimpleRankedDocRefTest.assertEquals((int)this.rank, (int)this.ref.getRank());
    }

    public void testGetDocumentReference() {
        System.out.println("testGetDocumentReference");
        SimpleRankedDocRefTest.assertEquals((Object)this.dr, (Object)this.ref.getDocumentReference());
    }

    public void testGetStart() {
        System.out.println("testGetStart");
        SimpleRankedDocRefTest.assertEquals((Object)this.start, (Object)this.ref.getStart());
    }

    public void testGetEnd() {
        System.out.println("testGetEnd");
        SimpleRankedDocRefTest.assertEquals((Object)this.end, (Object)this.ref.getEnd());
    }

    public void testSetLocation() {
        System.out.println("testSetLocation");
        try {
            SimplePosition p1 = new SimplePosition(2);
            SimplePosition p2 = new SimplePosition(4);
            SimpleRichLocation loc = new SimpleRichLocation((Position)p1, p2, 0);
            this.ref.setLocation(loc);
            ChangeEvent ev = this.cr.getEvent();
            SimpleRankedDocRefTest.assertNotNull((Object)ev);
            SimpleRankedDocRefTest.assertEquals((Object)RankedDocRef.LOCATION, (Object)ev.getType());
            Object o = ev.getPrevious();
            SimpleRankedDocRefTest.assertTrue((boolean)(o instanceof RichLocation));
            RichLocation l = (RichLocation)o;
            SimpleRankedDocRefTest.assertTrue((l.getMin() == 1 ? 1 : 0) != 0);
            SimpleRankedDocRefTest.assertTrue((l.getMax() == 25 ? 1 : 0) != 0);
            o = ev.getChange();
            SimpleRankedDocRefTest.assertTrue((boolean)(o instanceof RichLocation));
            l = (RichLocation)o;
            SimpleRankedDocRefTest.assertTrue((l.getMin() == 2 ? 1 : 0) != 0);
            SimpleRankedDocRefTest.assertTrue((l.getMax() == 4 ? 1 : 0) != 0);
            p1 = new SimplePosition(1);
            p2 = new SimplePosition(25);
            loc = new SimpleRichLocation((Position)p1, p2, 0);
            this.ref.setLocation(loc);
        }
        catch (ChangeVetoException cve) {
            SimpleRankedDocRefTest.fail((String)("Unexpected exception: " + cve));
        }
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleRankedDocRefTest.assertTrue((boolean)this.ref.equals(this.ref));
        SimpleRankedDocRefTest.assertFalse((boolean)this.ref.equals(new Object()));
        SimpleRankedDocRefTest.assertFalse((boolean)this.ref.equals(null));
        this.ref2 = new SimpleRankedDocRef(this.dr, this.start, this.end, 1);
        SimpleRankedDocRefTest.assertTrue((boolean)this.ref.equals(this.ref2));
        SimpleRankedDocRefTest.assertTrue((boolean)this.ref2.equals(this.ref));
        this.ref2 = new SimpleRankedDocRef(this.dr, new Integer(30), new Integer(60), 1);
        SimpleRankedDocRefTest.assertFalse((boolean)this.ref.equals(this.ref2));
        SimpleRankedDocRefTest.assertFalse((boolean)this.ref2.equals(this.ref));
        this.ref2 = new SimpleRankedDocRef(this.dr, this.start, this.end, 100);
        SimpleRankedDocRefTest.assertFalse((boolean)this.ref.equals(this.ref2));
        SimpleRankedDocRefTest.assertFalse((boolean)this.ref2.equals(this.ref));
        this.ref2 = new SimpleRankedDocRef(new SimpleDocRef(Collections.singletonList(new SimpleDocRefAuthor("Rev. Falliwell", false, false)), "Kansas Journal of Creationism", "Un-intelligent design"), this.start, this.end, 1);
        SimpleRankedDocRefTest.assertFalse((boolean)this.ref.equals(this.ref2));
        SimpleRankedDocRefTest.assertFalse((boolean)this.ref2.equals(this.ref));
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleRankedDocRefTest.assertTrue((this.ref.compareTo(this.ref) == 0 ? 1 : 0) != 0);
        this.ref2 = new SimpleRankedDocRef(this.dr, this.start, this.end, 1);
        SimpleRankedDocRefTest.assertTrue((this.ref.compareTo(this.ref2) == 0 ? 1 : 0) != 0);
        SimpleRankedDocRefTest.assertTrue((this.ref2.compareTo(this.ref) == 0 ? 1 : 0) != 0);
        this.ref2 = new SimpleRankedDocRef(this.dr, new Integer(30), new Integer(60), 1);
        SimpleRankedDocRefTest.assertTrue((this.ref.compareTo(this.ref2) < 0 ? 1 : 0) != 0);
        SimpleRankedDocRefTest.assertTrue((this.ref2.compareTo(this.ref) > 0 ? 1 : 0) != 0);
        this.ref2 = new SimpleRankedDocRef(this.dr, this.start, this.end, 100);
        SimpleRankedDocRefTest.assertTrue((this.ref.compareTo(this.ref2) < 0 ? 1 : 0) != 0);
        SimpleRankedDocRefTest.assertTrue((this.ref2.compareTo(this.ref) > 0 ? 1 : 0) != 0);
        this.ref2 = new SimpleRankedDocRef(new SimpleDocRef(Collections.singletonList(new SimpleDocRefAuthor("Rev. Falliwell", false, false)), "Kansas Journal of Creationism", "Evidence for the giant spaghetti monster"), this.start, this.end, 1);
        SimpleRankedDocRefTest.assertTrue((this.ref.compareTo(this.ref2) == this.ref.getDocumentReference().compareTo(this.ref2.getDocumentReference()) ? 1 : 0) != 0);
        SimpleRankedDocRefTest.assertTrue((this.ref2.compareTo(this.ref) == this.ref2.getDocumentReference().compareTo(this.ref.getDocumentReference()) ? 1 : 0) != 0);
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        this.ref2 = new SimpleRankedDocRef(this.dr, this.start, this.end, 1);
        SimpleRankedDocRefTest.assertTrue((this.ref.hashCode() == this.ref2.hashCode() ? 1 : 0) != 0);
        this.ref2 = new SimpleRankedDocRef(this.dr, new Integer(30), new Integer(60), 1);
        SimpleRankedDocRefTest.assertTrue((this.ref.hashCode() != this.ref2.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() {
        System.out.println("testToString");
        String expected = "(#" + this.rank + ") " + this.dr;
        SimpleRankedDocRefTest.assertEquals((String)expected, (String)this.ref.toString());
    }
}

