/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojavax.Note;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNote;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.ontology.ComparableOntology;
import org.biojavax.ontology.ComparableTerm;

public class SimpleRichAnnotationTest
extends TestCase {
    private SimpleRichAnnotation anno1;
    private Note note;

    public SimpleRichAnnotationTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.anno1 = new SimpleRichAnnotation();
        this.anno1.setProperty("foo", "bar");
        this.note = (Note)this.anno1.getNoteSet().iterator().next();
    }

    protected void tearDown() throws Exception {
        this.anno1 = null;
        this.note = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleRichAnnotationTest.class);
        return suite;
    }

    public void testClear() {
        System.out.println("testClear");
        SimpleRichAnnotationTest.assertTrue((this.anno1.getNoteSet().size() == 1 ? 1 : 0) != 0);
        try {
            this.anno1.clear();
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichAnnotationTest.assertTrue((this.anno1.getNoteSet().size() == 0 ? 1 : 0) != 0);
    }

    public void testAsMap() {
        System.out.println("testAsMap");
        Map map = this.anno1.asMap();
        SimpleRichAnnotationTest.assertTrue((boolean)map.containsKey(this.note.getTerm()));
        SimpleRichAnnotationTest.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        SimpleRichAnnotationTest.assertEquals(map.get(this.note.getTerm()), (Object)"bar");
    }

    public void testAddNote() {
        System.out.println("testAddNote");
        try {
            this.anno1.addNote(this.note);
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichAnnotationTest.assertTrue((this.anno1.getNoteSet().size() == 1 ? 1 : 0) != 0);
        ComparableOntology ont = RichObjectFactory.getDefaultOntology();
        ComparableTerm term = ont.getOrCreateTerm("foo2");
        SimpleNote note2 = new SimpleNote(term, "bar", 0);
        try {
            this.anno1.addNote(note2);
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichAnnotationTest.assertTrue((boolean)this.anno1.contains(this.note));
        SimpleRichAnnotationTest.assertTrue((boolean)this.anno1.contains(note2));
        SimpleRichAnnotationTest.assertEquals((int)2, (int)this.anno1.getNoteSet().size());
        SimpleRichAnnotationTest.assertTrue((this.anno1.keys().size() == 2 ? 1 : 0) != 0);
        SimpleRichAnnotationTest.assertTrue((boolean)this.anno1.containsProperty("foo"));
        SimpleRichAnnotationTest.assertTrue((boolean)this.anno1.containsProperty(this.note.getTerm()));
        SimpleRichAnnotationTest.assertTrue((boolean)this.anno1.containsProperty(note2.getTerm()));
        SimpleRichAnnotationTest.assertTrue((boolean)this.anno1.containsProperty("foo2"));
    }

    public void testContains() {
        System.out.println("testContains");
        SimpleRichAnnotationTest.assertTrue((boolean)this.anno1.contains(this.note));
    }

    public void testContainsProperty() {
        System.out.println("testContainsProperty");
        SimpleRichAnnotationTest.assertTrue((boolean)this.anno1.containsProperty("foo"));
        ComparableTerm term = RichObjectFactory.getDefaultOntology().getOrCreateTerm("foo");
        SimpleRichAnnotationTest.assertTrue((boolean)this.anno1.containsProperty(term));
    }

    public void testGetNote() {
        System.out.println("testGetNote");
        SimpleRichAnnotationTest.assertNotNull((Object)this.anno1.getNote(this.note));
        SimpleRichAnnotationTest.assertEquals((Object)this.note, (Object)this.anno1.getNote(this.note));
    }

    public void testGetProperty() {
        System.out.println("testGetProperty");
        SimpleRichAnnotationTest.assertNotNull((Object)this.anno1.getProperty("foo"));
        SimpleRichAnnotationTest.assertTrue((boolean)(this.anno1.getProperty("foo") instanceof String));
        SimpleRichAnnotationTest.assertEquals((Object)"bar", (Object)this.anno1.getProperty("foo"));
        ComparableTerm term = RichObjectFactory.getDefaultOntology().getOrCreateTerm("foo");
        SimpleRichAnnotationTest.assertNotNull((Object)this.anno1.getProperty(term));
        SimpleRichAnnotationTest.assertTrue((boolean)(this.anno1.getProperty(term) instanceof String));
        SimpleRichAnnotationTest.assertEquals((Object)"bar", (Object)this.anno1.getProperty(term));
    }

    public void testGetPropertys() {
        System.out.println("testGetPropertys");
        SimpleNote note2 = new SimpleNote(this.note.getTerm(), "bar1", 1);
        try {
            this.anno1.addNote(note2);
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichAnnotationTest.assertEquals((int)2, (int)this.anno1.getProperties(note2.getTerm()).length);
        SimpleRichAnnotationTest.assertEquals((int)2, (int)this.anno1.getProperties(this.note.getTerm()).length);
        SimpleRichAnnotationTest.assertEquals((int)2, (int)this.anno1.getProperties("foo").length);
        Note[] notes = this.anno1.getProperties(this.note.getTerm());
        SimpleRichAnnotationTest.assertEquals((String)this.note.getValue(), (String)notes[0].getValue());
        SimpleRichAnnotationTest.assertEquals((String)note2.getValue(), (String)notes[1].getValue());
        SimpleRichAnnotationTest.assertNotNull((Object)this.anno1.getProperties("not_here"));
        SimpleRichAnnotationTest.assertEquals((int)0, (int)this.anno1.getProperties("not_here").length);
    }

    public void testKeys() {
        System.out.println("testKeys");
        SimpleRichAnnotationTest.assertNotNull((Object)this.anno1.keys());
        Set keys = this.anno1.keys();
        SimpleRichAnnotationTest.assertTrue((boolean)keys.contains(this.note.getTerm()));
        SimpleRichAnnotationTest.assertTrue((keys.size() == 1 ? 1 : 0) != 0);
    }

    public void testRemoveNote() {
        System.out.println("testRemoveNote");
        try {
            this.anno1.removeNote(this.note);
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichAnnotationTest.assertTrue((this.anno1.getNoteSet().size() == 0 ? 1 : 0) != 0);
        SimpleRichAnnotationTest.assertTrue((this.anno1.keys().size() == 0 ? 1 : 0) != 0);
        try {
            this.anno1.getNote(this.note);
            SimpleRichAnnotationTest.fail((String)"Was expecting NoSuchElementException");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            this.anno1.getProperty(this.note.getTerm());
            SimpleRichAnnotationTest.fail((String)"Was expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveProperty() {
        System.out.println("testRemoveProperty");
        try {
            this.anno1.removeProperty("foo");
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichAnnotationTest.assertTrue((this.anno1.getNoteSet().size() == 0 ? 1 : 0) != 0);
        SimpleRichAnnotationTest.assertTrue((this.anno1.keys().size() == 0 ? 1 : 0) != 0);
        try {
            this.anno1.getNote(this.note);
            SimpleRichAnnotationTest.fail((String)"Was expecting NoSuchElementException");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            this.anno1.getProperty("foo");
            SimpleRichAnnotationTest.fail((String)"Was expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveProperty2() {
        System.out.println("testRemoveProperty2");
        try {
            this.anno1.removeProperty(this.note.getTerm());
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichAnnotationTest.assertTrue((this.anno1.getNoteSet().size() == 0 ? 1 : 0) != 0);
        SimpleRichAnnotationTest.assertTrue((this.anno1.keys().size() == 0 ? 1 : 0) != 0);
        try {
            this.anno1.getNote(this.note);
            SimpleRichAnnotationTest.fail((String)"Was expecting NoSuchElementException");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            this.anno1.getProperty(this.note.getTerm());
            SimpleRichAnnotationTest.fail((String)"Was expecting NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testSetProperty() {
        System.out.println("testSetProperty");
        try {
            this.anno1.setProperty("foo", "bar");
            SimpleRichAnnotationTest.assertTrue((this.anno1.getNoteSet().size() == 1 ? 1 : 0) != 0);
            SimpleRichAnnotationTest.assertTrue((this.anno1.keys().size() == 1 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            this.anno1.setProperty(null, null);
            SimpleRichAnnotationTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            this.anno1.setProperty("foo2", "bar2");
            SimpleRichAnnotationTest.assertTrue((this.anno1.getNoteSet().size() == 2 ? 1 : 0) != 0);
            SimpleRichAnnotationTest.assertTrue((this.anno1.keys().size() == 2 ? 1 : 0) != 0);
            SimpleRichAnnotationTest.assertTrue((boolean)this.anno1.containsProperty("foo2"));
            SimpleRichAnnotationTest.assertNotNull((Object)this.anno1.getProperty("foo2"));
            SimpleRichAnnotationTest.assertEquals((Object)"bar2", (Object)this.anno1.getProperty("foo2"));
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetNoteSet() {
        System.out.println("testGetNoteSet");
        SimpleRichAnnotationTest.assertNotNull((Object)this.anno1.getNoteSet());
        SimpleRichAnnotationTest.assertTrue((this.anno1.getNoteSet().size() == 1 ? 1 : 0) != 0);
        try {
            this.anno1.getNoteSet().remove(this.note);
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        this.anno1 = new SimpleRichAnnotation();
        SimpleRichAnnotationTest.assertNotNull((Object)this.anno1.getNoteSet());
        SimpleRichAnnotationTest.assertTrue((this.anno1.getNoteSet().size() == 0 ? 1 : 0) != 0);
    }

    public void testSetNoteSet() {
        System.out.println("testSetNoteSet");
        try {
            this.anno1.setNoteSet(null);
            SimpleRichAnnotationTest.assertNull((Object)this.anno1.getNoteSet());
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            HashSet s = new HashSet();
            this.anno1.setNoteSet(s);
            SimpleRichAnnotationTest.assertEquals(s, (Object)this.anno1.getNoteSet());
        }
        catch (Exception ex) {
            SimpleRichAnnotationTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testToString() {
        System.out.println("testToString");
        StringBuffer sb = new StringBuffer();
        Iterator i = this.anno1.getNoteSet().iterator();
        while (i.hasNext()) {
            sb.append("[");
            sb.append(i.next());
            sb.append("]");
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        String expected = sb.toString();
        SimpleRichAnnotationTest.assertEquals((String)expected, (String)this.anno1.toString());
    }
}

