/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio;

import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.Annotation;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Comment;
import org.biojavax.Namespace;
import org.biojavax.RankedCrossRef;
import org.biojavax.RankedDocRef;
import org.biojavax.RichAnnotation;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.BioEntry;
import org.biojavax.bio.BioEntryRelationship;
import org.biojavax.bio.taxa.NCBITaxon;

public class SimpleBioEntry
extends AbstractChangeable
implements BioEntry {
    private Set comments = new TreeSet();
    private Set rankedcrossrefs = new TreeSet();
    private Set rankeddocrefs = new TreeSet();
    private Set relationships = new TreeSet();
    private String description;
    private String division;
    private String identifier;
    private String name;
    private String accession;
    private int version;
    private NCBITaxon taxon;
    private Namespace ns;
    private RichAnnotation notes = new SimpleRichAnnotation();
    private Integer id;

    public SimpleBioEntry(Namespace ns, String name, String accession, int version) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (accession == null) {
            throw new IllegalArgumentException("Accession cannot be null");
        }
        if (ns == null) {
            throw new IllegalArgumentException("Namespace cannot be null");
        }
        this.description = null;
        this.division = null;
        this.identifier = null;
        this.name = name;
        this.accession = accession;
        this.version = version;
        this.taxon = null;
        this.ns = ns;
    }

    protected SimpleBioEntry() {
    }

    @Override
    public Set getRankedCrossRefs() {
        return this.rankedcrossrefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTaxon(NCBITaxon taxon) throws ChangeVetoException {
        if (!this.hasListeners(BioEntry.TAXON)) {
            this.taxon = taxon;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.TAXON, taxon, this.taxon);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.TAXON);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.taxon = taxon;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    @Override
    public Annotation getAnnotation() {
        return this.notes;
    }

    @Override
    public Set getNoteSet() {
        return this.notes.getNoteSet();
    }

    @Override
    public void setNoteSet(Set notes) throws ChangeVetoException {
        this.notes.setNoteSet(notes);
    }

    @Override
    public Set getComments() {
        return this.comments;
    }

    @Override
    public Set getRankedDocRefs() {
        return this.rankeddocrefs;
    }

    @Override
    public Set getRelationships() {
        return this.relationships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIdentifier(String identifier) throws ChangeVetoException {
        if (!this.hasListeners(BioEntry.IDENTIFIER)) {
            this.identifier = identifier;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.IDENTIFIER, identifier, this.identifier);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.IDENTIFIER);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.identifier = identifier;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDivision(String division) throws ChangeVetoException {
        if (!this.hasListeners(BioEntry.DIVISION)) {
            this.division = division;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.DIVISION, division, this.division);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.DIVISION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.division = division;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String description) throws ChangeVetoException {
        if (!this.hasListeners(BioEntry.DESCRIPTION)) {
            this.description = description;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.DESCRIPTION, description, this.description);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.DESCRIPTION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.description = description;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    @Override
    public String getAccession() {
        return this.accession;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDivision() {
        return this.division;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Namespace getNamespace() {
        return this.ns;
    }

    @Override
    public NCBITaxon getTaxon() {
        return this.taxon;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BioEntry)) {
            return false;
        }
        if (this.ns == null) {
            return false;
        }
        BioEntry them = (BioEntry)obj;
        return this.ns.equals(them.getNamespace()) && this.name.equals(them.getName()) && this.accession.equals(them.getAccession()) && this.version == them.getVersion();
    }

    public int compareTo(Object o) {
        if (this.ns == null) {
            return -1;
        }
        BioEntry them = (BioEntry)o;
        if (!this.ns.equals(them.getNamespace())) {
            return this.ns.compareTo(them.getNamespace());
        }
        if (!this.name.equals(them.getName())) {
            return this.name.compareTo(them.getName());
        }
        if (!this.accession.equals(them.getAccession())) {
            return this.accession.compareTo(them.getAccession());
        }
        return this.version - them.getVersion();
    }

    public int hashCode() {
        int code = 17;
        if (this.ns == null) {
            return code;
        }
        code = 37 * code + this.ns.hashCode();
        code = 37 * code + this.name.hashCode();
        code = 37 * code + this.accession.hashCode();
        code = 37 * code + this.version;
        return code;
    }

    public String toString() {
        return this.getNamespace() + ":" + this.getName() + "/" + this.getAccession() + "." + this.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRankedCrossRef(RankedCrossRef crossref) throws ChangeVetoException {
        if (crossref == null) {
            throw new IllegalArgumentException("Crossref cannot be null");
        }
        if (!this.hasListeners(BioEntry.RANKEDCROSSREF)) {
            this.rankedcrossrefs.add(crossref);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.RANKEDCROSSREF, crossref, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.RANKEDCROSSREF);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rankedcrossrefs.add(crossref);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRankedCrossRef(RankedCrossRef crossref) throws ChangeVetoException {
        if (crossref == null) {
            throw new IllegalArgumentException("Crossref cannot be null");
        }
        if (!this.hasListeners(BioEntry.RANKEDCROSSREF)) {
            this.rankedcrossrefs.remove(crossref);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.RANKEDCROSSREF, null, crossref);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.RANKEDCROSSREF);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rankedcrossrefs.remove(crossref);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRankedDocRef(RankedDocRef docref) throws ChangeVetoException {
        if (docref == null) {
            throw new IllegalArgumentException("Docref cannot be null");
        }
        if (!this.hasListeners(BioEntry.RANKEDDOCREF)) {
            this.rankeddocrefs.add(docref);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.RANKEDDOCREF, docref, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.RANKEDDOCREF);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rankeddocrefs.add(docref);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRankedDocRef(RankedDocRef docref) throws ChangeVetoException {
        if (docref == null) {
            throw new IllegalArgumentException("Docref cannot be null");
        }
        if (!this.hasListeners(BioEntry.RANKEDDOCREF)) {
            this.rankeddocrefs.remove(docref);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.RANKEDDOCREF, null, docref);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.RANKEDDOCREF);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rankeddocrefs.remove(docref);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComment(Comment comment) throws ChangeVetoException {
        if (comment == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        if (!this.hasListeners(BioEntry.COMMENT)) {
            this.comments.add(comment);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.COMMENT, comment, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.COMMENT);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.comments.add(comment);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeComment(Comment comment) throws ChangeVetoException {
        if (comment == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        if (!this.hasListeners(BioEntry.COMMENT)) {
            this.comments.remove(comment);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.COMMENT, null, comment);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.COMMENT);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.comments.remove(comment);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRelationship(BioEntryRelationship relation) throws ChangeVetoException {
        if (relation == null) {
            throw new IllegalArgumentException("Relationship cannot be null");
        }
        if (!this.hasListeners(BioEntry.RELATIONS)) {
            this.relationships.add(relation);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.RELATIONS, relation, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.RELATIONS);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.relationships.add(relation);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRelationship(BioEntryRelationship relation) throws ChangeVetoException {
        if (relation == null) {
            throw new IllegalArgumentException("Relationship cannot be null");
        }
        if (!this.hasListeners(BioEntry.RELATIONS)) {
            this.relationships.remove(relation);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntry.RELATIONS, null, relation);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntry.RELATIONS);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.relationships.remove(relation);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    void setRelationships(Set relationships) {
        this.relationships = relationships;
    }

    void setNamespace(Namespace ns) {
        this.ns = ns;
    }

    void setName(String name) {
        this.name = name;
    }

    void setAccession(String acc) {
        this.accession = acc;
    }

    void setVersion(int v) {
        this.version = v;
    }

    void setRankedDocRefs(Set docrefs) {
        this.rankeddocrefs = docrefs;
    }

    void setComments(Set comments) {
        this.comments = comments;
    }

    @Override
    public void setRankedCrossRefs(Set rankedcrossrefs) {
        this.rankedcrossrefs = rankedcrossrefs;
    }

    Integer getId() {
        return this.id;
    }

    void setId(Integer id) {
        this.id = id;
    }
}

