/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio;

import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.bio.BioEntry;
import org.biojavax.bio.BioEntryRelationship;
import org.biojavax.ontology.ComparableTerm;

public class SimpleBioEntryRelationship
extends AbstractChangeable
implements BioEntryRelationship {
    private BioEntry object;
    private BioEntry subject;
    private ComparableTerm term;
    private Integer rank;
    private Integer id;

    public SimpleBioEntryRelationship(BioEntry object, BioEntry subject, ComparableTerm term, Integer rank) {
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject cannot be null");
        }
        if (term == null) {
            throw new IllegalArgumentException("Term cannot be null");
        }
        this.object = object;
        this.subject = subject;
        this.term = term;
        this.rank = rank;
    }

    protected SimpleBioEntryRelationship() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRank(Integer rank) throws ChangeVetoException {
        if (!this.hasListeners(BioEntryRelationship.RANK)) {
            this.rank = rank;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, BioEntryRelationship.RANK, rank, this.rank);
            ChangeSupport changeSupport = cs = this.getChangeSupport(BioEntryRelationship.RANK);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rank = rank;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    @Override
    public Integer getRank() {
        return this.rank;
    }

    @Override
    public BioEntry getObject() {
        return this.object;
    }

    void setObject(BioEntry object) {
        this.object = object;
    }

    @Override
    public BioEntry getSubject() {
        return this.subject;
    }

    void setSubject(BioEntry subject) {
        this.subject = subject;
    }

    @Override
    public ComparableTerm getTerm() {
        return this.term;
    }

    void setTerm(ComparableTerm term) {
        this.term = term;
    }

    public int compareTo(Object o) {
        int theirRank;
        if (this.object == null) {
            return -1;
        }
        if (this == o) {
            return 0;
        }
        BioEntryRelationship them = (BioEntryRelationship)o;
        int ourRank = this.getRank() == null ? 0 : this.rank;
        int n = theirRank = them.getRank() == null ? 0 : them.getRank();
        if (ourRank != theirRank) {
            return ourRank - theirRank;
        }
        if (!this.object.equals(them.getObject())) {
            return this.object.compareTo(them.getObject());
        }
        if (!this.subject.equals(them.getSubject())) {
            return this.subject.compareTo(them.getSubject());
        }
        return this.term.compareTo(them.getTerm());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BioEntryRelationship)) {
            return false;
        }
        if (this.object == null) {
            return false;
        }
        BioEntryRelationship them = (BioEntryRelationship)obj;
        int ourRank = this.getRank() == null ? 0 : this.rank;
        int theirRank = them.getRank() == null ? 0 : them.getRank();
        return this.subject.equals(them.getSubject()) && this.object.equals(them.getObject()) && this.term.equals(them.getTerm()) && ourRank == theirRank;
    }

    public int hashCode() {
        int code = 17;
        if (this.subject == null) {
            return code;
        }
        code = code * 37 + (this.getRank() == null ? 0 : this.rank.hashCode());
        code = code * 37 + this.object.hashCode();
        code = code * 37 + this.subject.hashCode();
        code = code * 37 + this.term.hashCode();
        return code;
    }

    public String toString() {
        return "(#" + this.rank + ") " + this.getTerm() + "(" + this.getObject() + "," + this.getSubject() + ")";
    }

    Integer getId() {
        return this.id;
    }

    void setId(Integer id) {
        this.id = id;
    }
}

