/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleComment;
import org.biojavax.SimpleCrossRef;
import org.biojavax.SimpleDocRef;
import org.biojavax.SimpleDocRefAuthor;
import org.biojavax.SimpleNamespace;
import org.biojavax.SimpleNote;
import org.biojavax.SimpleRankedCrossRef;
import org.biojavax.SimpleRankedDocRef;
import org.biojavax.bio.BioEntry;
import org.biojavax.bio.SimpleBioEntry;
import org.biojavax.bio.SimpleBioEntryRelationship;
import org.biojavax.bio.taxa.SimpleNCBITaxon;
import org.biojavax.ontology.ComparableTerm;

public class SimpleBioEntryTest
extends TestCase {
    SimpleBioEntry be;
    String name = "aaa";
    Namespace ns = RichObjectFactory.getDefaultNamespace();
    String acc = "test_acc";
    int version = 0;
    ChangeListener.ChangeEventRecorder cr = new ChangeListener.ChangeEventRecorder();

    public SimpleBioEntryTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.be = new SimpleBioEntry(this.ns, this.name, this.acc, this.version);
        this.cr = new ChangeListener.ChangeEventRecorder();
        this.be.addChangeListener(this.cr);
    }

    protected void tearDown() throws Exception {
        this.be.removeChangeListener(this.cr);
        this.be = null;
        this.cr = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleBioEntryTest.class);
        return suite;
    }

    public void testGetRankedCrossRefs() {
        System.out.println("testGetRankedCrossRefs");
        SimpleBioEntryTest.assertNotNull((Object)this.be.getRankedCrossRefs());
        SimpleBioEntryTest.assertEquals((int)0, (int)this.be.getRankedCrossRefs().size());
        try {
            this.be.getRankedCrossRefs().add(new Object());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testSetTaxon() {
        System.out.println("testSetTaxon");
        SimpleNCBITaxon tax = new SimpleNCBITaxon(1621);
        try {
            this.be.addChangeListener(this.cr);
            this.be.setTaxon(tax);
            SimpleBioEntryTest.assertNotNull((Object)this.cr.getEvent());
            SimpleBioEntryTest.assertEquals((Object)BioEntry.TAXON, (Object)this.cr.getEvent().getType());
            SimpleBioEntryTest.assertNull((Object)this.cr.getEvent().getPrevious());
            SimpleBioEntryTest.assertEquals((Object)tax, (Object)this.cr.getEvent().getChange());
            SimpleBioEntryTest.assertEquals((Object)tax, (Object)this.be.getTaxon());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetAnnotation() {
        System.out.println("testGetAnnotation");
        SimpleBioEntryTest.assertNotNull((Object)this.be.getAnnotation());
    }

    public void testGetNoteSet() {
        System.out.println("testGetNoteSet");
        SimpleBioEntryTest.assertNotNull((Object)this.be.getNoteSet());
        try {
            this.be.getNoteSet().add(new Object());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testSetNoteSet() {
        System.out.println("testSetNoteSet");
        TreeSet<SimpleNote> notes = new TreeSet<SimpleNote>();
        notes.add(new SimpleNote(RichObjectFactory.getDefaultOntology().getOrCreateTerm("foo"), "bar", 0));
        try {
            this.be.setNoteSet(notes);
            SimpleBioEntryTest.assertEquals(notes, (Object)this.be.getNoteSet());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetComments() {
        System.out.println("testGetComments");
        Set s = this.be.getComments();
        SimpleBioEntryTest.assertNotNull((Object)s);
        SimpleBioEntryTest.assertEquals((int)0, (int)s.size());
    }

    public void testGetRankedDocRefs() {
        System.out.println("testGetRankedDocRefs");
        Set s = this.be.getRankedDocRefs();
        SimpleBioEntryTest.assertNotNull((Object)s);
        SimpleBioEntryTest.assertEquals((int)0, (int)s.size());
    }

    public void testGetRelationships() {
        System.out.println("testGetRelationships");
        Set s = this.be.getRelationships();
        SimpleBioEntryTest.assertNotNull((Object)s);
        SimpleBioEntryTest.assertEquals((int)0, (int)s.size());
    }

    public void testSetIdentifier() {
        System.out.println("testSetIdentifier");
        String id = "new id";
        try {
            this.be.setIdentifier(id);
            SimpleBioEntryTest.assertEquals((String)id, (String)this.be.getIdentifier());
            ChangeEvent ce = this.cr.getEvent();
            SimpleBioEntryTest.assertNotNull((Object)ce);
            SimpleBioEntryTest.assertEquals((Object)BioEntry.IDENTIFIER, (Object)ce.getType());
            SimpleBioEntryTest.assertNull((Object)ce.getPrevious());
            SimpleBioEntryTest.assertEquals((Object)id, (Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testSetDivision() {
        System.out.println("testSetDivision");
        String div = "new div";
        try {
            this.be.setDivision(div);
            SimpleBioEntryTest.assertEquals((String)div, (String)this.be.getDivision());
            ChangeEvent ce = this.cr.getEvent();
            SimpleBioEntryTest.assertNotNull((Object)ce);
            SimpleBioEntryTest.assertEquals((Object)BioEntry.DIVISION, (Object)ce.getType());
            SimpleBioEntryTest.assertNull((Object)ce.getPrevious());
            SimpleBioEntryTest.assertEquals((Object)div, (Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testSetDescription() {
        System.out.println("testSetDescription");
        String d = "new desc";
        try {
            this.be.setDescription(d);
            SimpleBioEntryTest.assertEquals((String)d, (String)this.be.getDescription());
            ChangeEvent ce = this.cr.getEvent();
            SimpleBioEntryTest.assertNotNull((Object)ce);
            SimpleBioEntryTest.assertEquals((Object)BioEntry.DESCRIPTION, (Object)ce.getType());
            SimpleBioEntryTest.assertNull((Object)ce.getPrevious());
            SimpleBioEntryTest.assertEquals((Object)d, (Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetAccession() {
        System.out.println("testGetAccession");
        SimpleBioEntryTest.assertEquals((String)this.acc, (String)this.be.getAccession());
    }

    public void testGetDescription() {
        System.out.println("testGetDescription");
        SimpleBioEntryTest.assertNull((Object)this.be.getDescription());
    }

    public void testGetDivision() {
        System.out.println("testGetDivision");
        SimpleBioEntryTest.assertNull((Object)this.be.getDivision());
    }

    public void testGetIdentifier() {
        System.out.println("testGetIdentifier");
        SimpleBioEntryTest.assertNull((Object)this.be.getIdentifier());
    }

    public void testGetName() {
        System.out.println("testGetName");
        SimpleBioEntryTest.assertEquals((String)this.name, (String)this.be.getName());
    }

    public void testGetNamespace() {
        System.out.println("testGetNamespace");
        SimpleBioEntryTest.assertEquals((Object)this.ns, (Object)this.be.getNamespace());
    }

    public void testGetTaxon() {
        System.out.println("testGetTaxon");
        SimpleBioEntryTest.assertNull((Object)this.be.getTaxon());
    }

    public void testGetVersion() {
        System.out.println("testGetVersion");
        SimpleBioEntryTest.assertEquals((int)this.version, (int)this.be.getVersion());
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleBioEntryTest.assertFalse((boolean)this.be.equals(new Object()));
        SimpleBioEntryTest.assertFalse((boolean)this.be.equals(null));
        SimpleBioEntryTest.assertTrue((boolean)this.be.equals(this.be));
        SimpleBioEntry be2 = new SimpleBioEntry(this.be.getNamespace(), this.be.getName(), this.be.getAccession(), this.be.getVersion());
        SimpleBioEntryTest.assertTrue((boolean)this.be.equals(be2));
        SimpleBioEntryTest.assertTrue((boolean)((Object)be2).equals(this.be));
        try {
            be2.setDescription("test");
            SimpleBioEntryTest.assertTrue((boolean)this.be.equals(be2));
            SimpleBioEntryTest.assertTrue((boolean)((Object)be2).equals(this.be));
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        be2 = new SimpleBioEntry(new SimpleNamespace("new"), this.be.getName(), this.be.getAccession(), this.be.getVersion());
        SimpleBioEntryTest.assertFalse((boolean)this.be.equals(be2));
        SimpleBioEntryTest.assertFalse((boolean)((Object)be2).equals(this.be));
        be2 = new SimpleBioEntry(this.be.getNamespace(), "different", this.be.getAccession(), this.be.getVersion());
        SimpleBioEntryTest.assertFalse((boolean)this.be.equals(be2));
        SimpleBioEntryTest.assertFalse((boolean)((Object)be2).equals(this.be));
        be2 = new SimpleBioEntry(this.be.getNamespace(), this.be.getName(), "different", this.be.getVersion());
        SimpleBioEntryTest.assertFalse((boolean)this.be.equals(be2));
        SimpleBioEntryTest.assertFalse((boolean)((Object)be2).equals(this.be));
        be2 = new SimpleBioEntry(this.be.getNamespace(), this.be.getName(), this.be.getAccession(), this.be.getVersion() + 1);
        SimpleBioEntryTest.assertFalse((boolean)this.be.equals(be2));
        SimpleBioEntryTest.assertFalse((boolean)((Object)be2).equals(this.be));
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleBioEntryTest.assertTrue((this.be.compareTo(this.be) == 0 ? 1 : 0) != 0);
        SimpleBioEntry be2 = new SimpleBioEntry(this.be.getNamespace(), this.be.getName(), this.be.getAccession(), this.be.getVersion());
        SimpleBioEntryTest.assertTrue((this.be.compareTo(be2) == 0 ? 1 : 0) != 0);
        SimpleBioEntryTest.assertTrue((be2.compareTo(this.be) == 0 ? 1 : 0) != 0);
        try {
            be2.setDescription("test");
            SimpleBioEntryTest.assertTrue((this.be.compareTo(be2) == 0 ? 1 : 0) != 0);
            SimpleBioEntryTest.assertTrue((be2.compareTo(this.be) == 0 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        be2 = new SimpleBioEntry(new SimpleNamespace("new"), this.be.getName(), this.be.getAccession(), this.be.getVersion());
        SimpleBioEntryTest.assertTrue((this.be.compareTo(be2) < 0 ? 1 : 0) != 0);
        SimpleBioEntryTest.assertTrue((be2.compareTo(this.be) > 0 ? 1 : 0) != 0);
        be2 = new SimpleBioEntry(this.be.getNamespace(), "different", this.be.getAccession(), this.be.getVersion());
        SimpleBioEntryTest.assertTrue((this.be.compareTo(be2) < 0 ? 1 : 0) != 0);
        SimpleBioEntryTest.assertTrue((be2.compareTo(this.be) > 0 ? 1 : 0) != 0);
        be2 = new SimpleBioEntry(this.be.getNamespace(), this.be.getName(), "different", this.be.getVersion());
        SimpleBioEntryTest.assertTrue((this.be.compareTo(be2) > 0 ? 1 : 0) != 0);
        SimpleBioEntryTest.assertTrue((be2.compareTo(this.be) < 0 ? 1 : 0) != 0);
        be2 = new SimpleBioEntry(this.be.getNamespace(), this.be.getName(), this.be.getAccession(), this.be.getVersion() + 1);
        SimpleBioEntryTest.assertTrue((this.be.compareTo(be2) < 0 ? 1 : 0) != 0);
        SimpleBioEntryTest.assertTrue((be2.compareTo(this.be) > 0 ? 1 : 0) != 0);
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        SimpleBioEntry be2 = new SimpleBioEntry(this.be.getNamespace(), this.be.getName(), this.be.getAccession(), this.be.getVersion());
        SimpleBioEntryTest.assertTrue((this.be.hashCode() == ((Object)be2).hashCode() ? 1 : 0) != 0);
        try {
            be2.setDescription("test");
            SimpleBioEntryTest.assertTrue((this.be.hashCode() == ((Object)be2).hashCode() ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testToString() {
        System.out.println("testToString");
        String expected = this.be.getNamespace() + ":" + this.be.getName() + "/" + this.be.getAccession() + "." + this.be.getVersion();
        SimpleBioEntryTest.assertEquals((String)expected, (String)this.be.toString());
    }

    public void testAddRankedCrossRef() {
        System.out.println("testAddRankedCrossRef");
        try {
            this.be.addRankedCrossRef(null);
            SimpleBioEntryTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRankedCrossRef xref = new SimpleRankedCrossRef(new SimpleCrossRef("dbname", "AC123456", 1), 0);
        try {
            this.be.addRankedCrossRef(xref);
            SimpleBioEntryTest.assertTrue((boolean)this.be.getRankedCrossRefs().contains(xref));
            ChangeEvent ce = this.cr.getEvent();
            SimpleBioEntryTest.assertNotNull((Object)ce);
            SimpleBioEntryTest.assertEquals((Object)BioEntry.RANKEDCROSSREF, (Object)ce.getType());
            SimpleBioEntryTest.assertNull((Object)ce.getPrevious());
            SimpleBioEntryTest.assertEquals((Object)xref, (Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testRemoveRankedCrossRef() {
        System.out.println("testRemoveRankedCrossRef");
        SimpleRankedCrossRef xref = new SimpleRankedCrossRef(new SimpleCrossRef("dbname", "AC123456", 1), 0);
        try {
            this.be.addRankedCrossRef(xref);
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            this.be.removeRankedCrossRef(null);
            SimpleBioEntryTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            this.be.removeRankedCrossRef(xref);
            SimpleBioEntryTest.assertFalse((boolean)this.be.getRankedCrossRefs().contains(xref));
            ChangeEvent ce = this.cr.getEvent();
            SimpleBioEntryTest.assertNotNull((Object)ce);
            SimpleBioEntryTest.assertEquals((Object)BioEntry.RANKEDCROSSREF, (Object)ce.getType());
            SimpleBioEntryTest.assertEquals((Object)xref, (Object)ce.getPrevious());
            SimpleBioEntryTest.assertNull((Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testAddRankedDocRef() {
        System.out.println("testAddRankedDocRef");
        try {
            this.be.addRankedDocRef(null);
            SimpleBioEntryTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleDocRefAuthor author = new SimpleDocRefAuthor("Hemmingway");
        SimpleRankedDocRef ref = new SimpleRankedDocRef(new SimpleDocRef(Collections.singletonList(author), "a book", "a title"), new Integer(1), new Integer(10), 0);
        try {
            this.be.addRankedDocRef(ref);
            SimpleBioEntryTest.assertTrue((boolean)this.be.getRankedDocRefs().contains(ref));
            ChangeEvent ce = this.cr.getEvent();
            SimpleBioEntryTest.assertNotNull((Object)ce);
            SimpleBioEntryTest.assertEquals((Object)BioEntry.RANKEDDOCREF, (Object)ce.getType());
            SimpleBioEntryTest.assertNull((Object)ce.getPrevious());
            SimpleBioEntryTest.assertEquals((Object)ref, (Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testRemoveRankedDocRef() {
        System.out.println("testRemoveRankedDocRef");
        try {
            this.be.removeRankedDocRef(null);
            SimpleBioEntryTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleDocRefAuthor author = new SimpleDocRefAuthor("Hemmingway");
        SimpleRankedDocRef ref = new SimpleRankedDocRef(new SimpleDocRef(Collections.singletonList(author), "a book", "a title"), new Integer(1), new Integer(10), 0);
        try {
            this.be.addRankedDocRef(ref);
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            this.be.removeRankedDocRef(ref);
            SimpleBioEntryTest.assertFalse((boolean)this.be.getRankedCrossRefs().contains(ref));
            ChangeEvent ce = this.cr.getEvent();
            SimpleBioEntryTest.assertNotNull((Object)ce);
            SimpleBioEntryTest.assertEquals((Object)BioEntry.RANKEDDOCREF, (Object)ce.getType());
            SimpleBioEntryTest.assertEquals((Object)ref, (Object)ce.getPrevious());
            SimpleBioEntryTest.assertNull((Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testAddComment() {
        System.out.println("testAddComment");
        try {
            this.be.addComment(null);
            SimpleBioEntryTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleComment com = new SimpleComment("comment", 0);
        try {
            this.be.addComment(com);
            SimpleBioEntryTest.assertTrue((boolean)this.be.getComments().contains(com));
            ChangeEvent ce = this.cr.getEvent();
            SimpleBioEntryTest.assertNotNull((Object)ce);
            SimpleBioEntryTest.assertEquals((Object)BioEntry.COMMENT, (Object)ce.getType());
            SimpleBioEntryTest.assertNull((Object)ce.getPrevious());
            SimpleBioEntryTest.assertEquals((Object)com, (Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testRemoveComment() {
        System.out.println("testRemoveComment");
        try {
            this.be.removeComment(null);
            SimpleBioEntryTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleComment com = new SimpleComment("comment", 0);
        try {
            this.be.addComment(com);
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            this.be.removeComment(com);
            SimpleBioEntryTest.assertFalse((boolean)this.be.getComments().contains(com));
            ChangeEvent ce = this.cr.getEvent();
            SimpleBioEntryTest.assertNotNull((Object)ce);
            SimpleBioEntryTest.assertEquals((Object)BioEntry.COMMENT, (Object)ce.getType());
            SimpleBioEntryTest.assertEquals((Object)com, (Object)ce.getPrevious());
            SimpleBioEntryTest.assertNull((Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testAddRelationship() {
        System.out.println("testAddRelationship");
        try {
            this.be.addRelationship(null);
            SimpleBioEntryTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleBioEntry be2 = new SimpleBioEntry(this.be.getNamespace(), "different", this.be.getAccession(), this.be.getVersion());
        ComparableTerm term = RichObjectFactory.getDefaultOntology().getOrCreateTerm("foo");
        SimpleBioEntryRelationship rel = new SimpleBioEntryRelationship(this.be, be2, term, new Integer(0));
        try {
            this.be.addRelationship(rel);
            SimpleBioEntryTest.assertTrue((boolean)this.be.getRelationships().contains(rel));
            ChangeEvent ce = this.cr.getEvent();
            SimpleBioEntryTest.assertNotNull((Object)ce);
            SimpleBioEntryTest.assertEquals((Object)BioEntry.RELATIONS, (Object)ce.getType());
            SimpleBioEntryTest.assertNull((Object)ce.getPrevious());
            SimpleBioEntryTest.assertEquals((Object)rel, (Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testRemoveRelationship() {
        System.out.println("testRemoveRelationship");
        try {
            this.be.removeRelationship(null);
            SimpleBioEntryTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleBioEntry be2 = new SimpleBioEntry(this.be.getNamespace(), "different", this.be.getAccession(), this.be.getVersion());
        ComparableTerm term = RichObjectFactory.getDefaultOntology().getOrCreateTerm("foo");
        SimpleBioEntryRelationship rel = new SimpleBioEntryRelationship(this.be, be2, term, new Integer(0));
        try {
            this.be.addRelationship(rel);
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            this.be.removeRelationship(rel);
            SimpleBioEntryTest.assertFalse((boolean)this.be.getRelationships().contains(rel));
            ChangeEvent ce = this.cr.getEvent();
            SimpleBioEntryTest.assertNotNull((Object)ce);
            SimpleBioEntryTest.assertEquals((Object)BioEntry.RELATIONS, (Object)ce.getType());
            SimpleBioEntryTest.assertEquals((Object)rel, (Object)ce.getPrevious());
            SimpleBioEntryTest.assertNull((Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testSetRankedCrossRefs() {
        System.out.println("testSetRankedCrossRefs");
        TreeSet<SimpleRankedCrossRef> s = new TreeSet<SimpleRankedCrossRef>();
        s.add(new SimpleRankedCrossRef(new SimpleCrossRef("dbname", "AC123456", 1), 0));
        try {
            this.be.setRankedCrossRefs(s);
            SimpleBioEntryTest.assertEquals(s, (Object)this.be.getRankedCrossRefs());
        }
        catch (Exception ex) {
            SimpleBioEntryTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }
}

