/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.seq.io.ParseException;
import org.biojavax.bio.phylo.io.nexus.NexusBlock;
import org.biojavax.bio.phylo.io.nexus.NexusComment;
import org.biojavax.bio.phylo.io.nexus.NexusFileFormat;

public class DistancesBlock
extends NexusBlock.Abstract {
    public static final String DISTANCES_BLOCK = "DISTANCES";
    private int dimensionsNTax = 0;
    private int dimensionsNChar = 0;
    private String triangle = "LOWER";
    private boolean diagonal = true;
    private boolean labels = true;
    private String missing = "?";
    private boolean interleaved = false;
    private List taxLabels = new ArrayList();
    private Map matrix = new LinkedHashMap();
    private List comments = new ArrayList();

    public DistancesBlock() {
        super(DISTANCES_BLOCK);
    }

    public void setDimensionsNTax(int dimensionsNTax) {
        this.dimensionsNTax = dimensionsNTax;
    }

    public int getDimensionsNTax() {
        return this.dimensionsNTax;
    }

    public void setDimensionsNChar(int dimensionsNChar) {
        this.dimensionsNChar = dimensionsNChar;
    }

    public int getDimensionsNChar() {
        return this.dimensionsNChar;
    }

    public void setTriangle(String triangle) {
        this.triangle = triangle;
    }

    public void setDiagonal(boolean diagonal) {
        this.diagonal = diagonal;
    }

    public boolean isDiagonal() {
        return this.diagonal;
    }

    public void setLabels(boolean labels) {
        this.labels = labels;
    }

    public boolean isLabels() {
        return this.labels;
    }

    public void setMissing(String missing) {
        this.missing = missing;
    }

    public String getMissing() {
        return this.missing;
    }

    public void setInterleaved(boolean interleaved) {
        this.interleaved = interleaved;
    }

    public boolean isInterleaved() {
        return this.interleaved;
    }

    public void addTaxLabel(String taxLabel) throws ParseException {
        if (this.taxLabels.contains(taxLabel)) {
            throw new ParseException("Duplicate taxa label: " + taxLabel);
        }
        try {
            int i = Integer.parseInt(taxLabel);
            if (i <= this.taxLabels.size() + 1) {
                throw new ParseException("Taxa label " + i + " refers to already extant taxa position");
            }
        }
        catch (NumberFormatException e) {
        }
        catch (ParseException e) {
            throw e;
        }
        this.taxLabels.add(taxLabel);
    }

    public void removeTaxLabel(String taxLabel) {
        this.taxLabels.remove(taxLabel);
    }

    public boolean containsTaxLabel(String taxLabel) {
        if (this.taxLabels.contains(taxLabel)) {
            return true;
        }
        try {
            int i = Integer.parseInt(taxLabel);
            if (i <= this.taxLabels.size() + 1) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public List getTaxLabels() {
        return this.taxLabels;
    }

    public void addMatrixEntry(String taxa) {
        if (!this.matrix.containsKey(taxa)) {
            this.matrix.put(taxa, new ArrayList());
        }
    }

    public void appendMatrixData(String taxa, Object data) {
        ((List)this.matrix.get(taxa)).add(data);
    }

    public List getMatrixData(String taxa) {
        return (List)this.matrix.get(taxa);
    }

    public Collection getMatrixLabels() {
        return Collections.unmodifiableSet(this.matrix.keySet());
    }

    public void addComment(NexusComment comment) {
        this.comments.add(comment);
    }

    public void removeComment(NexusComment comment) {
        this.comments.remove(comment);
    }

    public List getComments() {
        return this.comments;
    }

    @Override
    protected void writeBlockContents(Writer writer) throws IOException {
        Iterator<Object> i = this.comments.iterator();
        while (i.hasNext()) {
            ((NexusComment)i.next()).writeObject(writer);
            writer.write(NexusFileFormat.NEW_LINE);
        }
        writer.write(" DIMENSIONS ");
        if (!this.taxLabels.isEmpty()) {
            writer.write("NEWTAXA ");
        }
        if (this.dimensionsNTax > 0) {
            writer.write("NTAX=" + this.dimensionsNTax + " ");
        }
        writer.write("NCHAR=" + this.dimensionsNChar + ";" + NexusFileFormat.NEW_LINE);
        writer.write(" FORMAT TRIANGLE=");
        this.writeToken(writer, this.triangle);
        writer.write(this.diagonal ? " DIAGONAL" : " NODIAGONAL");
        writer.write(this.labels ? " LABELS" : " NOLABELS");
        writer.write(" MISSING=");
        this.writeToken(writer, this.missing);
        if (this.interleaved) {
            writer.write(" INTERLEAVED");
        }
        writer.write(";" + NexusFileFormat.NEW_LINE);
        if (this.taxLabels.size() > 0) {
            writer.write(" TAXLABELS");
            i = this.taxLabels.iterator();
            while (i.hasNext()) {
                writer.write(32);
                this.writeToken(writer, (String)i.next());
            }
            writer.write(";" + NexusFileFormat.NEW_LINE);
        }
        writer.write(" MATRIX" + NexusFileFormat.NEW_LINE);
        for (Map.Entry entry : this.matrix.entrySet()) {
            writer.write(9);
            this.writeToken(writer, "" + entry.getKey());
            writer.write(9);
            Iterator j = ((List)entry.getValue()).iterator();
            while (j.hasNext()) {
                Object obj = j.next();
                if (obj instanceof String) {
                    this.writeToken(writer, (String)obj);
                }
                if (!j.hasNext()) continue;
                writer.write(9);
            }
            writer.write(NexusFileFormat.NEW_LINE);
        }
        writer.write(";" + NexusFileFormat.NEW_LINE);
    }
}

