/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import java.io.IOException;
import java.io.Writer;
import org.biojavax.bio.phylo.io.nexus.NexusFileFormat;
import org.biojavax.bio.phylo.io.nexus.NexusObject;

public interface NexusBlock
extends NexusObject {
    public String getBlockName();

    public static abstract class Abstract
    implements NexusBlock {
        private String blockName;

        public Abstract(String blockName) {
            this.blockName = blockName;
        }

        @Override
        public String getBlockName() {
            return this.blockName;
        }

        @Override
        public void writeObject(Writer writer) throws IOException {
            writer.write("BEGIN " + this.blockName + ";");
            writer.write(NexusFileFormat.NEW_LINE);
            this.writeBlockContents(writer);
            writer.write("END;");
            writer.write(NexusFileFormat.NEW_LINE);
        }

        protected void writeToken(Writer writer, String token) throws IOException {
            token = token.replaceAll("'", "''");
            if ((token = token.replaceAll("_", "'_'")).trim().length() > 0) {
                token = token.replaceAll(" ", "_");
            }
            if (token.indexOf(91) >= 0 || token.indexOf(93) >= 0) {
                token = "'" + token + "'";
            }
            writer.write(token);
        }

        protected abstract void writeBlockContents(Writer var1) throws IOException;
    }
}

