/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import org.biojava.bio.seq.io.ParseException;
import org.biojavax.bio.phylo.io.nexus.NexusBlockListener;

public interface NexusBlockParser {
    public static final String UNKNOWN_BLOCK = "__UNKNOWN";

    public void startBlock(String var1);

    public void endBlock();

    public void parseToken(String var1) throws ParseException;

    public void beginComment();

    public void endComment();

    public void endTokenGroup();

    public void commentText(String var1) throws ParseException;

    public NexusBlockListener getBlockListener();

    public boolean wantsBracketsAndBraces();

    public static abstract class Abstract
    implements NexusBlockParser {
        private NexusBlockListener blockListener;
        private String blockName;

        public Abstract(NexusBlockListener blockListener) {
            this.blockListener = blockListener;
            this.blockName = null;
        }

        @Override
        public NexusBlockListener getBlockListener() {
            return this.blockListener;
        }

        @Override
        public void startBlock(String blockName) {
            this.resetStatus();
            this.blockName = blockName;
            this.blockListener.startBlock(blockName);
        }

        protected abstract void resetStatus();

        protected String getBlockName() {
            return this.blockName;
        }

        @Override
        public void endBlock() {
            this.blockName = null;
            this.blockListener.endBlock();
        }

        @Override
        public void beginComment() {
            this.blockListener.beginComment();
        }

        @Override
        public void endComment() {
            this.blockListener.endComment();
        }

        @Override
        public void endTokenGroup() {
            this.blockListener.endTokenGroup();
        }

        @Override
        public void commentText(String comment) throws ParseException {
            this.blockListener.commentText(comment);
        }

        @Override
        public abstract void parseToken(String var1) throws ParseException;

        @Override
        public boolean wantsBracketsAndBraces() {
            return false;
        }
    }
}

