/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.seq.io.ParseException;
import org.biojavax.bio.phylo.io.nexus.CharactersBlockBuilder;
import org.biojavax.bio.phylo.io.nexus.CharactersBlockParser;
import org.biojavax.bio.phylo.io.nexus.DataBlockBuilder;
import org.biojavax.bio.phylo.io.nexus.DataBlockParser;
import org.biojavax.bio.phylo.io.nexus.DistancesBlockBuilder;
import org.biojavax.bio.phylo.io.nexus.DistancesBlockParser;
import org.biojavax.bio.phylo.io.nexus.NexusBlock;
import org.biojavax.bio.phylo.io.nexus.NexusBlockBuilder;
import org.biojavax.bio.phylo.io.nexus.NexusBlockListener;
import org.biojavax.bio.phylo.io.nexus.NexusBlockParser;
import org.biojavax.bio.phylo.io.nexus.NexusComment;
import org.biojavax.bio.phylo.io.nexus.NexusFile;
import org.biojavax.bio.phylo.io.nexus.NexusFileListener;
import org.biojavax.bio.phylo.io.nexus.TaxaBlockBuilder;
import org.biojavax.bio.phylo.io.nexus.TaxaBlockParser;
import org.biojavax.bio.phylo.io.nexus.TreesBlockBuilder;
import org.biojavax.bio.phylo.io.nexus.TreesBlockParser;

public class NexusFileBuilder
extends NexusFileListener.Abstract {
    private NexusFile file;
    private NexusComment comment;

    @Override
    public void setDefaultBlockParsers() {
        this.setBlockParser("__UNKNOWN", new UnknownBlockParser());
        this.setBlockParser("TAXA", new TaxaBlockParser(new TaxaBlockBuilder()));
        this.setBlockParser("TREES", new TreesBlockParser(new TreesBlockBuilder()));
        this.setBlockParser("CHARACTERS", new CharactersBlockParser(new CharactersBlockBuilder()));
        this.setBlockParser("DATA", new DataBlockParser(new DataBlockBuilder()));
        this.setBlockParser("DISTANCES", new DistancesBlockParser(new DistancesBlockBuilder()));
    }

    @Override
    protected void blockEnded(NexusBlockParser blockParser) {
        NexusBlockListener listener = blockParser.getBlockListener();
        if (listener instanceof NexusBlockBuilder) {
            this.file.addObject(((NexusBlockBuilder)listener).getNexusBlock());
        }
    }

    @Override
    public void startFile() {
        this.file = new NexusFile();
    }

    @Override
    public void endFile() {
    }

    public NexusFile getNexusFile() {
        return this.file;
    }

    @Override
    public void beginFileComment() {
        if (this.comment != null) {
            this.comment.openSubComment();
        } else {
            this.comment = new NexusComment();
        }
    }

    @Override
    public void fileCommentText(String comment) {
        this.comment.addCommentText(comment);
    }

    @Override
    public void endFileComment() {
        if (this.comment != null && this.comment.hasOpenSubComment()) {
            this.comment.closeSubComment();
        } else {
            this.file.addObject(this.comment);
            this.comment = null;
        }
    }

    private static class UnknownBlockParser
    extends NexusBlockParser.Abstract {
        private UnknownBlockParser() {
            super(new UnknownBlockBuilder());
        }

        @Override
        public void resetStatus() {
        }

        @Override
        public boolean wantsBracketsAndBraces() {
            return false;
        }

        @Override
        public void parseToken(String token) throws ParseException {
            ((UnknownBlockBuilder)this.getBlockListener()).getComponents().add(token);
        }

        private static class UnknownBlockBuilder
        extends NexusBlockBuilder.Abstract {
            private UnknownBlock block;

            private UnknownBlockBuilder() {
            }

            private List getComponents() {
                return this.block.getComponents();
            }

            @Override
            public void endTokenGroup() {
                if (this.getComponents().size() > 0) {
                    this.getComponents().add(";");
                }
            }

            public boolean wantsBracketsAndBraces() {
                return false;
            }

            @Override
            public void endBlock() {
            }

            @Override
            public void addComment(NexusComment comment) {
                this.getComponents().add(comment);
            }

            @Override
            public NexusBlock startBlockObject() {
                this.block = new UnknownBlock(this.getBlockName());
                return this.block;
            }

            private static class UnknownBlock
            extends NexusBlock.Abstract {
                private List components = new ArrayList();

                private UnknownBlock(String blockName) {
                    super(blockName);
                }

                private List getComponents() {
                    return this.components;
                }

                @Override
                public void writeBlockContents(Writer writer) throws IOException {
                    for (Object obj : this.components) {
                        if (obj instanceof NexusComment) {
                            ((NexusComment)obj).writeObject(writer);
                            continue;
                        }
                        this.writeToken(writer, (String)obj);
                    }
                }
            }
        }
    }
}

