/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import org.biojava.bio.seq.io.ParseException;
import org.biojavax.bio.phylo.io.nexus.NexusBlockParser;
import org.biojavax.bio.phylo.io.nexus.TaxaBlockListener;

public class TaxaBlockParser
extends NexusBlockParser.Abstract {
    private boolean expectingDimension;
    private boolean expectingNTax;
    private boolean expectingNTaxEquals;
    private boolean expectingNTaxValue;
    private boolean expectingTaxLabel;
    private boolean expectingTaxLabelValue;

    public TaxaBlockParser(TaxaBlockListener blockListener) {
        super(blockListener);
    }

    @Override
    public void resetStatus() {
        this.expectingDimension = true;
        this.expectingNTax = false;
        this.expectingNTaxEquals = false;
        this.expectingNTaxValue = false;
        this.expectingTaxLabel = false;
        this.expectingTaxLabelValue = false;
    }

    @Override
    public void parseToken(String token) throws ParseException {
        if (token.trim().length() == 0) {
            return;
        }
        if (this.expectingDimension && "DIMENSIONS".equalsIgnoreCase(token)) {
            this.expectingDimension = false;
            this.expectingNTax = true;
        } else if (this.expectingNTax && token.toUpperCase().startsWith("NTAX")) {
            this.expectingNTax = false;
            if (token.indexOf(61) >= 0) {
                String[] parts = token.split("=");
                if (parts.length > 1) {
                    this.expectingTaxLabel = true;
                    try {
                        ((TaxaBlockListener)this.getBlockListener()).setDimensionsNTax(Integer.parseInt(parts[1]));
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException("Invalid NTAX value: " + parts[1]);
                    }
                } else {
                    this.expectingNTaxValue = true;
                }
            } else {
                this.expectingNTaxEquals = true;
            }
        } else if (this.expectingNTaxEquals && token.startsWith("=")) {
            this.expectingNTaxEquals = false;
            String[] parts = token.split("=");
            if (parts.length > 1) {
                this.expectingTaxLabel = true;
                try {
                    ((TaxaBlockListener)this.getBlockListener()).setDimensionsNTax(Integer.parseInt(parts[1]));
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Invalid NTAX value: " + parts[1]);
                }
            } else {
                this.expectingNTaxValue = true;
            }
        } else if (this.expectingNTaxValue) {
            this.expectingNTaxValue = false;
            try {
                ((TaxaBlockListener)this.getBlockListener()).setDimensionsNTax(Integer.parseInt(token));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid NTAX value: " + token);
            }
            this.expectingTaxLabel = true;
        } else if (this.expectingTaxLabel && "TAXLABELS".equalsIgnoreCase(token)) {
            this.expectingTaxLabel = false;
            this.expectingTaxLabelValue = true;
        } else if (this.expectingTaxLabelValue) {
            ((TaxaBlockListener)this.getBlockListener()).addTaxLabel(token);
        } else {
            throw new ParseException("Found unexpected token " + token + " in TAXA block");
        }
    }
}

