/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import org.biojava.bio.seq.io.ParseException;
import org.biojavax.bio.phylo.io.nexus.NexusBlockParser;
import org.biojavax.bio.phylo.io.nexus.TreesBlock;
import org.biojavax.bio.phylo.io.nexus.TreesBlockListener;

public class TreesBlockParser
extends NexusBlockParser.Abstract {
    private boolean expectingTranslate;
    private boolean expectingTaxLabel;
    private boolean expectingTaxName;
    private boolean expectingTree;
    private boolean expectingTreeName;
    private boolean expectingTreeEquals;
    private boolean expectingTreeContent;
    private boolean expectingTreeRooted;
    private String currentTaxLabel;
    private String currentTreeName;
    private boolean currentTreeStarred;
    private StringBuffer currentTreeRoot = new StringBuffer();
    private StringBuffer currentTreeContent = new StringBuffer();

    @Override
    public void beginComment() {
        if (!this.expectingTreeRooted) {
            super.beginComment();
        }
    }

    @Override
    public void commentText(String comment) throws ParseException {
        if (this.expectingTreeRooted) {
            this.currentTreeRoot.append(comment);
        } else {
            super.commentText(comment);
        }
    }

    @Override
    public void endComment() {
        if (!this.expectingTreeRooted) {
            super.endComment();
        }
    }

    public TreesBlockParser(TreesBlockListener blockListener) {
        super(blockListener);
    }

    @Override
    public void resetStatus() {
        this.expectingTranslate = true;
        this.expectingTaxLabel = false;
        this.expectingTaxName = false;
        this.expectingTree = true;
        this.expectingTreeName = false;
        this.expectingTreeEquals = false;
        this.expectingTreeRooted = false;
        this.expectingTreeContent = false;
        this.currentTaxLabel = null;
        this.currentTreeStarred = false;
        this.currentTreeName = null;
        this.currentTreeRoot.setLength(0);
        this.currentTreeContent.setLength(0);
    }

    @Override
    public void parseToken(String token) throws ParseException {
        if (token.trim().length() == 0) {
            return;
        }
        if (this.expectingTranslate && "TRANSLATE".equalsIgnoreCase(token)) {
            this.expectingTranslate = false;
            this.expectingTaxLabel = true;
            this.expectingTree = false;
        } else if (this.expectingTaxLabel) {
            this.currentTaxLabel = token;
            this.expectingTaxLabel = false;
            this.expectingTaxName = true;
        } else if (this.expectingTaxName) {
            boolean endsWithComma = token.endsWith(",");
            String taxName = endsWithComma ? token.substring(0, token.length() - 1) : token;
            ((TreesBlockListener)this.getBlockListener()).addTranslation(this.currentTaxLabel, taxName);
            this.expectingTaxName = false;
            if (!endsWithComma) {
                this.expectingTree = true;
            } else {
                this.expectingTaxLabel = true;
            }
        } else if (this.expectingTree && "TREE".equalsIgnoreCase(token)) {
            this.expectingTree = false;
            this.expectingTreeName = true;
        } else if (this.expectingTreeName) {
            if ("*".equals(token)) {
                this.currentTreeStarred = true;
            } else {
                this.expectingTreeName = false;
                if (token.indexOf("=") >= 0) {
                    String[] parts = token.split("=");
                    this.currentTreeName = parts[0];
                    if (parts.length > 1) {
                        this.currentTreeContent.append(token);
                        this.expectingTreeRooted = false;
                    }
                    this.expectingTreeContent = true;
                } else {
                    this.currentTreeName = token;
                    this.expectingTreeEquals = true;
                }
            }
        } else if (this.expectingTreeEquals && token.startsWith("=")) {
            this.expectingTreeEquals = false;
            String[] parts = token.split("=");
            if (parts.length > 1) {
                this.currentTreeContent.append(parts[1]);
                this.expectingTreeRooted = false;
            } else {
                this.expectingTreeRooted = true;
            }
            this.expectingTreeContent = true;
        } else if (this.expectingTreeContent) {
            this.currentTreeContent.append(token);
            this.expectingTreeRooted = false;
        } else {
            throw new ParseException("Found unexpected token " + token + " in TREES block");
        }
    }

    @Override
    public void endTokenGroup() {
        if (this.expectingTreeContent) {
            TreesBlock.NewickTreeString tree = new TreesBlock.NewickTreeString();
            tree.setRootType(this.currentTreeRoot.toString());
            tree.setTreeString(this.currentTreeContent.toString());
            tree.setStarred(this.currentTreeStarred);
            ((TreesBlockListener)this.getBlockListener()).addTree(this.currentTreeName, tree);
            this.currentTreeContent.setLength(0);
            this.currentTreeName = null;
            this.currentTreeRoot.setLength(0);
            this.currentTreeStarred = false;
            this.expectingTreeRooted = false;
            this.expectingTreeContent = false;
            this.expectingTree = true;
        } else {
            super.endTokenGroup();
        }
    }
}

