/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class InfinitelyAmbiguousSymbolList
implements SymbolList {
    private FiniteAlphabet fa;
    private Symbol sym;

    public InfinitelyAmbiguousSymbolList(FiniteAlphabet fa) {
        this.fa = fa;
        this.sym = AlphabetManager.getAllAmbiguitySymbol(fa);
    }

    @Override
    public void addChangeListener(ChangeListener cl) {
    }

    @Override
    public void addChangeListener(ChangeListener cl, ChangeType ct) {
    }

    @Override
    public void edit(Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
    }

    @Override
    public Alphabet getAlphabet() {
        return this.fa;
    }

    @Override
    public boolean isUnchanging(ChangeType ct) {
        return true;
    }

    @Override
    public Iterator iterator() {
        return Collections.singletonList(this.sym).iterator();
    }

    @Override
    public int length() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void removeChangeListener(ChangeListener cl) {
    }

    @Override
    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
    }

    @Override
    public String seqString() {
        return this.sym.toString();
    }

    @Override
    public SymbolList subList(int start, int end) throws IndexOutOfBoundsException {
        return this;
    }

    @Override
    public String subStr(int start, int end) throws IndexOutOfBoundsException {
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        StringBuffer sb = new StringBuffer();
        String symStr = this.sym.toString();
        while (max-- >= min) {
            sb.append(symStr);
        }
        return sb.toString();
    }

    @Override
    public Symbol symbolAt(int index) throws IndexOutOfBoundsException {
        return this.sym;
    }

    @Override
    public List toList() {
        return Collections.singletonList(this.sym);
    }
}

