/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.util.Vector;
import junit.framework.TestCase;
import org.biojavax.SimpleCrossRef;
import org.biojavax.bio.seq.MultiSourceCompoundRichLocation;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.SimpleRichLocation;

public class MultiSourceCompoundRichLocationTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimplePosition p1 = new SimplePosition(23);
        SimplePosition p2 = new SimplePosition(36);
        SimplePosition p3 = new SimplePosition(44);
        SimplePosition p4 = new SimplePosition(55);
        SimpleCrossRef cr1 = new SimpleCrossRef("GenBank", "A12345", 3);
        SimpleRichLocation loc1 = new SimpleRichLocation(p1, p2, 0, RichLocation.Strand.POSITIVE_STRAND, cr1);
        SimpleRichLocation loc2 = new SimpleRichLocation(p3, p4, 0, RichLocation.Strand.NEGATIVE_STRAND, cr1);
        Vector<SimpleRichLocation> c1 = new Vector<SimpleRichLocation>();
        c1.add(loc1);
        c1.add(loc2);
        RichLocation r1 = RichLocation.Tools.construct(c1);
        MultiSourceCompoundRichLocationTest.assertTrue((boolean)(r1 instanceof MultiSourceCompoundRichLocation));
        RichLocation r2 = RichLocation.Tools.construct(c1);
        MultiSourceCompoundRichLocationTest.assertTrue((boolean)(r2 instanceof MultiSourceCompoundRichLocation));
        MultiSourceCompoundRichLocationTest.assertTrue((boolean)r1.equals(r2));
        SimpleCrossRef cr2 = new SimpleCrossRef("another", "A12345", 3);
        SimpleRichLocation loc3 = new SimpleRichLocation(p3, p4, 0, RichLocation.Strand.NEGATIVE_STRAND, cr2);
        c1.remove(loc2);
        c1.add(loc3);
        RichLocation r3 = RichLocation.Tools.construct(c1);
        MultiSourceCompoundRichLocationTest.assertTrue((boolean)(r2 instanceof MultiSourceCompoundRichLocation));
        MultiSourceCompoundRichLocationTest.assertFalse((boolean)r1.equals(r3));
    }
}

