/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.util.HashSet;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.biojava.bio.symbol.SymbolList;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNamespace;
import org.biojavax.SimpleNote;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.SimpleRichFeature;
import org.biojavax.bio.seq.SimpleRichLocation;
import org.biojavax.bio.seq.SimpleRichSequence;
import org.biojavax.ontology.ComparableTerm;

public class SimpleRichFeatureTest
extends TestCase {
    private SimpleRichFeature richFeature;

    private ComparableTerm makeTerm(String term) {
        return RichObjectFactory.getDefaultOntology().getOrCreateTerm(term);
    }

    protected void setUp() throws Exception {
        SimpleRichSequence parent = new SimpleRichSequence((Namespace)new SimpleNamespace("testns"), "foo", "test_acc", 1, SymbolList.EMPTY_LIST, null);
        RichFeature.Template templ = new RichFeature.Template();
        templ.location = new SimpleRichLocation(new SimplePosition(1), 1);
        templ.sourceTerm = this.makeTerm("unknown");
        templ.typeTerm = this.makeTerm("CDS");
        templ.annotation = new SimpleRichAnnotation();
        this.richFeature = new SimpleRichFeature(parent, templ);
        this.richFeature.setRank(0);
    }

    public void testEquals() {
        SimpleRichFeatureTest.assertFalse((boolean)this.richFeature.equals(new Object()));
        SimpleRichFeatureTest.assertFalse((boolean)this.richFeature.equals(null));
        SimpleRichFeatureTest.assertTrue((boolean)this.richFeature.equals(this.richFeature));
        SimpleRichFeature richFeature2 = null;
        try {
            richFeature2 = new SimpleRichFeature(this.richFeature.getParent(), this.richFeature.makeTemplate());
            richFeature2.setRank(0);
        }
        catch (Exception e) {
            SimpleRichFeatureTest.fail((String)("Unexpected exception: " + e));
        }
        SimpleRichFeatureTest.assertTrue((boolean)this.richFeature.equals(richFeature2));
        SimpleRichFeatureTest.assertTrue((boolean)richFeature2.equals(this.richFeature));
        try {
            HashSet<SimpleNote> notes = new HashSet<SimpleNote>();
            notes.add(new SimpleNote(this.makeTerm("something"), "a value", 1));
            richFeature2.setNoteSet(notes);
            SimpleRichFeatureTest.assertTrue((boolean)this.richFeature.equals(richFeature2));
            SimpleRichFeatureTest.assertTrue((boolean)richFeature2.equals(this.richFeature));
        }
        catch (Exception ex) {
            SimpleRichFeatureTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichSequence otherParent = new SimpleRichSequence((Namespace)new SimpleNamespace("anotherns"), "foo", "another_acc", 2, SymbolList.EMPTY_LIST, null);
        try {
            richFeature2 = new SimpleRichFeature(otherParent, this.richFeature.makeTemplate());
            richFeature2.setRank(0);
        }
        catch (Exception e) {
            SimpleRichFeatureTest.fail((String)("Not expecting " + e.getClass().getName()));
        }
        SimpleRichFeatureTest.assertFalse((boolean)this.richFeature.equals(richFeature2));
        SimpleRichFeatureTest.assertFalse((boolean)richFeature2.equals(this.richFeature));
        RichFeature.Template otherTempl = new RichFeature.Template();
        otherTempl.location = new SimpleRichLocation(new SimplePosition(1), 1);
        otherTempl.sourceTerm = this.makeTerm("unknown");
        otherTempl.typeTerm = this.makeTerm("promoter");
        otherTempl.annotation = new SimpleRichAnnotation();
        try {
            richFeature2 = new SimpleRichFeature(this.richFeature.getParent(), otherTempl);
            richFeature2.setRank(0);
        }
        catch (Exception e) {
            SimpleRichFeatureTest.fail((String)("Unexpected exception: " + e));
        }
        SimpleRichFeatureTest.assertFalse((boolean)this.richFeature.equals(richFeature2));
        SimpleRichFeatureTest.assertFalse((boolean)richFeature2.equals(this.richFeature));
    }

    public void testCompareTo() {
        SimpleRichFeatureTest.assertTrue((this.richFeature.compareTo(this.richFeature) == 0 ? 1 : 0) != 0);
        SimpleRichFeature richFeature2 = null;
        try {
            richFeature2 = new SimpleRichFeature(this.richFeature.getParent(), this.richFeature.makeTemplate());
            richFeature2.setRank(0);
        }
        catch (Exception e) {
            SimpleRichFeatureTest.fail((String)("Unexpected exception: " + e));
        }
        SimpleRichFeatureTest.assertTrue((this.richFeature.compareTo(richFeature2) == 0 ? 1 : 0) != 0);
        SimpleRichFeatureTest.assertTrue((richFeature2.compareTo(this.richFeature) == 0 ? 1 : 0) != 0);
        try {
            HashSet<SimpleNote> notes = new HashSet<SimpleNote>();
            notes.add(new SimpleNote(this.makeTerm("something"), "a value", 1));
            richFeature2.setNoteSet(notes);
            SimpleRichFeatureTest.assertTrue((this.richFeature.compareTo(richFeature2) == 0 ? 1 : 0) != 0);
            SimpleRichFeatureTest.assertTrue((richFeature2.compareTo(this.richFeature) == 0 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            SimpleRichFeatureTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichSequence otherParent = new SimpleRichSequence((Namespace)new SimpleNamespace("anotherns"), "foo", "another_acc", 2, SymbolList.EMPTY_LIST, null);
        try {
            richFeature2 = new SimpleRichFeature(otherParent, this.richFeature.makeTemplate());
            richFeature2.setRank(0);
        }
        catch (Exception ex) {
            SimpleRichFeatureTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichFeatureTest.assertTrue((this.richFeature.compareTo(richFeature2) > 0 ? 1 : 0) != 0);
        SimpleRichFeatureTest.assertTrue((richFeature2.compareTo(this.richFeature) < 0 ? 1 : 0) != 0);
        RichFeature.Template otherTempl = new RichFeature.Template();
        otherTempl.location = new SimpleRichLocation(new SimplePosition(1), 1);
        otherTempl.sourceTerm = this.makeTerm("unknown");
        otherTempl.typeTerm = this.makeTerm("promoter");
        otherTempl.annotation = new SimpleRichAnnotation();
        try {
            richFeature2 = new SimpleRichFeature(this.richFeature.getParent(), otherTempl);
            richFeature2.setRank(0);
        }
        catch (Exception ex) {
            SimpleRichFeatureTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichFeatureTest.assertTrue((this.richFeature.compareTo(richFeature2) < 0 ? 1 : 0) != 0);
        SimpleRichFeatureTest.assertTrue((richFeature2.compareTo(this.richFeature) > 0 ? 1 : 0) != 0);
        otherTempl.typeTerm = this.makeTerm("CDS");
        otherTempl.sourceTerm = this.makeTerm("known");
        try {
            richFeature2 = new SimpleRichFeature(this.richFeature.getParent(), otherTempl);
            richFeature2.setRank(0);
        }
        catch (Exception ex) {
            SimpleRichFeatureTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichFeatureTest.assertTrue((this.richFeature.compareTo(richFeature2) > 0 ? 1 : 0) != 0);
        SimpleRichFeatureTest.assertTrue((richFeature2.compareTo(this.richFeature) < 0 ? 1 : 0) != 0);
    }

    public void testHashCode() {
        SimpleRichFeature richFeature2 = null;
        try {
            richFeature2 = new SimpleRichFeature(this.richFeature.getParent(), this.richFeature.makeTemplate());
            richFeature2.setRank(0);
        }
        catch (Exception e) {
            SimpleRichFeatureTest.fail((String)("Unexpected exception: " + e));
        }
        SimpleRichFeatureTest.assertTrue((this.richFeature.hashCode() == richFeature2.hashCode() ? 1 : 0) != 0);
        try {
            HashSet<SimpleNote> notes = new HashSet<SimpleNote>();
            notes.add(new SimpleNote(this.makeTerm("something"), "a value", 1));
            richFeature2.setNoteSet(notes);
        }
        catch (Exception ex) {
            SimpleRichFeatureTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleRichFeatureTest.assertTrue((this.richFeature.hashCode() == richFeature2.hashCode() ? 1 : 0) != 0);
    }

    public void testFeatureSet() {
        TreeSet<SimpleRichFeature> set = new TreeSet<SimpleRichFeature>();
        set.add(this.richFeature);
        SimpleRichFeatureTest.assertTrue((boolean)set.contains(this.richFeature));
        SimpleRichFeatureTest.assertEquals((int)1, (int)set.size());
        set.remove(this.richFeature);
        SimpleRichFeatureTest.assertFalse((boolean)set.contains(this.richFeature));
        SimpleRichFeatureTest.assertEquals((int)0, (int)set.size());
    }
}

