/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.GenbankFormat;
import org.biojavax.bio.seq.io.SimpleRichSequenceBuilder;

public class Bug2249_2248Test
extends TestCase {
    private GenbankFormat gbFormat;

    protected void setUp() {
        this.gbFormat = new GenbankFormat();
    }

    protected void tearDown() throws Exception {
        this.gbFormat = null;
    }

    public void testBug2249_2248() {
        String filename = "/files/AAX56332.gp";
        RichSequence seq = this.readFile(filename);
        Bug2249_2248Test.assertEquals((String)"AAX56332", (String)seq.getAccession());
        Bug2249_2248Test.assertFalse((boolean)seq.getCircular());
        Bug2249_2248Test.assertEquals((String)"PRI", (String)seq.getDivision());
        Object lengthType = null;
        String molType = null;
        for (Note n : seq.getNoteSet()) {
            if (!n.getTerm().equals(GenbankFormat.Terms.getMolTypeTerm())) continue;
            molType = n.getValue();
        }
        Bug2249_2248Test.assertNull(molType);
        OutputStream nos = new OutputStream(){

            @Override
            public void write(int b) {
            }

            @Override
            public void write(byte[] b) {
            }

            @Override
            public void write(byte[] b, int off, int len) {
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
        try {
            RichSequence.IOTools.writeUniProt(nos, seq, seq.getNamespace());
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug2249_2248Test.fail((String)("Unexpected exception: " + e));
        }
    }

    private RichSequence readFile(String filename) {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        SymbolTokenization tokenization = RichSequence.IOTools.getProteinParser();
        Namespace namespace = RichObjectFactory.getDefaultNamespace();
        SimpleRichSequenceBuilder builder = new SimpleRichSequenceBuilder();
        RichSequence sequence = null;
        try {
            this.gbFormat.readRichSequence(br, tokenization, builder, namespace);
            sequence = builder.makeRichSequence();
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug2249_2248Test.fail((String)("Unexpected exception: " + e));
        }
        return sequence;
    }
}

