/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.GenbankFormat;
import org.biojavax.bio.seq.io.SimpleRichSequenceBuilder;

public class Bug2250_2256Test
extends TestCase {
    private GenbankFormat gbFormat;

    protected void setUp() {
        this.gbFormat = new GenbankFormat();
    }

    protected void tearDown() throws Exception {
        this.gbFormat = null;
    }

    public void testBug2250_2256() {
        String filename = "/files/AL121964.gb";
        RichSequence seq = this.readFile(filename);
        Bug2250_2256Test.assertEquals((String)"AL121964", (String)seq.getAccession());
        Bug2250_2256Test.assertEquals((String)"HSJ154G14", (String)seq.getName());
        Bug2250_2256Test.assertFalse((boolean)seq.getCircular());
        Bug2250_2256Test.assertEquals((String)"PRI", (String)seq.getDivision());
        String udat = null;
        String molType = seq.getAlphabet().getName();
        for (Note n : seq.getNoteSet()) {
            if (n.getTerm().equals(GenbankFormat.Terms.getDateUpdatedTerm())) {
                udat = n.getValue();
                continue;
            }
            if (!n.getTerm().equals(GenbankFormat.Terms.getMolTypeTerm())) continue;
            molType = n.getValue();
        }
        Bug2250_2256Test.assertNotNull(udat);
        Bug2250_2256Test.assertEquals((String)"18-MAY-2005", udat);
        Bug2250_2256Test.assertNotNull((Object)molType);
        Bug2250_2256Test.assertEquals((String)"DNA", (String)molType);
        Bug2250_2256Test.assertEquals((int)1, (int)((RichLocation)((RichFeature)seq.getFeatureSet().iterator().next()).getLocation()).getRank());
    }

    private RichSequence readFile(String filename) {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        SymbolTokenization tokenization = RichSequence.IOTools.getDNAParser();
        Namespace namespace = RichObjectFactory.getDefaultNamespace();
        SimpleRichSequenceBuilder builder = new SimpleRichSequenceBuilder();
        RichSequence sequence = null;
        try {
            this.gbFormat.readRichSequence(br, tokenization, builder, namespace);
            sequence = builder.makeRichSequence();
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug2250_2256Test.fail((String)("Unexpected exception: " + e));
        }
        return sequence;
    }
}

