/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.EMBLFormat;
import org.biojavax.bio.seq.io.GenbankFormat;
import org.biojavax.bio.seq.io.SimpleRichSequenceBuilder;

public class Bug2255Test
extends TestCase {
    private EMBLFormat gbFormat;

    protected void setUp() {
        this.gbFormat = new EMBLFormat();
    }

    protected void tearDown() throws Exception {
        this.gbFormat = null;
    }

    public void testBug2255() {
        String filename = "/files/X56734.embl";
        RichSequence seq = this.readFile(filename);
        ArrayList<String> kws = new ArrayList<String>();
        for (Note n : seq.getNoteSet()) {
            if (!n.getTerm().equals(GenbankFormat.Terms.getKeywordTerm())) continue;
            kws.add(n.getValue());
        }
        Bug2255Test.assertEquals(kws.get(0), (Object)"Hello");
        Bug2255Test.assertEquals(kws.get(1), (Object)"World");
    }

    private RichSequence readFile(String filename) {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        SymbolTokenization tokenization = RichSequence.IOTools.getDNAParser();
        Namespace namespace = RichObjectFactory.getDefaultNamespace();
        SimpleRichSequenceBuilder builder = new SimpleRichSequenceBuilder();
        RichSequence sequence = null;
        try {
            this.gbFormat.readRichSequence(br, tokenization, builder, namespace);
            sequence = builder.makeRichSequence();
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug2255Test.fail((String)("Unexpected exception: " + e));
        }
        return sequence;
    }
}

