/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.EMBLFormat;
import org.biojavax.bio.seq.io.SimpleRichSequenceBuilder;

public class EMBLFormatTest
extends TestCase {
    private EMBLFormat emblFormat;

    protected void setUp() {
        this.emblFormat = new EMBLFormat();
    }

    public static void main(String[] args) {
        EMBLFormatTest eft = new EMBLFormatTest();
        eft.testReadEmptySequence();
    }

    public void testReadEmptySequence() {
        String fileName = "/export/home/sterg/NBProjects/biojava/biojavaSrc/tests/files/X56734.embl";
        RichSequence sequence = this.readFile(fileName);
        System.out.println("name = " + sequence.getName());
    }

    private RichSequence readFile(String filename) {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        SymbolTokenization tokenization = RichSequence.IOTools.getDNAParser();
        Namespace namespace = RichObjectFactory.getDefaultNamespace();
        SimpleRichSequenceBuilder builder = new SimpleRichSequenceBuilder();
        RichSequence sequence = null;
        try {
            this.emblFormat.readRichSequence(br, tokenization, builder, namespace);
            sequence = builder.makeRichSequence();
        }
        catch (Exception e) {
            e.printStackTrace();
            EMBLFormatTest.fail((String)("Unexpected exception: " + e));
        }
        return sequence;
    }
}

