/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.GenbankFormat;
import org.biojavax.bio.seq.io.RichSequenceBuilderFactory;
import org.biojavax.bio.seq.io.RichSequenceFormat;
import org.biojavax.bio.seq.io.RichStreamReader;
import org.biojavax.bio.seq.io.RichStreamWriter;
import org.biojavax.bio.seq.io.SimpleRichSequenceBuilder;
import org.biojavax.bio.taxa.NCBITaxon;

public class GenbankFormatTest
extends TestCase {
    private GenbankFormat gbFormat;

    protected void setUp() {
        this.gbFormat = new GenbankFormat();
    }

    public void testGenbankParsing_oldStyleFile() {
        RichSequence sequence = this.readFile("/files/NoAccession.gb");
        GenbankFormatTest.assertEquals((String)"NoAccess", (String)sequence.getName());
        GenbankFormatTest.assertTrue((boolean)sequence.getCircular());
        GenbankFormatTest.assertEquals(null, (String)sequence.getDescription());
        GenbankFormatTest.assertEquals(null, (String)sequence.getDivision());
        GenbankFormatTest.assertEquals(null, (Object)sequence.getTaxon());
        GenbankFormatTest.assertEquals((String)"NoAccess", (String)sequence.getURN());
        GenbankFormatTest.assertEquals((int)0, (int)sequence.getVersion());
        String stranded = null;
        String udat = null;
        String molType = sequence.getAlphabet().getName();
        for (Note n : sequence.getNoteSet()) {
            if (n.getTerm().equals(GenbankFormat.Terms.getStrandedTerm())) {
                stranded = n.getValue();
                continue;
            }
            if (n.getTerm().equals(GenbankFormat.Terms.getDateUpdatedTerm())) {
                udat = n.getValue();
                continue;
            }
            if (!n.getTerm().equals(GenbankFormat.Terms.getMolTypeTerm())) continue;
            molType = n.getValue();
        }
        GenbankFormatTest.assertNull(stranded);
        GenbankFormatTest.assertNotNull(udat);
        GenbankFormatTest.assertEquals((String)"30-JUN-2006", udat);
        GenbankFormatTest.assertNotNull((Object)molType);
        GenbankFormatTest.assertEquals((String)"DNA", (String)molType);
    }

    public void testGenbankParsing_contemporaryApp() {
        RichSequence sequence = this.readFile("/files/AY069118.gb");
        GenbankFormatTest.assertEquals((String)"AY069118", (String)sequence.getName());
        GenbankFormatTest.assertFalse((boolean)sequence.getCircular());
        GenbankFormatTest.assertEquals((String)"Drosophila melanogaster GH13089 full length cDNA.", (String)sequence.getDescription());
        GenbankFormatTest.assertEquals((String)"INV", (String)sequence.getDivision());
        NCBITaxon taxon = sequence.getTaxon();
        GenbankFormatTest.assertNotNull((Object)taxon);
        GenbankFormatTest.assertEquals((String)"Drosophila melanogaster", (String)taxon.getDisplayName());
        GenbankFormatTest.assertEquals((String)"AY069118", (String)sequence.getURN());
        GenbankFormatTest.assertEquals((int)1, (int)sequence.getVersion());
        String stranded = null;
        String udat = null;
        String molType = sequence.getAlphabet().getName();
        for (Note n : sequence.getNoteSet()) {
            if (n.getTerm().equals(GenbankFormat.Terms.getStrandedTerm())) {
                stranded = n.getValue();
                continue;
            }
            if (n.getTerm().equals(GenbankFormat.Terms.getDateUpdatedTerm())) {
                udat = n.getValue();
                continue;
            }
            if (!n.getTerm().equals(GenbankFormat.Terms.getMolTypeTerm())) continue;
            molType = n.getValue();
        }
        GenbankFormatTest.assertNull(stranded);
        GenbankFormatTest.assertNotNull(udat);
        GenbankFormatTest.assertEquals((String)"17-DEC-2001", udat);
        GenbankFormatTest.assertNotNull((Object)molType);
        GenbankFormatTest.assertEquals((String)"mRNA", (String)molType);
    }

    public void testGenbankWithNoAccession() {
        RichSequence sequence = this.readFile("/files/NoAccession.gb");
        GenbankFormatTest.assertNotNull((Object)sequence);
        GenbankFormatTest.assertEquals((String)"NoAccess", (String)sequence.getAccession());
    }

    public void testCanReadWhatIsWritten() {
        RichSequence sequence = this.readFile("/files/AY069118.gb");
        GenbankFormatTest.assertNotNull((Object)sequence);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        GenbankFormat genbank = new GenbankFormat();
        RichStreamWriter seqsOut = new RichStreamWriter(output, genbank);
        RichSequence.IOTools.SingleRichSeqIterator seqIterator = new RichSequence.IOTools.SingleRichSeqIterator(sequence);
        try {
            seqsOut.writeStream(seqIterator, null);
        }
        catch (IOException e) {
            GenbankFormatTest.fail((String)("Unexpected exception: " + e));
        }
        String newContent = ((Object)output).toString();
        SymbolTokenization dna = RichSequence.IOTools.getDNAParser();
        Namespace defaultNs = RichObjectFactory.getDefaultNamespace();
        BufferedReader input = new BufferedReader(new StringReader(newContent));
        RichSequence rereadSeq = null;
        try {
            RichStreamReader reader = new RichStreamReader(input, (RichSequenceFormat)new GenbankFormat(), dna, RichSequenceBuilderFactory.FACTORY, defaultNs);
            rereadSeq = reader.nextRichSequence();
        }
        catch (Exception e) {
            e.printStackTrace();
            GenbankFormatTest.fail((String)("Unexpected exception: " + e));
        }
        GenbankFormatTest.assertNotNull((Object)rereadSeq);
        GenbankFormatTest.assertEquals((String)sequence.getAccession(), (String)rereadSeq.getAccession());
        GenbankFormatTest.assertEquals((String)sequence.getName(), (String)rereadSeq.getName());
        GenbankFormatTest.assertEquals((String)sequence.seqString(), (String)rereadSeq.seqString());
    }

    public void testReadEmptySequence() {
        RichSequence sequence = this.readFile("/files/empty_genbank.gb");
        GenbankFormatTest.assertNotNull((Object)sequence);
        GenbankFormatTest.assertEquals((String)sequence.getName(), (String)"testempty");
        GenbankFormatTest.assertEquals((String)sequence.getAccession(), (String)"");
        GenbankFormatTest.assertEquals((int)sequence.getVersion(), (int)0);
        GenbankFormatTest.assertEquals((String)sequence.getDescription(), (String)"no sequence");
        GenbankFormatTest.assertEquals((int)sequence.getInternalSymbolList().length(), (int)0);
    }

    private RichSequence readFile(String filename) {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        SymbolTokenization tokenization = RichSequence.IOTools.getDNAParser();
        Namespace namespace = RichObjectFactory.getDefaultNamespace();
        SimpleRichSequenceBuilder builder = new SimpleRichSequenceBuilder();
        RichSequence sequence = null;
        try {
            this.gbFormat.readRichSequence(br, tokenization, builder, namespace);
            sequence = builder.makeRichSequence();
        }
        catch (Exception e) {
            e.printStackTrace();
            GenbankFormatTest.fail((String)("Unexpected exception: " + e));
        }
        return sequence;
    }
}

