/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.INSDseqFormat;
import org.biojavax.bio.seq.io.SimpleRichSequenceBuilder;
import org.biojavax.bio.taxa.NCBITaxon;

public class INSDseqFormatTest
extends TestCase {
    private INSDseqFormat insdFormat;

    protected void setUp() {
        this.insdFormat = new INSDseqFormat();
    }

    public void testINSDParsing() {
        RichSequence sequence = this.readFile("/files/NM_008366.xml");
        INSDseqFormatTest.assertEquals((String)"NM_008366", (String)sequence.getName());
        INSDseqFormatTest.assertFalse((boolean)sequence.getCircular());
        INSDseqFormatTest.assertEquals((String)"Mus musculus interleukin 2 (Il2), mRNA", (String)sequence.getDescription());
        INSDseqFormatTest.assertEquals((String)"ROD", (String)sequence.getDivision());
        NCBITaxon taxon = sequence.getTaxon();
        INSDseqFormatTest.assertNotNull((Object)taxon);
        INSDseqFormatTest.assertEquals((int)2, (int)sequence.getVersion());
        String stranded = null;
        String udat = null;
        String molType = sequence.getAlphabet().getName();
        for (Note n : sequence.getNoteSet()) {
            if (n.getTerm().equals(INSDseqFormat.Terms.getStrandedTerm())) {
                stranded = n.getValue();
                continue;
            }
            if (n.getTerm().equals(INSDseqFormat.Terms.getDateUpdatedTerm())) {
                udat = n.getValue();
                continue;
            }
            if (!n.getTerm().equals(INSDseqFormat.Terms.getMolTypeTerm())) continue;
            molType = n.getValue();
        }
        INSDseqFormatTest.assertNotNull(stranded);
        INSDseqFormatTest.assertEquals((String)"single", stranded);
        INSDseqFormatTest.assertNotNull(udat);
        INSDseqFormatTest.assertEquals((String)"25-MAR-2007", udat);
        INSDseqFormatTest.assertNotNull((Object)molType);
        INSDseqFormatTest.assertEquals((String)"mRNA", (String)molType);
    }

    public void testReadEmptySequence() {
        RichSequence sequence = this.readFile("/files/empty_insdseq.xml");
        INSDseqFormatTest.assertNotNull((Object)sequence);
        INSDseqFormatTest.assertEquals((String)sequence.getName(), (String)"testempty");
        INSDseqFormatTest.assertEquals((String)sequence.getAccession(), (String)"");
        INSDseqFormatTest.assertEquals((int)sequence.getVersion(), (int)0);
        INSDseqFormatTest.assertEquals((String)sequence.getDescription(), (String)"no sequence");
        INSDseqFormatTest.assertEquals((int)sequence.getInternalSymbolList().length(), (int)0);
    }

    private RichSequence readFile(String filename) {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        SymbolTokenization tokenization = RichSequence.IOTools.getDNAParser();
        Namespace namespace = RichObjectFactory.getDefaultNamespace();
        SimpleRichSequenceBuilder builder = new SimpleRichSequenceBuilder();
        RichSequence sequence = null;
        try {
            this.insdFormat.readRichSequence(br, tokenization, builder, namespace);
            sequence = builder.makeRichSequence();
        }
        catch (Exception e) {
            e.printStackTrace();
            INSDseqFormatTest.fail((String)("Unexpected exception: " + e));
        }
        return sequence;
    }
}

