/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.proteomics.MassCalc;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.CrossRef;
import org.biojavax.DocRef;
import org.biojavax.DocRefAuthor;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RankedCrossRef;
import org.biojavax.RankedDocRef;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleComment;
import org.biojavax.SimpleCrossRef;
import org.biojavax.SimpleDocRef;
import org.biojavax.SimpleDocRefAuthor;
import org.biojavax.SimpleNote;
import org.biojavax.SimpleRankedCrossRef;
import org.biojavax.SimpleRankedDocRef;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.RichSeqIOListener;
import org.biojavax.bio.seq.io.RichSequenceFormat;
import org.biojavax.bio.seq.io.UniProtCommentParser;
import org.biojavax.bio.seq.io.UniProtLocationParser;
import org.biojavax.bio.taxa.NCBITaxon;
import org.biojavax.bio.taxa.SimpleNCBITaxon;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.utils.CRC64Checksum;
import org.biojavax.utils.StringTools;

public class UniProtFormat
extends RichSequenceFormat.HeaderlessFormat {
    public static final String UNIPROT_FORMAT = "UniProt";
    protected static final String LOCUS_TAG = "ID";
    protected static final String ACCESSION_TAG = "AC";
    protected static final String DEFINITION_TAG = "DE";
    protected static final String DATE_TAG = "DT";
    protected static final String SOURCE_TAG = "OS";
    protected static final String ORGANELLE_TAG = "OG";
    protected static final String ORGANISM_TAG = "OC";
    protected static final String TAXON_TAG = "OX";
    protected static final String GENE_TAG = "GN";
    protected static final String DATABASE_XREF_TAG = "DR";
    protected static final String PROTEIN_EXIST_TAG = "PE";
    protected static final String REFERENCE_TAG = "RN";
    protected static final String RP_LINE_TAG = "RP";
    protected static final String REFERENCE_XREF_TAG = "RX";
    protected static final String AUTHORS_TAG = "RA";
    protected static final String CONSORTIUM_TAG = "RG";
    protected static final String TITLE_TAG = "RT";
    protected static final String LOCATION_TAG = "RL";
    protected static final String RC_LINE_TAG = "RC";
    protected static final String KEYWORDS_TAG = "KW";
    protected static final String COMMENT_TAG = "CC";
    protected static final String FEATURE_TAG = "FT";
    protected static final String START_SEQUENCE_TAG = "SQ";
    protected static final String END_SEQUENCE_TAG = "//";
    protected static final Pattern lp;
    protected static final Pattern rppat;
    protected static final Pattern dp;
    protected static final Pattern fp;
    protected static final Pattern headerLine;
    private String accession = null;

    @Override
    public boolean canRead(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String firstLine = br.readLine();
        boolean readable = firstLine != null && headerLine.matcher(firstLine).matches() && lp.matcher(firstLine.substring(3).trim()).matches();
        br.close();
        return readable;
    }

    @Override
    public SymbolTokenization guessSymbolTokenization(File file) throws IOException {
        return RichSequence.IOTools.getProteinParser();
    }

    @Override
    public boolean canRead(BufferedInputStream stream) throws IOException {
        stream.mark(2000);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        String firstLine = br.readLine();
        boolean readable = firstLine != null && headerLine.matcher(firstLine).matches() && lp.matcher(firstLine.substring(3).trim()).matches();
        stream.reset();
        return readable;
    }

    @Override
    public SymbolTokenization guessSymbolTokenization(BufferedInputStream stream) throws IOException {
        return RichSequence.IOTools.getProteinParser();
    }

    @Override
    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        if (!(listener instanceof RichSeqIOListener)) {
            throw new IllegalArgumentException("Only accepting RichSeqIOListeners today");
        }
        return this.readRichSequence(reader, symParser, (RichSeqIOListener)listener, null);
    }

    @Override
    public boolean readRichSequence(BufferedReader reader, SymbolTokenization symParser, RichSeqIOListener rlistener, Namespace ns) throws IllegalSymbolException, IOException, ParseException {
        boolean hasAnotherSequence;
        block110: {
            int c;
            hasAnotherSequence = true;
            rlistener.startSequence();
            if (ns == null) {
                ns = RichObjectFactory.getDefaultNamespace();
            }
            rlistener.setNamespace(ns);
            String sectionKey = null;
            NCBITaxon tax = null;
            this.accession = null;
            List section = null;
            try {
                do {
                    if ((sectionKey = ((String[])(section = this.readSection(reader)).get(0))[0]) == null) {
                        String message = ParseException.newMessage(this.getClass(), this.accession, "", "Section key was null", this.sectionToString(section));
                        throw new ParseException(message);
                    }
                    if (sectionKey.equals(LOCUS_TAG)) {
                        String loc = ((String[])section.get(0))[1];
                        Matcher m = lp.matcher(loc);
                        if (m.matches()) {
                            rlistener.setName(m.group(2));
                            rlistener.setDivision(m.group(3));
                            if (m.groupCount() > 4) {
                                rlistener.addSequenceProperty(Terms.getDataClassTerm(), m.group(4));
                                rlistener.addSequenceProperty(Terms.getMolTypeTerm(), m.group(5));
                                continue;
                            }
                            rlistener.addSequenceProperty(Terms.getDataClassTerm(), m.group(4));
                            rlistener.addSequenceProperty(Terms.getMolTypeTerm(), "");
                            continue;
                        }
                        String message = ParseException.newMessage(this.getClass(), this.accession, "", "Bad ID line", this.sectionToString(section));
                        throw new ParseException(message);
                    }
                    if (sectionKey.equals(DEFINITION_TAG)) {
                        String val = ((String[])section.get(0))[1];
                        if (val.endsWith(".")) {
                            val = val.substring(0, val.length() - 1);
                        }
                        rlistener.setDescription(val);
                        continue;
                    }
                    if (sectionKey.equals(SOURCE_TAG)) {
                        String sciname = null;
                        String comname = null;
                        ArrayList<String> synonym = new ArrayList<String>();
                        int taxid = 0;
                        for (int i = 0; i < section.size(); ++i) {
                            int j;
                            String[] parts;
                            String tag = ((String[])section.get(i))[0];
                            String value = ((String[])section.get(i))[1].trim();
                            if (tag.equals(SOURCE_TAG)) {
                                if (value.endsWith(".")) {
                                    value = value.substring(0, value.length() - 1);
                                }
                                parts = value.split("\\(");
                                sciname = parts[0].trim();
                                if (parts.length <= 1) continue;
                                comname = parts[1].trim();
                                if (comname.endsWith(")")) {
                                    comname = comname.substring(0, comname.length() - 1);
                                }
                                if (parts.length <= 2) continue;
                                for (j = 2; j < parts.length; ++j) {
                                    String syn = parts[j].trim();
                                    if (syn.endsWith(")")) {
                                        syn = syn.substring(0, syn.length() - 1);
                                    }
                                    synonym.add(syn);
                                }
                                continue;
                            }
                            if (tag.equals(TAXON_TAG)) {
                                parts = value.split(";");
                                for (j = 0; j < parts.length; ++j) {
                                    String[] bits = parts[j].split("=");
                                    if (!bits[0].equals("NCBI_TaxID")) continue;
                                    String[] morebits = bits[1].split(",");
                                    taxid = Integer.parseInt(morebits[0].trim());
                                }
                                continue;
                            }
                            if (!tag.equals(ORGANELLE_TAG)) continue;
                            if (value.endsWith(".")) {
                                value = value.substring(0, value.length() - 1);
                            }
                            parts = value.split(";");
                            for (j = 0; j < parts.length; ++j) {
                                parts[j] = parts[j].trim();
                                rlistener.addSequenceProperty(Terms.getOrganelleTerm(), parts[j]);
                            }
                        }
                        tax = (NCBITaxon)RichObjectFactory.getObject(SimpleNCBITaxon.class, new Object[]{new Integer(taxid)});
                        rlistener.setTaxon(tax);
                        try {
                            if (sciname != null) {
                                tax.addName("scientific name", sciname);
                            }
                            if (comname != null) {
                                tax.addName("common name", comname);
                            }
                            Iterator j = synonym.iterator();
                            while (j.hasNext()) {
                                tax.addName("synonym", (String)j.next());
                            }
                        }
                        catch (ChangeVetoException e) {
                            throw new ParseException(e);
                        }
                    }
                    if (sectionKey.equals(DATE_TAG)) {
                        String chunk = ((String[])section.get(0))[1];
                        Matcher dm = dp.matcher(chunk);
                        if (dm.matches()) {
                            String message;
                            String date = dm.group(1).trim();
                            String type = dm.group(2).trim();
                            String rel = dm.group(3);
                            if (rel != null) {
                                rel = rel.trim();
                            }
                            if (type.startsWith("integrated into UniProtKB")) {
                                String dbname = type.split("/")[1];
                                rlistener.addSequenceProperty(Terms.getDateCreatedTerm(), date);
                                rlistener.addSequenceProperty(Terms.getUniProtDBNameTerm(), dbname);
                                continue;
                            }
                            if (type.equalsIgnoreCase("sequence version")) {
                                if (rel == null) {
                                    message = ParseException.newMessage(this.getClass(), this.accession, "", "Version missing for " + type, this.sectionToString(section));
                                    throw new ParseException(message);
                                }
                                rlistener.addSequenceProperty(Terms.getDateUpdatedTerm(), date);
                                rlistener.setVersion(Integer.parseInt(rel));
                                continue;
                            }
                            if (type.equalsIgnoreCase("entry version")) {
                                if (rel == null) {
                                    message = ParseException.newMessage(this.getClass(), this.accession, "", "Version missing for " + type, this.sectionToString(section));
                                    throw new ParseException(message);
                                }
                                rlistener.addSequenceProperty(Terms.getDateAnnotatedTerm(), date);
                                rlistener.addSequenceProperty(Terms.getRelAnnotatedTerm(), rel);
                                continue;
                            }
                            message = ParseException.newMessage(this.getClass(), this.accession, "", "Bad date type " + type, this.sectionToString(section));
                            throw new ParseException(message);
                        }
                        String message = ParseException.newMessage(this.getClass(), this.accession, "", "Bad date line", this.sectionToString(section));
                        throw new ParseException(message);
                    }
                    if (sectionKey.equals(ACCESSION_TAG)) {
                        String[] accs = ((String[])section.get(0))[1].split(";");
                        this.accession = accs.length > 0 ? accs[0].trim() : "";
                        rlistener.setAccession(this.accession);
                        for (int i = 1; i < accs.length; ++i) {
                            rlistener.addSequenceProperty(Terms.getAdditionalAccessionTerm(), accs[i].trim());
                        }
                        continue;
                    }
                    if (sectionKey.equals(PROTEIN_EXIST_TAG)) {
                        String val = ((String[])section.get(0))[1];
                        if (val.endsWith(";")) {
                            val = val.substring(0, val.length() - 1);
                        }
                        rlistener.addSequenceProperty(Terms.getProteinExistsTerm(), val.trim());
                        continue;
                    }
                    if (sectionKey.equals(KEYWORDS_TAG)) {
                        String val = ((String[])section.get(0))[1];
                        if (val.endsWith(".")) {
                            val = val.substring(0, val.length() - 1);
                        }
                        val = val.replace('\n', ' ');
                        String[] kws = val.split(";");
                        for (int i = 0; i < kws.length; ++i) {
                            String kw = kws[i].trim();
                            if (kw.length() == 0) continue;
                            rlistener.addSequenceProperty(Terms.getKeywordTerm(), kw);
                        }
                        continue;
                    }
                    if (sectionKey.equals(GENE_TAG)) {
                        String[] genes = ((String[])section.get(0))[1].split("\\s+(or|and)\\s+");
                        for (int geneID = 0; geneID < genes.length; ++geneID) {
                            String[] parts = genes[geneID].split(";");
                            for (int j = 0; j < parts.length; ++j) {
                                int k;
                                String[] moreparts = parts[j].split("=");
                                String[] values = moreparts[1].split(",");
                                if (moreparts[0].trim().equals(Terms.GENENAME_KEY)) {
                                    rlistener.addSequenceProperty(Terms.getGeneNameTerm(), geneID + ":" + values[0].trim());
                                    continue;
                                }
                                if (moreparts[0].trim().equals(Terms.GENESYNONYM_KEY)) {
                                    for (k = 0; k < values.length; ++k) {
                                        rlistener.addSequenceProperty(Terms.getGeneSynonymTerm(), geneID + ":" + values[k].trim());
                                    }
                                    continue;
                                }
                                if (moreparts[0].trim().equals(Terms.ORDLOCNAME_KEY)) {
                                    for (k = 0; k < values.length; ++k) {
                                        rlistener.addSequenceProperty(Terms.getOrderedLocusNameTerm(), geneID + ":" + values[k].trim());
                                    }
                                    continue;
                                }
                                if (!moreparts[0].trim().equals(Terms.ORFNAME_KEY)) continue;
                                for (k = 0; k < values.length; ++k) {
                                    rlistener.addSequenceProperty(Terms.getORFNameTerm(), geneID + ":" + values[k].trim());
                                }
                            }
                        }
                        continue;
                    }
                    if (sectionKey.equals(DATABASE_XREF_TAG)) {
                        String val = ((String[])section.get(0))[1];
                        if (val.endsWith(".")) {
                            val = val.substring(0, val.length() - 1);
                        }
                        String[] parts = val.split(";");
                        String dbname = parts[0].trim();
                        String acc = parts[1].trim();
                        CrossRef crossRef = (CrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{dbname, acc, new Integer(0)});
                        for (int j = 2; j < parts.length; ++j) {
                            ComparableTerm t = Terms.getAdditionalAccessionTerm();
                            SimpleNote note = new SimpleNote(t, parts[j].trim(), j - 1);
                            try {
                                ((RichAnnotation)crossRef.getAnnotation()).addNote(note);
                                continue;
                            }
                            catch (ChangeVetoException ce) {
                                ParseException pe = new ParseException("Could not annotate additional accession terms");
                                pe.initCause(ce);
                                throw pe;
                            }
                        }
                        SimpleRankedCrossRef rcrossRef = new SimpleRankedCrossRef(crossRef, 0);
                        rlistener.setRankedCrossRef(rcrossRef);
                        continue;
                    }
                    if (sectionKey.equals(REFERENCE_TAG) && !this.getElideReferences()) {
                        String refrank = ((String[])section.get(0))[1];
                        int ref_rank = Integer.parseInt(refrank.substring(1, refrank.length() - 1));
                        String authors = null;
                        String consortium = null;
                        String title = null;
                        String locator = null;
                        String pubmed = null;
                        String medline = null;
                        String doi = null;
                        String remark = null;
                        Integer rstart = null;
                        Integer rend = null;
                        for (int i = 1; i < section.size(); ++i) {
                            int j;
                            String key = ((String[])section.get(i))[0];
                            String val = ((String[])section.get(i))[1];
                            if (key.equals(AUTHORS_TAG)) {
                                if (val.endsWith(";")) {
                                    val = val.substring(0, val.length() - 1);
                                }
                                authors = val.replace('\n', ' ');
                            }
                            if (key.equals(CONSORTIUM_TAG)) {
                                if (val.endsWith(";")) {
                                    val = val.substring(0, val.length() - 1);
                                }
                                consortium = val.replace('\n', ' ');
                            }
                            if (key.equals(TITLE_TAG)) {
                                if (val.endsWith(";")) {
                                    val = val.substring(0, val.length() - 1);
                                }
                                if (val.endsWith("\"")) {
                                    val = val.substring(1, val.length() - 1);
                                }
                                title = val.replace('\n', ' ');
                            }
                            if (key.equals(LOCATION_TAG)) {
                                if (val.endsWith(".")) {
                                    val = val.substring(0, val.length() - 1);
                                }
                                locator = val.replace('\n', ' ');
                            }
                            if (key.equals(REFERENCE_XREF_TAG)) {
                                String[] refs = val.split(";");
                                for (j = 0; j < refs.length; ++j) {
                                    if (refs[j].trim().length() == 0) continue;
                                    String[] parts = refs[j].split("=");
                                    String db = parts[0].trim();
                                    String ref = parts[1].trim();
                                    if (db.equalsIgnoreCase("PUBMED")) {
                                        pubmed = ref;
                                        continue;
                                    }
                                    if (db.equalsIgnoreCase("MEDLINE")) {
                                        medline = ref;
                                        continue;
                                    }
                                    if (!db.equalsIgnoreCase("DOI")) continue;
                                    doi = ref;
                                }
                            }
                            if (key.equals(RP_LINE_TAG)) {
                                if (val.endsWith(".")) {
                                    val = val.substring(0, val.length() - 1);
                                }
                                remark = val.replace('\n', ' ');
                                Matcher m = rppat.matcher(val);
                                if (m.matches()) {
                                    rstart = Integer.valueOf(m.group(1));
                                    rend = Integer.valueOf(m.group(2));
                                }
                            }
                            if (!key.equals(RC_LINE_TAG)) continue;
                            String[] parts = val.split(";");
                            for (j = 0; j < parts.length; ++j) {
                                ComparableTerm t;
                                String[] subparts = parts[j].split("=");
                                String termName = subparts[0].trim();
                                if (termName.equalsIgnoreCase(Terms.SPECIES_KEY)) {
                                    t = Terms.getSpeciesTerm();
                                } else if (termName.equalsIgnoreCase(Terms.STRAIN_KEY)) {
                                    t = Terms.getStrainTerm();
                                } else if (termName.equalsIgnoreCase(Terms.TISSUE_KEY)) {
                                    t = Terms.getTissueTerm();
                                } else if (termName.equalsIgnoreCase(Terms.TRANSPOSON_KEY)) {
                                    t = Terms.getTransposonTerm();
                                } else if (termName.equalsIgnoreCase(Terms.PLASMID_KEY)) {
                                    t = Terms.getPlasmidTerm();
                                } else {
                                    String message = ParseException.newMessage(this.getClass(), this.accession, "", "Invalid RC term found: " + termName, this.sectionToString(section));
                                    throw new ParseException(message);
                                }
                                rlistener.addSequenceProperty(t, ref_rank + ":" + subparts[1].trim());
                            }
                        }
                        try {
                            ArrayList<SimpleDocRefAuthor> auths = null;
                            if (authors != null) {
                                auths = DocRefAuthor.Tools.parseAuthorString(authors);
                            }
                            if (consortium != null) {
                                if (auths == null) {
                                    auths = new ArrayList<SimpleDocRefAuthor>();
                                }
                                auths.add(new SimpleDocRefAuthor(consortium, true, false));
                            }
                            DocRef dr = (DocRef)RichObjectFactory.getObject(SimpleDocRef.class, new Object[]{auths, locator, title});
                            if (medline != null) {
                                dr.setCrossref((CrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{"MEDLINE", medline, new Integer(0)}));
                            } else if (pubmed != null) {
                                dr.setCrossref((CrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{"PUBMED", pubmed, new Integer(0)}));
                            } else if (doi != null) {
                                dr.setCrossref((CrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{"DOI", doi, new Integer(0)}));
                            }
                            if (!this.getElideComments()) {
                                dr.setRemark(remark);
                            }
                            SimpleRankedDocRef rdr = new SimpleRankedDocRef(dr, rstart, rend, ref_rank);
                            rlistener.setRankedDocRef(rdr);
                        }
                        catch (ChangeVetoException e) {
                            throw new ParseException(e);
                        }
                    } else {
                        if (sectionKey.equals(COMMENT_TAG) && !this.getElideComments()) {
                            String val = ((String[])section.get(0))[1];
                            if (UniProtCommentParser.isParseable(val)) {
                                rlistener.setComment(val);
                                continue;
                            }
                            rlistener.addSequenceProperty(Terms.getCopyrightTerm(), val);
                            continue;
                        }
                        if (sectionKey.equals(FEATURE_TAG) && !this.getElideFeatures()) {
                            boolean seenAFeature = false;
                            for (int i = 1; i < section.size(); ++i) {
                                String key = ((String[])section.get(i))[0];
                                String val = ((String[])section.get(i))[1];
                                if ((val = val.replaceAll("\\s*[\\n\\r]+\\s*", " ").trim()).endsWith(".")) {
                                    val = val.substring(0, val.length() - 1);
                                }
                                if (key.startsWith("/")) {
                                    if ((key = key.substring(1)).equals("FTId")) {
                                        rlistener.addFeatureProperty(Terms.getFTIdTerm(), val);
                                        continue;
                                    }
                                    rlistener.addFeatureProperty(RichObjectFactory.getDefaultOntology().getOrCreateTerm(key), val);
                                    continue;
                                }
                                if (seenAFeature) {
                                    rlistener.endFeature();
                                }
                                RichFeature.Template templ = new RichFeature.Template();
                                templ.annotation = new SimpleRichAnnotation();
                                templ.sourceTerm = Terms.getUniProtTerm();
                                templ.typeTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm(key);
                                templ.featureRelationshipSet = new TreeSet();
                                templ.rankedCrossRefs = new TreeSet();
                                String desc = null;
                                Matcher m = fp.matcher(val);
                                if (!m.matches()) {
                                    String message = ParseException.newMessage(this.getClass(), this.accession, "", "Bad feature value: " + val, this.sectionToString(section));
                                    throw new ParseException(message);
                                }
                                String loc = m.group(1);
                                desc = m.group(3);
                                templ.location = UniProtLocationParser.parseLocation(loc);
                                rlistener.startFeature(templ);
                                if (desc != null && desc.length() > 0) {
                                    rlistener.addFeatureProperty(Terms.getFeatureDescTerm(), desc);
                                }
                                seenAFeature = true;
                            }
                            if (!seenAFeature) continue;
                            rlistener.endFeature();
                            continue;
                        }
                        if (!sectionKey.equals(START_SEQUENCE_TAG) || this.getElideSymbols()) continue;
                        StringBuffer seq = new StringBuffer();
                        for (int i = 0; i < section.size(); ++i) {
                            seq.append(((String[])section.get(i))[1]);
                        }
                        try {
                            SimpleSymbolList sl = new SimpleSymbolList(symParser, seq.toString().replaceAll("\\s+", "").replaceAll("[\\.|~]", "-"));
                            rlistener.addSymbols(symParser.getAlphabet(), sl.toList().toArray(new Symbol[0]), 0, sl.length());
                        }
                        catch (IllegalAlphabetException e) {
                            String message = ParseException.newMessage(this.getClass(), this.accession, "", "", this.sectionToString(section));
                            throw new ParseException(e, message);
                        }
                    }
                } while (!sectionKey.equals(END_SEQUENCE_TAG));
            }
            catch (RuntimeException e) {
                String message = ParseException.newMessage(this.getClass(), this.accession, "", "", this.sectionToString(section));
                throw new ParseException(e, message);
            }
            do {
                reader.mark(1);
                c = reader.read();
                if (c != -1) continue;
                hasAnotherSequence = false;
                break block110;
            } while (Character.isWhitespace((char)c));
            reader.reset();
        }
        rlistener.endSequence();
        return hasAnotherSequence;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List readSection(BufferedReader br) throws ParseException {
        section = new ArrayList<String[]>();
        done = false;
lbl3:
        // 4 sources

        try {
            while (!done) {
                block29: {
                    block28: {
                        br.mark(160);
                        line = br.readLine();
                        if (line.length() < 2) {
                            message = ParseException.newMessage(this.getClass(), this.accession, "", "Bad line found: " + line, this.sectionToString(section));
                            throw new ParseException(message);
                        }
                        token = line.substring(0, 2);
                        if (token.equals("SQ")) {
                            sb = new StringBuffer();
                            while (!done) {
                                br.mark(160);
                                line = br.readLine();
                                if (line.startsWith("//")) {
                                    br.reset();
                                    done = true;
                                    continue;
                                }
                                sb.append(line);
                            }
                            section.add(new String[]{"SQ", sb.toString()});
                            continue;
                        }
                        if (!token.equals("CC")) break block28;
                        currentVal = new StringBuffer();
                        wasMisc = false;
                        if (!line.startsWith("CC   -!-")) {
                            wasMisc = true;
                        }
                        currentVal.append(line.substring(5));
                        while (!done) {
                            br.mark(160);
                            line = br.readLine();
                            if (!wasMisc && line.charAt(5) != ' ' || !line.startsWith("C") || line.startsWith("CC   -!-")) {
                                br.reset();
                                done = true;
                                section.add(new String[]{"CC", currentVal.toString()});
                                continue;
                            }
                            currentVal.append("\n");
                            currentVal.append(line.substring(5));
                        }
                        ** GOTO lbl3
                    }
                    if (!token.equals("FT")) break block29;
                    br.reset();
                    currentTag = null;
                    currentVal = new StringBuffer();
                    section.add(new String[]{"FT", null});
                    while (!done) {
                        br.mark(160);
                        line = br.readLine();
                        if (!line.startsWith("FT")) {
                            br.reset();
                            done = true;
                            if (currentTag == null) continue;
                            section.add(new String[]{currentTag, currentVal.toString()});
                            continue;
                        }
                        if (!(line = line.substring(5)).startsWith(" ")) {
                            if (currentTag != null) {
                                section.add(new String[]{currentTag, currentVal.toString()});
                            }
                            currentTag = line.substring(0, 8).trim();
                            currentVal = new StringBuffer();
                            currentVal.append(line.substring(8).trim());
                            continue;
                        }
                        if ((line = line.trim()).startsWith("/")) {
                            if (currentTag != null) {
                                section.add(new String[]{currentTag, currentVal.toString()});
                            }
                            currentVal = new StringBuffer();
                            equalIndex = line.indexOf(61);
                            if (equalIndex >= 0) {
                                currentTag = line.substring(0, equalIndex);
                                currentVal.append(line.substring(equalIndex + 1));
                                continue;
                            }
                            currentTag = line;
                            continue;
                        }
                        currentVal.append("\n");
                        currentVal.append(line);
                    }
                    ** GOTO lbl3
                }
                if (token.equals("DR")) {
                    section.add(new String[]{"DR", line.substring(5).trim()});
                    done = true;
                    continue;
                }
                if (token.equals("DT")) {
                    section.add(new String[]{"DT", line.substring(5).trim()});
                    done = true;
                    continue;
                }
                if (token.equals("//")) {
                    section.add(new String[]{"//", null});
                    done = true;
                    continue;
                }
                br.reset();
                currentTag = null;
                currentTagStart = '\u0000';
                currentVal = null;
                while (!done) {
                    br.mark(160);
                    line = br.readLine();
                    if (currentTagStart == '\u0000') {
                        currentTagStart = line.charAt(0);
                    }
                    if (!line.startsWith("" + currentTagStart) || currentTagStart == 'D' && currentTag != null && !line.startsWith("" + currentTag) || currentTagStart == 'R' && currentTag != null && line.startsWith("RN")) {
                        br.reset();
                        done = true;
                        if (currentTag == null) continue;
                        section.add(new String[]{currentTag, currentVal.toString()});
                        continue;
                    }
                    try {
                        tag = line.substring(0, 2);
                        value = line.substring(5);
                        if (currentTag == null || !tag.equals(currentTag)) {
                            if (currentTag != null) {
                                section.add(new String[]{currentTag, currentVal.toString()});
                            }
                            currentTag = tag;
                            currentVal = new StringBuffer();
                            currentVal.append(value);
                            continue;
                        }
                        currentVal.append("\n");
                        currentVal.append(value);
                    }
                    catch (Exception e) {
                        message = ParseException.newMessage(this.getClass(), this.accession, "", "", this.sectionToString(section));
                        throw new ParseException(e, message);
                    }
                }
                ** GOTO lbl3
                return section;
            }
        }
        catch (IOException e) {
            message = ParseException.newMessage(this.getClass(), this.accession, "", "", this.sectionToString(section));
            throw new ParseException(e, message);
        }
        catch (RuntimeException e) {
            message = ParseException.newMessage(this.getClass(), this.accession, "", "", this.sectionToString(section));
            throw new ParseException(e, message);
        }
    }

    @Override
    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(os);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    @Override
    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(os);
        }
        if (!format.equals(this.getDefaultFormat())) {
            throw new IllegalArgumentException("Unknown format: " + format);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    @Override
    public void writeSequence(Sequence seq, Namespace ns) throws IOException {
        SymbolTokenization tok;
        RichSequence rs;
        try {
            rs = seq instanceof RichSequence ? (RichSequence)seq : RichSequence.Tools.enrich(seq);
        }
        catch (ChangeVetoException e) {
            IOException e2 = new IOException("Unable to enrich sequence");
            e2.initCause(e);
            throw e2;
        }
        try {
            tok = rs.getAlphabet().getTokenization("token");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get alphabet tokenizer", e);
        }
        Set notes = rs.getNoteSet();
        String accession = rs.getAccession();
        StringBuffer accessions = new StringBuffer();
        accessions.append(accession);
        accessions.append(";");
        String cdat = null;
        String udat = null;
        String adat = null;
        String dbname = "?";
        String arel = null;
        String organelle = null;
        String protExists = null;
        String dataclass = "STANDARD";
        String copyright = null;
        TreeMap speciesRecs = new TreeMap();
        TreeMap strainRecs = new TreeMap();
        TreeMap tissueRecs = new TreeMap();
        TreeMap transpRecs = new TreeMap();
        TreeMap plasmidRecs = new TreeMap();
        TreeMap<Integer, String> genenames = new TreeMap<Integer, String>();
        TreeMap genesynonyms = new TreeMap();
        TreeMap orfnames = new TreeMap();
        TreeMap ordlocnames = new TreeMap();
        for (Note n : notes) {
            Integer refID;
            int colon;
            String ref;
            if (n.getTerm().equals(Terms.getDateCreatedTerm())) {
                cdat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getDateUpdatedTerm())) {
                udat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getDateAnnotatedTerm())) {
                adat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getUniProtDBNameTerm())) {
                dbname = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getProteinExistsTerm())) {
                protExists = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getRelAnnotatedTerm())) {
                arel = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getDataClassTerm())) {
                dataclass = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getCopyrightTerm())) {
                copyright = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getAdditionalAccessionTerm())) {
                accessions.append(" ");
                accessions.append(n.getValue());
                accessions.append(";");
                continue;
            }
            if (n.getTerm().equals(Terms.getOrganelleTerm())) {
                organelle = (organelle == null ? "" : organelle + "; ") + n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getGeneNameTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                genenames.put(refID, ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getGeneSynonymTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (genesynonyms.get(refID) == null) {
                    genesynonyms.put(refID, new ArrayList());
                }
                ((List)genesynonyms.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getOrderedLocusNameTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (ordlocnames.get(refID) == null) {
                    ordlocnames.put(refID, new ArrayList());
                }
                ((List)ordlocnames.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getORFNameTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (orfnames.get(refID) == null) {
                    orfnames.put(refID, new ArrayList());
                }
                ((List)orfnames.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getSpeciesTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (speciesRecs.get(refID) == null) {
                    speciesRecs.put(refID, new ArrayList());
                }
                ((List)speciesRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getStrainTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (strainRecs.get(refID) == null) {
                    strainRecs.put(refID, new ArrayList());
                }
                ((List)strainRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getTissueTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (tissueRecs.get(refID) == null) {
                    tissueRecs.put(refID, new ArrayList());
                }
                ((List)tissueRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getTransposonTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (transpRecs.get(refID) == null) {
                    transpRecs.put(refID, new ArrayList());
                }
                ((List)transpRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (!n.getTerm().equals(Terms.getPlasmidTerm())) continue;
            ref = n.getValue();
            colon = ref.indexOf(58);
            refID = new Integer(0);
            if (colon >= 1) {
                refID = new Integer(ref.substring(0, colon));
            }
            if (plasmidRecs.get(refID) == null) {
                plasmidRecs.put(refID, new ArrayList());
            }
            ((List)plasmidRecs.get(refID)).add(ref.substring(colon + 1));
        }
        StringBuffer locusLine = new StringBuffer();
        locusLine.append(StringTools.rightPad(rs.getName() + "_" + rs.getDivision(), 12));
        locusLine.append(" ");
        locusLine.append(StringTools.leftPad(dataclass, 19));
        locusLine.append("; ");
        locusLine.append(StringTools.leftPad("" + rs.length(), 11));
        locusLine.append(" AA.");
        StringTools.writeKeyValueLine(LOCUS_TAG, locusLine.toString(), 5, this.getLineWidth(), null, LOCUS_TAG, this.getPrintStream());
        StringTools.writeKeyValueLine(ACCESSION_TAG, accessions.toString(), 5, this.getLineWidth(), null, ACCESSION_TAG, this.getPrintStream());
        StringTools.writeKeyValueLine(DATE_TAG, (cdat == null ? udat : cdat) + ", integrated into UniProtKB/" + dbname + ".", 5, this.getLineWidth(), null, DATE_TAG, this.getPrintStream());
        StringTools.writeKeyValueLine(DATE_TAG, udat + ", sequence version " + rs.getVersion() + ".", 5, this.getLineWidth(), null, DATE_TAG, this.getPrintStream());
        StringTools.writeKeyValueLine(DATE_TAG, (adat == null ? udat : adat) + ", entry version " + (arel == null ? "0" : arel) + ".", 5, this.getLineWidth(), null, DATE_TAG, this.getPrintStream());
        StringTools.writeKeyValueLine(DEFINITION_TAG, rs.getDescription() + ".", 5, this.getLineWidth(), null, DEFINITION_TAG, this.getPrintStream());
        Iterator i = genenames.keySet().iterator();
        while (i.hasNext()) {
            Iterator j;
            Integer geneid = (Integer)i.next();
            String genename = (String)genenames.get(geneid);
            List synonyms = (List)genesynonyms.get(geneid);
            List orfs = (List)orfnames.get(geneid);
            List ordlocs = (List)ordlocnames.get(geneid);
            StringBuffer gnline = new StringBuffer();
            gnline.append(Terms.GENENAME_KEY);
            gnline.append("=");
            gnline.append(genename);
            gnline.append("; ");
            if (synonyms != null) {
                gnline.append(Terms.GENESYNONYM_KEY);
                gnline.append("=");
                j = synonyms.iterator();
                while (j.hasNext()) {
                    gnline.append((String)j.next());
                    if (!j.hasNext()) continue;
                    gnline.append(", ");
                }
                gnline.append("; ");
            }
            if (ordlocs != null) {
                gnline.append(Terms.ORDLOCNAME_KEY);
                gnline.append("=");
                j = ordlocs.iterator();
                while (j.hasNext()) {
                    gnline.append((String)j.next());
                    if (!j.hasNext()) continue;
                    gnline.append(", ");
                }
                gnline.append("; ");
            }
            if (orfs != null) {
                gnline.append(Terms.ORFNAME_KEY);
                gnline.append("=");
                j = orfs.iterator();
                while (j.hasNext()) {
                    gnline.append((String)j.next());
                    if (!j.hasNext()) continue;
                    gnline.append(", ");
                }
                gnline.append("; ");
            }
            StringTools.writeKeyValueLine(GENE_TAG, gnline.toString(), 5, this.getLineWidth(), null, GENE_TAG, this.getPrintStream());
            if (!i.hasNext()) continue;
            StringTools.writeKeyValueLine(GENE_TAG, "and", 5, this.getLineWidth(), null, GENE_TAG, this.getPrintStream());
        }
        NCBITaxon tax = rs.getTaxon();
        if (tax != null) {
            StringBuffer source = new StringBuffer();
            source.append(tax.getDisplayName());
            Iterator j = tax.getNames("synonym").iterator();
            while (j.hasNext()) {
                source.append(" (");
                source.append((String)j.next());
                source.append(")");
            }
            source.append(".");
            StringTools.writeKeyValueLine(SOURCE_TAG, source.toString(), 5, this.getLineWidth(), null, SOURCE_TAG, this.getPrintStream());
            if (organelle != null) {
                StringTools.writeKeyValueLine(ORGANELLE_TAG, organelle + ".", 5, this.getLineWidth(), null, ORGANELLE_TAG, this.getPrintStream());
            }
            StringTools.writeKeyValueLine(ORGANISM_TAG, tax.getNameHierarchy(), 5, this.getLineWidth(), null, ORGANISM_TAG, this.getPrintStream());
            StringTools.writeKeyValueLine(TAXON_TAG, "NCBI_TaxID=" + tax.getNCBITaxID() + ";", 5, this.getLineWidth(), this.getPrintStream());
        }
        for (RankedDocRef rdr : rs.getRankedDocRefs()) {
            CrossRef c;
            Iterator i2;
            DocRef d = rdr.getDocumentReference();
            StringTools.writeKeyValueLine(REFERENCE_TAG, "[" + rdr.getRank() + "]", 5, this.getLineWidth(), null, REFERENCE_TAG, this.getPrintStream());
            if (d.getRemark() != null) {
                StringTools.writeKeyValueLine(RP_LINE_TAG, d.getRemark() + ".", 5, this.getLineWidth(), null, RP_LINE_TAG, this.getPrintStream());
            }
            if (rdr.getStart() != null && rdr.getEnd() != null && d.getRemark() != null && !rppat.matcher(d.getRemark()).matches()) {
                StringTools.writeKeyValueLine(RP_LINE_TAG, "SEQUENCE OF " + rdr.getStart() + "-" + rdr.getEnd() + ".", 5, this.getLineWidth(), null, RP_LINE_TAG, this.getPrintStream());
            }
            StringBuffer rcline = new StringBuffer();
            Integer rank = new Integer(rdr.getRank());
            if (speciesRecs.get(rank) != null) {
                rcline.append(Terms.SPECIES_KEY);
                rcline.append("=");
                i2 = ((List)speciesRecs.get(rank)).iterator();
                while (i2.hasNext()) {
                    rcline.append((String)i2.next());
                    if (!i2.hasNext()) continue;
                    rcline.append(", ");
                }
                rcline.append("; ");
            }
            if (strainRecs.get(rank) != null) {
                rcline.append(Terms.STRAIN_KEY);
                rcline.append("=");
                i2 = ((List)strainRecs.get(rank)).iterator();
                while (i2.hasNext()) {
                    rcline.append((String)i2.next());
                    if (!i2.hasNext()) continue;
                    rcline.append(", ");
                }
                rcline.append("; ");
            }
            if (tissueRecs.get(rank) != null) {
                rcline.append(Terms.TISSUE_KEY);
                rcline.append("=");
                i2 = ((List)tissueRecs.get(rank)).iterator();
                while (i2.hasNext()) {
                    rcline.append((String)i2.next());
                    if (!i2.hasNext()) continue;
                    rcline.append(", ");
                }
                rcline.append("; ");
            }
            if (transpRecs.get(rank) != null) {
                rcline.append(Terms.TRANSPOSON_KEY);
                rcline.append("=");
                i2 = ((List)transpRecs.get(rank)).iterator();
                while (i2.hasNext()) {
                    rcline.append((String)i2.next());
                    if (!i2.hasNext()) continue;
                    rcline.append(", ");
                }
                rcline.append("; ");
            }
            if (plasmidRecs.get(rank) != null) {
                rcline.append(Terms.PLASMID_KEY);
                rcline.append("=");
                i2 = ((List)plasmidRecs.get(rank)).iterator();
                while (i2.hasNext()) {
                    rcline.append((String)i2.next());
                    if (!i2.hasNext()) continue;
                    rcline.append(", ");
                }
                rcline.append("; ");
            }
            if (rcline.length() > 0) {
                StringTools.writeKeyValueLine(RC_LINE_TAG, rcline.toString(), 5, this.getLineWidth(), null, RC_LINE_TAG, this.getPrintStream());
            }
            if ((c = d.getCrossref()) != null) {
                StringTools.writeKeyValueLine(REFERENCE_XREF_TAG, c.getDbname() + "=" + c.getAccession() + ";", 5, this.getLineWidth(), null, REFERENCE_XREF_TAG, this.getPrintStream());
            }
            List auths = d.getAuthorList();
            Iterator j = auths.iterator();
            while (j.hasNext()) {
                DocRefAuthor a = (DocRefAuthor)j.next();
                if (!a.isConsortium()) continue;
                StringTools.writeKeyValueLine(CONSORTIUM_TAG, a.getName() + ";", 5, this.getLineWidth(), null, CONSORTIUM_TAG, this.getPrintStream());
                j.remove();
            }
            if (!auths.isEmpty()) {
                StringTools.writeKeyValueLine(AUTHORS_TAG, DocRefAuthor.Tools.generateAuthorString(auths, false) + ";", 5, this.getLineWidth(), null, AUTHORS_TAG, this.getPrintStream());
            }
            if (d.getTitle() != null && d.getTitle().length() != 0) {
                StringTools.writeKeyValueLine(TITLE_TAG, "\"" + d.getTitle() + "\";", 5, this.getLineWidth(), null, TITLE_TAG, this.getPrintStream());
            }
            StringTools.writeKeyValueLine(LOCATION_TAG, d.getLocation() + ".", 5, this.getLineWidth(), null, LOCATION_TAG, this.getPrintStream());
        }
        if (!rs.getComments().isEmpty()) {
            for (SimpleComment c : rs.getComments()) {
                String text = c.getComment().trim();
                if (text.length() > 3 && text.substring(0, 3).equals("-!-")) {
                    StringTools.writeKeyValueLine(COMMENT_TAG, text, 5, this.getLineWidth(), null, COMMENT_TAG, this.getPrintStream());
                    continue;
                }
                StringTools.writeKeyValueLine(COMMENT_TAG, text, 5, this.getLineWidth(), null, COMMENT_TAG, this.getPrintStream());
            }
        }
        if (copyright != null) {
            StringTools.writeKeyValueLine(COMMENT_TAG, copyright, 5, this.getLineWidth(), null, COMMENT_TAG, this.getPrintStream());
        }
        for (RankedCrossRef rcr : rs.getRankedCrossRefs()) {
            CrossRef c = rcr.getCrossRef();
            Set noteset = c.getNoteSet();
            StringBuffer sb = new StringBuffer();
            sb.append(c.getDbname());
            sb.append("; ");
            sb.append(c.getAccession());
            boolean hasSecondary = false;
            for (Note n : noteset) {
                if (!n.getTerm().equals(Terms.getAdditionalAccessionTerm())) continue;
                sb.append("; ");
                sb.append(n.getValue());
                hasSecondary = true;
            }
            if (!hasSecondary) {
                sb.append("; -");
            }
            sb.append(".");
            StringTools.writeKeyValueLine(DATABASE_XREF_TAG, sb.toString(), 5, this.getLineWidth(), null, DATABASE_XREF_TAG, this.getPrintStream());
        }
        if (protExists != null) {
            StringTools.writeKeyValueLine(PROTEIN_EXIST_TAG, protExists + ";", 5, this.getLineWidth(), null, PROTEIN_EXIST_TAG, this.getPrintStream());
        }
        String keywords = null;
        for (Note nt : notes) {
            if (!nt.getTerm().equals(Terms.getKeywordTerm())) continue;
            if (keywords == null) {
                keywords = nt.getValue();
                continue;
            }
            keywords = keywords + "; " + nt.getValue();
        }
        if (keywords != null) {
            StringTools.writeKeyValueLine(KEYWORDS_TAG, keywords + ".", 5, this.getLineWidth(), null, KEYWORDS_TAG, this.getPrintStream());
        }
        for (RichFeature f : rs.getFeatureSet()) {
            String desc = "";
            String ftid = null;
            for (Note n : f.getNoteSet()) {
                if (n.getTerm().equals(Terms.getFTIdTerm())) {
                    ftid = n.getValue();
                    continue;
                }
                if (!n.getTerm().equals(Terms.getFeatureDescTerm())) continue;
                desc = n.getValue();
            }
            String kw = f.getTypeTerm().getName();
            String leader = StringTools.rightPad(kw, 8) + " " + UniProtLocationParser.writeLocation((RichLocation)f.getLocation());
            if (desc.length() == 0) {
                this.getPrintStream().println("FT   " + leader);
            } else {
                StringTools.writeKeyValueLine("FT   " + leader, desc + ".", 34, this.getLineWidth(), null, FEATURE_TAG, this.getPrintStream());
            }
            if (ftid == null) continue;
            StringTools.writeKeyValueLine(FEATURE_TAG, "/FTId=" + ftid + ".", 34, this.getLineWidth(), null, FEATURE_TAG, this.getPrintStream());
        }
        int mw = 0;
        try {
            mw = (int)MassCalc.getMolecularWeight(rs);
        }
        catch (IllegalSymbolException e) {
            throw new RuntimeException("Found illegal symbol", e);
        }
        CRC64Checksum crc = new CRC64Checksum();
        String seqstr = rs.seqString();
        crc.update(seqstr.getBytes(), 0, seqstr.length());
        this.getPrintStream().print("SQ   SEQUENCE  " + StringTools.leftPad("" + rs.length(), 4) + " AA;  ");
        this.getPrintStream().print(StringTools.leftPad("" + mw, 5) + " MW;  ");
        this.getPrintStream().println(crc + " CRC64;");
        Symbol[] syms = rs.toList().toArray(new Symbol[0]);
        int symCount = 0;
        this.getPrintStream().print("    ");
        for (int i3 = 0; i3 < syms.length; ++i3) {
            if (symCount % 60 == 0 && symCount > 0) {
                this.getPrintStream().print("\n    ");
            }
            if (symCount % 10 == 0) {
                this.getPrintStream().print(" ");
            }
            try {
                this.getPrintStream().print(tok.tokenizeSymbol(syms[i3]));
            }
            catch (IllegalSymbolException e) {
                throw new RuntimeException("Found illegal symbol: " + syms[i3]);
            }
            ++symCount;
        }
        this.getPrintStream().print("\n");
        this.getPrintStream().println(END_SEQUENCE_TAG);
    }

    @Override
    public String getDefaultFormat() {
        return UNIPROT_FORMAT;
    }

    String sectionToString(List section) {
        StringBuffer parseBlock = new StringBuffer();
        ListIterator i = section.listIterator();
        while (i.hasNext()) {
            String[] part = (String[])i.next();
            for (int x = 0; x < part.length; ++x) {
                parseBlock.append(part[x]);
                if (x != 0) continue;
                parseBlock.append("   ");
            }
        }
        return parseBlock.toString();
    }

    static {
        RichSequence.IOTools.registerFormat(UniProtFormat.class);
        lp = Pattern.compile("^((\\S+)_(\\S+))\\s+(\\S+);\\s+(PRT)?;?\\s*\\d+\\s+AA\\.$");
        rppat = Pattern.compile("SEQUENCE OF (\\d+)-(\\d+)");
        dp = Pattern.compile("([^,]+),([^\\d\\.]+)(\\d+)?\\.$");
        fp = Pattern.compile("^\\s*([\\d?<]+\\s+[\\d?>]+)(\\s+(.*))?$");
        headerLine = Pattern.compile("^ID.*");
    }

    public static class Terms
    extends RichSequence.Terms {
        private static ComparableTerm UNIPROT_TERM = null;
        private static ComparableTerm UNIPROT_DBNAME_TERM = null;
        private static ComparableTerm UNIPROT_PROTEIN_EXISTS_TERM = null;
        private static String GENENAME_KEY = "Name";
        private static String GENESYNONYM_KEY = "Synonyms";
        private static String ORDLOCNAME_KEY = "OrderedLocusNames";
        private static String ORFNAME_KEY = "ORFNames";

        public static ComparableTerm getUniProtTerm() {
            if (UNIPROT_TERM == null) {
                UNIPROT_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm(UniProtFormat.UNIPROT_FORMAT);
            }
            return UNIPROT_TERM;
        }

        public static ComparableTerm getUniProtDBNameTerm() {
            if (UNIPROT_DBNAME_TERM == null) {
                UNIPROT_DBNAME_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("UniProt database name");
            }
            return UNIPROT_DBNAME_TERM;
        }

        public static ComparableTerm getProteinExistsTerm() {
            if (UNIPROT_PROTEIN_EXISTS_TERM == null) {
                UNIPROT_PROTEIN_EXISTS_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("UniProt protein exists");
            }
            return UNIPROT_PROTEIN_EXISTS_TERM;
        }
    }
}

