/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.SimpleRichSequenceBuilder;
import org.biojavax.bio.seq.io.UniProtFormat;

public class UniProtFormatTest
extends TestCase {
    private UniProtFormat unpFormat;

    protected void setUp() {
        this.unpFormat = new UniProtFormat();
    }

    public void testReadEmptySequence() {
        RichSequence sequence = this.readFile("/files/empty_uniprot.pro");
        UniProtFormatTest.assertNotNull((Object)sequence);
        UniProtFormatTest.assertEquals((String)sequence.getName(), (String)"testempty");
        UniProtFormatTest.assertEquals((String)sequence.getAccession(), (String)"");
        UniProtFormatTest.assertEquals((int)sequence.getVersion(), (int)0);
        UniProtFormatTest.assertEquals((String)sequence.getDescription(), (String)"no sequence");
        UniProtFormatTest.assertEquals((int)sequence.getInternalSymbolList().length(), (int)0);
    }

    private RichSequence readFile(String filename) {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        SymbolTokenization tokenization = RichSequence.IOTools.getDNAParser();
        Namespace namespace = RichObjectFactory.getDefaultNamespace();
        SimpleRichSequenceBuilder builder = new SimpleRichSequenceBuilder();
        RichSequence sequence = null;
        try {
            this.unpFormat.readRichSequence(br, tokenization, builder, namespace);
            sequence = builder.makeRichSequence();
        }
        catch (Exception e) {
            e.printStackTrace();
            UniProtFormatTest.fail((String)("Unexpected exception: " + e));
        }
        return sequence;
    }
}

