/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.biojava.bio.proteomics.MassCalc;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.xml.PrettyXMLWriter;
import org.biojava.utils.xml.XMLWriter;
import org.biojavax.Comment;
import org.biojavax.CrossRef;
import org.biojavax.DocRef;
import org.biojavax.DocRefAuthor;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RankedCrossRef;
import org.biojavax.RankedDocRef;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleDocRef;
import org.biojavax.SimpleNote;
import org.biojavax.SimpleRankedCrossRef;
import org.biojavax.SimpleRankedDocRef;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.RichSeqIOListener;
import org.biojavax.bio.seq.io.RichSequenceFormat;
import org.biojavax.bio.seq.io.UniProtCommentParser;
import org.biojavax.bio.seq.io.UniProtLocationParser;
import org.biojavax.bio.taxa.NCBITaxon;
import org.biojavax.ontology.ComparableOntology;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.ontology.SimpleComparableOntology;
import org.biojavax.utils.CRC64Checksum;
import org.biojavax.utils.StringTools;
import org.biojavax.utils.XMLTools;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UniProtXMLFormat
extends RichSequenceFormat.BasicFormat {
    public static final String UNIPROTXML_FORMAT = "UniProtXML";
    protected static final String ENTRY_GROUP_TAG = "uniprot";
    protected static final String ENTRY_TAG = "entry";
    protected static final String ENTRY_VERSION_ATTR = "version";
    protected static final String ENTRY_NAMESPACE_ATTR = "dataset";
    protected static final String ENTRY_CREATED_ATTR = "created";
    protected static final String ENTRY_UPDATED_ATTR = "modified";
    protected static final String COPYRIGHT_TAG = "copyright";
    protected static final String ACCESSION_TAG = "accession";
    protected static final String NAME_TAG = "name";
    protected static final String TEXT_TAG = "text";
    protected static final String REF_ATTR = "ref";
    protected static final String TYPE_ATTR = "type";
    protected static final String KEY_ATTR = "key";
    protected static final String ID_ATTR = "id";
    protected static final String EVIDENCE_ATTR = "evidence";
    protected static final String VALUE_ATTR = "value";
    protected static final String STATUS_ATTR = "value";
    protected static final String NAME_ATTR = "name";
    protected static final String PROTEIN_TAG = "protein";
    protected static final String PROTEIN_TYPE_ATTR = "type";
    protected static final String DOMAIN_TAG = "domain";
    protected static final String COMPONENT_TAG = "component";
    protected static final String GENE_TAG = "gene";
    protected static final String ORGANISM_TAG = "organism";
    protected static final String DBXREF_TAG = "dbReference";
    protected static final String PROPERTY_TAG = "property";
    protected static final String LINEAGE_TAG = "lineage";
    protected static final String TAXON_TAG = "taxon";
    protected static final String GENELOCATION_TAG = "geneLocation";
    protected static final String GENELOCATION_NAME_TAG = "name";
    protected static final String REFERENCE_TAG = "reference";
    protected static final String CITATION_TAG = "citation";
    protected static final String TITLE_TAG = "title";
    protected static final String EDITOR_LIST_TAG = "editorList";
    protected static final String AUTHOR_LIST_TAG = "authorList";
    protected static final String PERSON_TAG = "person";
    protected static final String CONSORTIUM_TAG = "consortium";
    protected static final String LOCATOR_TAG = "locator";
    protected static final String RP_LINE_TAG = "scope";
    protected static final String RC_LINE_TAG = "source";
    protected static final String RC_SPECIES_TAG = "species";
    protected static final String RC_TISSUE_TAG = "tissue";
    protected static final String RC_TRANSP_TAG = "transposon";
    protected static final String RC_STRAIN_TAG = "strain";
    protected static final String RC_PLASMID_TAG = "plasmid";
    protected static final String COMMENT_TAG = "comment";
    protected static final String COMMENT_MASS_ATTR = "mass";
    protected static final String COMMENT_ERROR_ATTR = "error";
    protected static final String COMMENT_METHOD_ATTR = "method";
    protected static final String COMMENT_LOCTYPE_ATTR = "locationType";
    protected static final String COMMENT_ABSORPTION_TAG = "absorption";
    protected static final String COMMENT_ABS_MAX_TAG = "max";
    protected static final String COMMENT_KINETICS_TAG = "kinetics";
    protected static final String COMMENT_KIN_KM_TAG = "KM";
    protected static final String COMMENT_KIN_VMAX_TAG = "VMax";
    protected static final String COMMENT_PH_TAG = "phDependence";
    protected static final String COMMENT_REDOX_TAG = "redoxPotential";
    protected static final String COMMENT_TEMPERATURE_TAG = "temperatureDependence";
    protected static final String COMMENT_LINK_TAG = "link";
    protected static final String COMMENT_LINK_URI_ATTR = "uri";
    protected static final String COMMENT_EVENT_TAG = "event";
    protected static final String COMMENT_ISOFORM_TAG = "isoform";
    protected static final String COMMENT_INTERACTANT_TAG = "interactant";
    protected static final String COMMENT_INTERACT_INTACT_ATTR = "intactId";
    protected static final String COMMENT_INTERACT_LABEL_TAG = "label";
    protected static final String COMMENT_ORGANISMS_TAG = "organismsDiffer";
    protected static final String COMMENT_EXPERIMENTS_TAG = "experiments";
    protected static final String NOTE_TAG = "note";
    protected static final String KEYWORD_TAG = "keyword";
    protected static final String PROTEIN_EXISTS_TAG = "proteinExistence";
    protected static final String ID_TAG = "id";
    protected static final String FEATURE_TAG = "feature";
    protected static final String FEATURE_DESC_ATTR = "description";
    protected static final String FEATURE_ORIGINAL_TAG = "original";
    protected static final String FEATURE_VARIATION_TAG = "variation";
    protected static final String EVIDENCE_TAG = "evidence";
    protected static final String EVIDENCE_CATEGORY_ATTR = "category";
    protected static final String EVIDENCE_ATTRIBUTE_ATTR = "attribute";
    protected static final String EVIDENCE_DATE_ATTR = "date";
    protected static final String LOCATION_TAG = "location";
    protected static final String LOCATION_SEQ_ATTR = "sequence";
    protected static final String LOCATION_BEGIN_TAG = "begin";
    protected static final String LOCATION_END_TAG = "end";
    protected static final String LOCATION_POSITION_ATTR = "position";
    protected static final String LOCATION_POSITION_TAG = "position";
    protected static final String SEQUENCE_TAG = "sequence";
    protected static final String SEQUENCE_VERSION_ATTR = "version";
    protected static final String SEQUENCE_LENGTH_ATTR = "length";
    protected static final String SEQUENCE_MASS_ATTR = "mass";
    protected static final String SEQUENCE_CHECKSUM_ATTR = "checksum";
    protected static final String SEQUENCE_MODIFIED_ATTR = "modified";
    protected static final Pattern rppat;
    protected static final Pattern xmlSchema;
    private PrintWriter pw;
    private XMLWriter xml;

    @Override
    public boolean canRead(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        br.readLine();
        String secondLine = br.readLine();
        boolean readable = secondLine != null && xmlSchema.matcher(secondLine).matches();
        br.close();
        return readable;
    }

    @Override
    public SymbolTokenization guessSymbolTokenization(File file) throws IOException {
        return RichSequence.IOTools.getProteinParser();
    }

    @Override
    public boolean canRead(BufferedInputStream stream) throws IOException {
        stream.mark(2000);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        br.readLine();
        String secondLine = br.readLine();
        boolean readable = secondLine != null && xmlSchema.matcher(secondLine).matches();
        stream.reset();
        return readable;
    }

    @Override
    public SymbolTokenization guessSymbolTokenization(BufferedInputStream stream) throws IOException {
        return RichSequence.IOTools.getProteinParser();
    }

    @Override
    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        if (!(listener instanceof RichSeqIOListener)) {
            throw new IllegalArgumentException("Only accepting RichSeqIOListeners today");
        }
        return this.readRichSequence(reader, symParser, (RichSeqIOListener)listener, null);
    }

    @Override
    public boolean readRichSequence(BufferedReader reader, SymbolTokenization symParser, RichSeqIOListener rlistener, Namespace ns) throws IllegalSymbolException, IOException, ParseException {
        Pattern copyright = Pattern.compile(".*<copyright.*");
        try {
            rlistener.startSequence();
            UniProtXMLHandler m_handler = new UniProtXMLHandler(this, symParser, rlistener, ns);
            boolean hasMore = XMLTools.readXMLChunk(reader, m_handler, ENTRY_TAG);
            reader.mark(10000);
            String line = reader.readLine();
            reader.reset();
            if (copyright.matcher(line).matches()) {
                XMLTools.readXMLChunk(reader, m_handler, COPYRIGHT_TAG);
            }
            rlistener.endSequence();
            return hasMore;
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void beginWriting() throws IOException {
        this.pw = new PrintWriter(this.getPrintStream());
        this.xml = new PrettyXMLWriter(this.pw);
        this.xml.printRaw("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.xml.openTag(ENTRY_GROUP_TAG);
        this.xml.attribute("xmlns", "http://uniprot.org/uniprot");
        this.xml.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.xml.attribute("xsi:schemaLocation", "http://uniprot.org/uniprot http://www.uniprot.org/support/docs/uniprot.xsd");
    }

    @Override
    public void finishWriting() throws IOException {
        this.xml.closeTag(ENTRY_GROUP_TAG);
        this.pw.flush();
    }

    @Override
    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(this.getPrintStream());
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    @Override
    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(this.getPrintStream());
        }
        if (!format.equals(this.getDefaultFormat())) {
            throw new IllegalArgumentException("Unknown format: " + format);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    @Override
    public void writeSequence(Sequence seq, Namespace ns) throws IOException {
        Iterator j;
        String desc;
        RichSequence rs;
        try {
            rs = seq instanceof RichSequence ? (RichSequence)seq : RichSequence.Tools.enrich(seq);
        }
        catch (ChangeVetoException e) {
            IOException e2 = new IOException("Unable to enrich sequence");
            e2.initCause(e);
            throw e2;
        }
        int key = 1;
        Set notes = rs.getNoteSet();
        ArrayList<String> accessions = new ArrayList<String>();
        ArrayList<ComparableTerm> kws = new ArrayList<ComparableTerm>();
        String cdat = null;
        String udat = null;
        String arel = null;
        String adat = null;
        String copyright = null;
        String proteinType = null;
        String proteinExists = null;
        TreeMap<Integer, String> genenames = new TreeMap<Integer, String>();
        TreeMap genesynonyms = new TreeMap();
        TreeMap orfnames = new TreeMap();
        TreeMap ordlocnames = new TreeMap();
        TreeSet<Integer> evidenceIDs = new TreeSet<Integer>();
        TreeSet<String> organelles = new TreeSet<String>();
        TreeMap<Integer, String> evcats = new TreeMap<Integer, String>();
        TreeMap<Integer, String> evtypes = new TreeMap<Integer, String>();
        TreeMap<Integer, String> evdates = new TreeMap<Integer, String>();
        TreeMap<Integer, String> evattrs = new TreeMap<Integer, String>();
        TreeMap speciesRecs = new TreeMap();
        TreeMap strainRecs = new TreeMap();
        TreeMap tissueRecs = new TreeMap();
        TreeMap transpRecs = new TreeMap();
        TreeMap plasmidRecs = new TreeMap();
        for (Note n : notes) {
            Integer refID;
            int colon;
            String ref;
            if (n.getTerm().equals(Terms.getDateCreatedTerm())) {
                cdat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getDateUpdatedTerm())) {
                udat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getRelAnnotatedTerm())) {
                arel = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getDateAnnotatedTerm())) {
                adat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getAdditionalAccessionTerm())) {
                accessions.add(n.getValue());
                continue;
            }
            if (n.getTerm().equals(Terms.getOrganelleTerm())) {
                organelles.add(n.getValue());
                continue;
            }
            if (n.getTerm().equals(Terms.getKeywordTerm())) {
                ComparableTerm t = Terms.getUniprotKWOnto().getOrCreateTerm(n.getValue());
                try {
                    if (t.getIdentifier() == null || t.getIdentifier().length() == 0) {
                        t.setIdentifier("UNKNOWN");
                    }
                }
                catch (ChangeVetoException ce) {
                    IOException e = new IOException("Failed to assign keyword identifier");
                    e.initCause(ce);
                    throw e;
                }
                kws.add(t);
                continue;
            }
            if (n.getTerm().equals(Terms.getCopyrightTerm())) {
                copyright = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getProteinTypeTerm())) {
                proteinType = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getProteinExistsTerm())) {
                proteinExists = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getGeneNameTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                genenames.put(refID, ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getGeneSynonymTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (genesynonyms.get(refID) == null) {
                    genesynonyms.put(refID, new ArrayList());
                }
                ((List)genesynonyms.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getOrderedLocusNameTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (ordlocnames.get(refID) == null) {
                    ordlocnames.put(refID, new ArrayList());
                }
                ((List)ordlocnames.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getORFNameTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (orfnames.get(refID) == null) {
                    orfnames.put(refID, new ArrayList());
                }
                ((List)orfnames.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getEvidenceCategoryTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                evcats.put(refID, ref.substring(colon + 1));
                evidenceIDs.add(refID);
                continue;
            }
            if (n.getTerm().equals(Terms.getEvidenceTypeTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                evtypes.put(refID, ref.substring(colon + 1));
                evidenceIDs.add(refID);
                continue;
            }
            if (n.getTerm().equals(Terms.getEvidenceDateTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                evdates.put(refID, ref.substring(colon + 1));
                evidenceIDs.add(refID);
                continue;
            }
            if (n.getTerm().equals(Terms.getEvidenceAttrTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                evattrs.put(refID, ref.substring(colon + 1));
                evidenceIDs.add(refID);
                continue;
            }
            if (n.getTerm().equals(Terms.getSpeciesTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (speciesRecs.get(refID) == null) {
                    speciesRecs.put(refID, new ArrayList());
                }
                ((List)speciesRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getStrainTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (strainRecs.get(refID) == null) {
                    strainRecs.put(refID, new ArrayList());
                }
                ((List)strainRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getTissueTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (tissueRecs.get(refID) == null) {
                    tissueRecs.put(refID, new ArrayList());
                }
                ((List)tissueRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (n.getTerm().equals(Terms.getTransposonTerm())) {
                ref = n.getValue();
                colon = ref.indexOf(58);
                refID = new Integer(0);
                if (colon >= 1) {
                    refID = new Integer(ref.substring(0, colon));
                }
                if (transpRecs.get(refID) == null) {
                    transpRecs.put(refID, new ArrayList());
                }
                ((List)transpRecs.get(refID)).add(ref.substring(colon + 1));
                continue;
            }
            if (!n.getTerm().equals(Terms.getPlasmidTerm())) continue;
            ref = n.getValue();
            colon = ref.indexOf(58);
            refID = new Integer(0);
            if (colon >= 1) {
                refID = new Integer(ref.substring(0, colon));
            }
            if (plasmidRecs.get(refID) == null) {
                plasmidRecs.put(refID, new ArrayList());
            }
            ((List)plasmidRecs.get(refID)).add(ref.substring(colon + 1));
        }
        this.xml.openTag(ENTRY_TAG);
        this.xml.attribute("version", "" + (arel == null ? "" + rs.getVersion() : arel));
        this.xml.attribute(ENTRY_NAMESPACE_ATTR, ns == null ? rs.getNamespace().getName() : ns.getName());
        this.xml.attribute(ENTRY_CREATED_ATTR, cdat);
        this.xml.attribute("modified", adat == null ? cdat : adat);
        this.xml.openTag(ACCESSION_TAG);
        this.xml.print(rs.getAccession());
        this.xml.closeTag(ACCESSION_TAG);
        this.xml.openTag("name");
        this.xml.print(rs.getName());
        this.xml.closeTag("name");
        this.xml.openTag(PROTEIN_TAG);
        if (proteinType != null) {
            this.xml.attribute("type", proteinType);
        }
        if ((desc = rs.getDescription().trim()).endsWith(".")) {
            desc = desc.substring(0, desc.length() - 1);
        }
        String[] parts = desc.split("\\[");
        for (int j2 = 0; j2 < parts.length; ++j2) {
            String name;
            int l;
            String[] names;
            int k;
            String chunk;
            if (parts[j2].startsWith("Contains:")) {
                chunk = parts[j2].substring("Contains:".length() + 1).trim();
                if (chunk.endsWith("]")) {
                    chunk = chunk.substring(0, chunk.length() - 1);
                }
                String[] moreparts = chunk.split(";");
                for (k = 0; k < moreparts.length; ++k) {
                    this.xml.openTag(DOMAIN_TAG);
                    names = moreparts[k].split("\\(");
                    for (l = 0; l < names.length; ++l) {
                        name = names[l].trim();
                        if (name.endsWith(")")) {
                            name = name.substring(0, name.length() - 1);
                        }
                        this.xml.openTag("name");
                        this.xml.print(name);
                        this.xml.closeTag("name");
                    }
                    this.xml.closeTag(DOMAIN_TAG);
                }
                continue;
            }
            if (parts[j2].startsWith("Includes:")) {
                chunk = parts[j2].substring("Includes:".length() + 1).trim();
                if (chunk.endsWith("]")) {
                    chunk = chunk.substring(0, chunk.length() - 1);
                }
                String[] moreparts = chunk.split(";");
                for (k = 0; k < moreparts.length; ++k) {
                    this.xml.openTag(COMPONENT_TAG);
                    names = moreparts[k].split("\\(");
                    for (l = 0; l < names.length; ++l) {
                        name = names[l].trim();
                        if (name.endsWith(")")) {
                            name = name.substring(0, name.length() - 1);
                        }
                        this.xml.openTag("name");
                        this.xml.print(name);
                        this.xml.closeTag("name");
                    }
                    this.xml.closeTag(COMPONENT_TAG);
                }
                continue;
            }
            String[] names2 = parts[j2].split("\\(");
            for (int l2 = 0; l2 < names2.length; ++l2) {
                String name2 = names2[l2].trim();
                if (name2.endsWith(")")) {
                    name2 = name2.substring(0, name2.length() - 1);
                }
                this.xml.openTag("name");
                this.xml.print(name2);
                this.xml.closeTag("name");
            }
        }
        this.xml.closeTag(PROTEIN_TAG);
        for (Integer geneid : genenames.keySet()) {
            String genename = (String)genenames.get(geneid);
            List synonyms = (List)genesynonyms.get(geneid);
            List orfs = (List)orfnames.get(geneid);
            List ordlocs = (List)ordlocnames.get(geneid);
            this.xml.openTag(GENE_TAG);
            this.xml.openTag("name");
            this.xml.attribute("type", "primary");
            this.xml.print(genename);
            this.xml.closeTag("name");
            if (synonyms != null) {
                j = synonyms.iterator();
                while (j.hasNext()) {
                    this.xml.openTag("name");
                    this.xml.attribute("type", "synonym");
                    this.xml.print((String)j.next());
                    this.xml.closeTag("name");
                }
            }
            if (ordlocs != null) {
                j = synonyms.iterator();
                while (j.hasNext()) {
                    this.xml.openTag("name");
                    this.xml.attribute("type", "ordered locus");
                    this.xml.print((String)j.next());
                    this.xml.closeTag("name");
                }
            }
            if (orfs != null) {
                j = synonyms.iterator();
                while (j.hasNext()) {
                    this.xml.openTag("name");
                    this.xml.attribute("type", "ORF");
                    this.xml.print((String)j.next());
                    this.xml.closeTag("name");
                }
            }
            this.xml.closeTag(GENE_TAG);
        }
        NCBITaxon tax = rs.getTaxon();
        if (tax != null) {
            this.xml.openTag(ORGANISM_TAG);
            this.xml.attribute(KEY_ATTR, "" + key++);
            for (String nameclass : tax.getNameClasses()) {
                String ournameclass = "common";
                if (nameclass.equalsIgnoreCase("full")) {
                    ournameclass = "equivalent name";
                } else if (nameclass.equalsIgnoreCase("scientific")) {
                    ournameclass = "scientific name";
                } else if (nameclass.equalsIgnoreCase("synonym")) {
                    ournameclass = "synonym";
                } else if (nameclass.equalsIgnoreCase("abbreviation")) {
                    ournameclass = "acronym";
                }
                Iterator j3 = tax.getNames(nameclass).iterator();
                while (j3.hasNext()) {
                    this.xml.openTag("name");
                    this.xml.attribute("type", ournameclass);
                    this.xml.print((String)j3.next());
                    this.xml.closeTag("name");
                }
            }
            this.xml.openTag(DBXREF_TAG);
            this.xml.attribute(KEY_ATTR, "" + key++);
            this.xml.attribute("type", "NCBI Taxonomy");
            this.xml.attribute("id", "" + tax.getNCBITaxID());
            this.xml.closeTag(DBXREF_TAG);
            String h = tax.getNameHierarchy();
            h = h.substring(0, h.length() - 1);
            String[] hierarch = h.split(";");
            this.xml.openTag(LINEAGE_TAG);
            for (int j4 = 0; j4 < hierarch.length; ++j4) {
                this.xml.openTag(TAXON_TAG);
                this.xml.print(hierarch[j4].trim());
                this.xml.closeTag(TAXON_TAG);
            }
            this.xml.closeTag(LINEAGE_TAG);
            this.xml.closeTag(ORGANISM_TAG);
        }
        for (String org : organelles) {
            this.xml.openTag(GENELOCATION_TAG);
            if (org.startsWith("Plasmid")) {
                this.xml.attribute("type", RC_PLASMID_TAG);
                String[] subparts = org.split(",");
                for (int j5 = 0; j5 < parts.length; ++j5) {
                    org = subparts[j5].trim();
                    if (org.startsWith("and")) {
                        org = org.substring(3).trim();
                    }
                    org = org.substring("Plasmid".length()).trim();
                    this.xml.openTag("name");
                    this.xml.attribute("value", "known");
                    this.xml.print(org);
                    this.xml.closeTag("name");
                }
            } else {
                this.xml.attribute("type", org.toLowerCase());
            }
            this.xml.closeTag(GENELOCATION_TAG);
        }
        for (RankedDocRef rdr : rs.getRankedDocRefs()) {
            Iterator j6;
            DocRef dr = rdr.getDocumentReference();
            this.xml.openTag(REFERENCE_TAG);
            this.xml.attribute(KEY_ATTR, "" + key++);
            this.xml.openTag(CITATION_TAG);
            this.xml.attribute("type", "journal article");
            if (dr.getTitle() != null) {
                this.xml.openTag(TITLE_TAG);
                this.xml.print(dr.getTitle());
                this.xml.closeTag(TITLE_TAG);
            }
            ArrayList auths = new ArrayList(dr.getAuthorList());
            ArrayList editors = new ArrayList(auths);
            j = editors.iterator();
            while (j.hasNext()) {
                DocRefAuthor a = (DocRefAuthor)j.next();
                if (!a.isEditor()) {
                    j.remove();
                    continue;
                }
                auths.remove(a);
            }
            if (!editors.isEmpty()) {
                this.xml.openTag(EDITOR_LIST_TAG);
                for (DocRefAuthor a : editors) {
                    if (!a.isEditor()) continue;
                    if (a.isConsortium()) {
                        this.xml.openTag(CONSORTIUM_TAG);
                        this.xml.attribute("name", a.getName());
                        this.xml.closeTag(CONSORTIUM_TAG);
                        continue;
                    }
                    this.xml.openTag(PERSON_TAG);
                    this.xml.attribute("name", a.getName());
                    this.xml.closeTag(PERSON_TAG);
                }
                this.xml.closeTag(EDITOR_LIST_TAG);
            }
            if (!auths.isEmpty()) {
                this.xml.openTag(AUTHOR_LIST_TAG);
                for (DocRefAuthor a : auths) {
                    if (a.isConsortium()) {
                        this.xml.openTag(CONSORTIUM_TAG);
                        this.xml.attribute("name", a.getName());
                        this.xml.closeTag(CONSORTIUM_TAG);
                        continue;
                    }
                    this.xml.openTag(PERSON_TAG);
                    this.xml.attribute("name", a.getName());
                    this.xml.closeTag(PERSON_TAG);
                }
                this.xml.closeTag(AUTHOR_LIST_TAG);
            }
            this.xml.openTag(LOCATOR_TAG);
            this.xml.print(dr.getLocation());
            this.xml.closeTag(LOCATOR_TAG);
            CrossRef cr = dr.getCrossref();
            if (cr != null) {
                this.xml.openTag(DBXREF_TAG);
                this.xml.attribute("type", cr.getDbname());
                this.xml.attribute("id", cr.getAccession());
                this.xml.attribute(KEY_ATTR, "" + key++);
                if (!cr.getNoteSet().isEmpty()) {
                    for (Note n : cr.getNoteSet()) {
                        this.xml.openTag(PROPERTY_TAG);
                        this.xml.attribute("type", n.getTerm().getName());
                        this.xml.attribute("value", n.getValue());
                        this.xml.closeTag(PROPERTY_TAG);
                    }
                }
                this.xml.closeTag(DBXREF_TAG);
            }
            this.xml.closeTag(CITATION_TAG);
            this.xml.openTag(RP_LINE_TAG);
            this.xml.print(dr.getRemark());
            this.xml.closeTag(RP_LINE_TAG);
            if (rdr.getStart() != null && rdr.getEnd() != null && !rppat.matcher(dr.getRemark()).matches()) {
                this.xml.openTag(RP_LINE_TAG);
                this.xml.print("SEQUENCE OF " + rdr.getStart() + "-" + rdr.getEnd() + ".");
                this.xml.closeTag(RP_LINE_TAG);
            }
            boolean rcOpened = false;
            Integer rank = new Integer(rdr.getRank());
            if (speciesRecs.get(rank) != null) {
                if (!rcOpened) {
                    this.xml.openTag(RC_LINE_TAG);
                    rcOpened = true;
                }
                j6 = ((List)speciesRecs.get(rank)).iterator();
                while (j6.hasNext()) {
                    this.xml.openTag(RC_SPECIES_TAG);
                    this.xml.print((String)j6.next());
                    this.xml.closeTag(RC_SPECIES_TAG);
                }
            }
            if (strainRecs.get(rank) != null) {
                if (!rcOpened) {
                    this.xml.openTag(RC_LINE_TAG);
                    rcOpened = true;
                }
                j6 = ((List)strainRecs.get(rank)).iterator();
                while (j6.hasNext()) {
                    this.xml.openTag(RC_STRAIN_TAG);
                    this.xml.print((String)j6.next());
                    this.xml.closeTag(RC_STRAIN_TAG);
                }
            }
            if (tissueRecs.get(rank) != null) {
                if (!rcOpened) {
                    this.xml.openTag(RC_LINE_TAG);
                    rcOpened = true;
                }
                j6 = ((List)tissueRecs.get(rank)).iterator();
                while (j6.hasNext()) {
                    this.xml.openTag(RC_TISSUE_TAG);
                    this.xml.print((String)j6.next());
                    this.xml.closeTag(RC_TISSUE_TAG);
                }
            }
            if (transpRecs.get(rank) != null) {
                if (!rcOpened) {
                    this.xml.openTag(RC_LINE_TAG);
                    rcOpened = true;
                }
                j6 = ((List)transpRecs.get(rank)).iterator();
                while (j6.hasNext()) {
                    this.xml.openTag(RC_TRANSP_TAG);
                    this.xml.print((String)j6.next());
                    this.xml.closeTag(RC_TRANSP_TAG);
                }
            }
            if (plasmidRecs.get(rank) != null) {
                if (!rcOpened) {
                    this.xml.openTag(RC_LINE_TAG);
                    rcOpened = true;
                }
                j6 = ((List)plasmidRecs.get(rank)).iterator();
                while (j6.hasNext()) {
                    this.xml.openTag(RC_PLASMID_TAG);
                    this.xml.print((String)j6.next());
                    this.xml.closeTag(RC_PLASMID_TAG);
                }
            }
            if (rcOpened) {
                this.xml.closeTag(RC_LINE_TAG);
            }
            this.xml.closeTag(REFERENCE_TAG);
        }
        for (Comment c : rs.getComments()) {
            if (!UniProtCommentParser.isParseable(c)) continue;
            UniProtCommentParser ucp = new UniProtCommentParser();
            try {
                ucp.parseComment(c);
            }
            catch (ParseException ce) {
                IOException e = new IOException("Failed to parse comment when outputting");
                e.initCause(ce);
                throw e;
            }
            String type = ucp.getCommentType();
            String xtype = type.toLowerCase();
            if (type.equalsIgnoreCase("PTM")) {
                xtype = "posttranslational modification";
            } else if (type.equalsIgnoreCase("DATABASE")) {
                xtype = "online information";
            }
            this.xml.openTag(COMMENT_TAG);
            this.xml.attribute("type", xtype);
            if (type.equalsIgnoreCase("DATABASE")) {
                this.xml.attribute("name", ucp.getDatabaseName());
                this.xml.openTag(COMMENT_LINK_TAG);
                this.xml.attribute(COMMENT_LINK_URI_ATTR, ucp.getUri());
                this.xml.closeTag(COMMENT_LINK_TAG);
            } else if (type.equalsIgnoreCase("MASS SPECTROMETRY")) {
                this.xml.attribute("mass", "" + ucp.getMolecularWeight());
                if (ucp.getMolWeightError() != null) {
                    this.xml.attribute(COMMENT_ERROR_ATTR, "" + ucp.getMolWeightError());
                }
                this.xml.attribute(COMMENT_METHOD_ATTR, "" + ucp.getMolWeightMethod());
                this.xml.openTag(LOCATION_TAG);
                this.xml.openTag(LOCATION_BEGIN_TAG);
                this.xml.attribute("position", "" + ucp.getMolWeightRangeStart());
                this.xml.closeTag(LOCATION_BEGIN_TAG);
                this.xml.openTag(LOCATION_END_TAG);
                this.xml.attribute("position", "" + ucp.getMolWeightRangeEnd());
                this.xml.closeTag(LOCATION_END_TAG);
                this.xml.closeTag(LOCATION_TAG);
            } else if (type.equalsIgnoreCase("INTERACTION")) {
                j = ucp.getInteractions().iterator();
                while (j.hasNext()) {
                    UniProtCommentParser.Interaction interact = (UniProtCommentParser.Interaction)j.next();
                    this.xml.openTag(COMMENT_INTERACTANT_TAG);
                    this.xml.attribute(COMMENT_INTERACT_INTACT_ATTR, interact.getFirstIntActID());
                    this.xml.closeTag(COMMENT_INTERACTANT_TAG);
                    this.xml.openTag(COMMENT_INTERACTANT_TAG);
                    this.xml.attribute(COMMENT_INTERACT_INTACT_ATTR, interact.getSecondIntActID());
                    this.xml.openTag("id");
                    this.xml.print(interact.getID());
                    this.xml.closeTag("id");
                    if (interact.getLabel() != null) {
                        this.xml.openTag(COMMENT_INTERACT_LABEL_TAG);
                        this.xml.print(interact.getLabel());
                        this.xml.closeTag(COMMENT_INTERACT_LABEL_TAG);
                    }
                    this.xml.closeTag(COMMENT_INTERACTANT_TAG);
                    this.xml.openTag(COMMENT_ORGANISMS_TAG);
                    this.xml.print(interact.isOrganismsDiffer() ? "true" : "false");
                    this.xml.closeTag(COMMENT_ORGANISMS_TAG);
                    this.xml.openTag(COMMENT_EXPERIMENTS_TAG);
                    this.xml.print("" + interact.getNumberExperiments());
                    this.xml.closeTag(COMMENT_EXPERIMENTS_TAG);
                    if (!j.hasNext()) continue;
                    this.xml.closeTag(COMMENT_TAG);
                    this.xml.openTag(COMMENT_TAG);
                    this.xml.attribute("type", xtype);
                }
            } else if (type.equalsIgnoreCase("ALTERNATIVE PRODUCTS")) {
                for (UniProtCommentParser.Event event : ucp.getEvents()) {
                    this.xml.openTag(COMMENT_EVENT_TAG);
                    this.xml.attribute("type", event.getType().toLowerCase());
                    this.xml.closeTag(COMMENT_EVENT_TAG);
                }
                for (UniProtCommentParser.Isoform isoform : ucp.getIsoforms()) {
                    this.xml.openTag(COMMENT_ISOFORM_TAG);
                    Iterator k = isoform.getIsoIDs().iterator();
                    while (k.hasNext()) {
                        this.xml.openTag("id");
                        this.xml.print((String)k.next());
                        this.xml.closeTag("id");
                    }
                    k = isoform.getNames().iterator();
                    while (k.hasNext()) {
                        this.xml.openTag("name");
                        this.xml.print((String)k.next());
                        this.xml.closeTag("name");
                    }
                    this.xml.openTag("sequence");
                    this.xml.attribute("type", isoform.getSequenceType().toLowerCase());
                    if (isoform.getSequenceType().equalsIgnoreCase("Described")) {
                        this.xml.attribute(REF_ATTR, isoform.getSequenceRef());
                    }
                    this.xml.closeTag("sequence");
                    this.xml.openTag(NOTE_TAG);
                    this.xml.print(isoform.getNote());
                    this.xml.closeTag(NOTE_TAG);
                    this.xml.closeTag(COMMENT_ISOFORM_TAG);
                }
            } else if (type.equalsIgnoreCase("BIOPHYSICOCHEMICAL PROPERTIES")) {
                if (ucp.getAbsorptionNote() != null) {
                    this.xml.openTag(COMMENT_ABSORPTION_TAG);
                    this.xml.openTag(COMMENT_ABS_MAX_TAG);
                    this.xml.print(ucp.getAbsorptionMax());
                    this.xml.closeTag(COMMENT_ABS_MAX_TAG);
                    this.xml.openTag(TEXT_TAG);
                    this.xml.print(ucp.getAbsorptionNote());
                    this.xml.closeTag(TEXT_TAG);
                    this.xml.closeTag(COMMENT_ABSORPTION_TAG);
                }
                if (ucp.getKineticsNote() != null) {
                    this.xml.openTag(COMMENT_KINETICS_TAG);
                    j = ucp.getKMs().iterator();
                    while (j.hasNext()) {
                        this.xml.openTag(COMMENT_KIN_KM_TAG);
                        this.xml.print((String)j.next());
                        this.xml.closeTag(COMMENT_KIN_KM_TAG);
                    }
                    j = ucp.getVMaxes().iterator();
                    while (j.hasNext()) {
                        this.xml.openTag(COMMENT_KIN_VMAX_TAG);
                        this.xml.print((String)j.next());
                        this.xml.closeTag(COMMENT_KIN_VMAX_TAG);
                    }
                    this.xml.openTag(TEXT_TAG);
                    this.xml.print(ucp.getKineticsNote());
                    this.xml.closeTag(TEXT_TAG);
                    this.xml.closeTag(COMMENT_KINETICS_TAG);
                }
                if (ucp.getPHDependence() != null) {
                    this.xml.openTag(COMMENT_PH_TAG);
                    this.xml.print(ucp.getPHDependence());
                    this.xml.closeTag(COMMENT_PH_TAG);
                }
                if (ucp.getRedoxPotential() != null) {
                    this.xml.openTag(COMMENT_REDOX_TAG);
                    this.xml.print(ucp.getRedoxPotential());
                    this.xml.closeTag(COMMENT_REDOX_TAG);
                }
                if (ucp.getTemperatureDependence() != null) {
                    this.xml.openTag(COMMENT_TEMPERATURE_TAG);
                    this.xml.print(ucp.getTemperatureDependence());
                    this.xml.closeTag(COMMENT_TEMPERATURE_TAG);
                }
            } else {
                this.xml.openTag(TEXT_TAG);
                this.xml.print(ucp.getText());
                this.xml.closeTag(TEXT_TAG);
            }
            if (ucp.getNote() != null) {
                this.xml.openTag(NOTE_TAG);
                this.xml.print(ucp.getNote());
                this.xml.closeTag(NOTE_TAG);
            }
            this.xml.closeTag(COMMENT_TAG);
        }
        for (RankedCrossRef rcr : rs.getRankedCrossRefs()) {
            CrossRef cr = rcr.getCrossRef();
            this.xml.openTag(DBXREF_TAG);
            String dbname = cr.getDbname();
            this.xml.attribute("type", dbname);
            this.xml.attribute("id", cr.getAccession());
            this.xml.attribute(KEY_ATTR, "" + key++);
            if (!cr.getNoteSet().isEmpty()) {
                int acccount = 2;
                for (Note n : cr.getNoteSet()) {
                    if (!n.getTerm().equals(Terms.getAdditionalAccessionTerm()) || n.getValue().equals("-")) continue;
                    this.xml.openTag(PROPERTY_TAG);
                    String name = n.getTerm().getName();
                    if (acccount == 2) {
                        if (dbname.equalsIgnoreCase("HIV") || dbname.equalsIgnoreCase("INTERPRO") || dbname.equalsIgnoreCase("PANTHER") || dbname.equalsIgnoreCase("PFAM") || dbname.equalsIgnoreCase("PIR") || dbname.equalsIgnoreCase("PRINTS") || dbname.equalsIgnoreCase("PRODOM") || dbname.equalsIgnoreCase("REBASE") || dbname.equalsIgnoreCase("SMART") || dbname.equalsIgnoreCase("TIGRFAMS")) {
                            name = "entry name";
                        } else if (dbname.equalsIgnoreCase("PDB")) {
                            name = "structure determination method";
                        } else if (dbname.equalsIgnoreCase("DICTYBASE") || dbname.equalsIgnoreCase("ECOGENE") || dbname.equalsIgnoreCase("FLYBASE") || dbname.equalsIgnoreCase("HGNC") || dbname.equalsIgnoreCase("MGI") || dbname.equalsIgnoreCase("RGD") || dbname.equalsIgnoreCase("SGD") || dbname.equalsIgnoreCase("STYGENE") || dbname.equalsIgnoreCase("SUBTILIST") || dbname.equalsIgnoreCase("WORMBASE") || dbname.equalsIgnoreCase("ZFIN")) {
                            name = "gene designation";
                        } else if (dbname.equalsIgnoreCase("GO")) {
                            name = "term";
                        } else if (dbname.equalsIgnoreCase("HAMAP")) {
                            name = DOMAIN_TAG;
                        } else if (dbname.equalsIgnoreCase("ECO2DBASE")) {
                            name = "release number";
                        } else if (dbname.equalsIgnoreCase("SWISS-2DPAGE") || dbname.equalsIgnoreCase("HSC-2DPAGE")) {
                            name = "organism name";
                        } else if (dbname.equalsIgnoreCase("ENSEMBL")) {
                            name = "organism name";
                        } else if (dbname.equalsIgnoreCase("PIRSF")) {
                            name = "protein family name";
                        } else if (dbname.equalsIgnoreCase("AARHUS") || dbname.equalsIgnoreCase("GHENT-2DPAGE")) {
                            name = "secondary identifier";
                        } else if (dbname.equalsIgnoreCase("WORMPEP")) {
                            name = "C.elegans number";
                        } else if (!(dbname.equalsIgnoreCase("AGD") || dbname.equalsIgnoreCase("ANU-2DPAGE") || dbname.equalsIgnoreCase("COMPLUYEAST-2DPAGE") || dbname.equalsIgnoreCase("ECHOBASE") || dbname.equalsIgnoreCase("GENEDB_SPOMBE") || dbname.equalsIgnoreCase("GERMONLINE") || dbname.equalsIgnoreCase("GLYCOSUITEDB") || dbname.equalsIgnoreCase("GRAMENE") || dbname.equalsIgnoreCase("H-INVDB") || dbname.equalsIgnoreCase("INTACT") || dbname.equalsIgnoreCase("LEGIOLIST") || dbname.equalsIgnoreCase("LEPROMA") || dbname.equalsIgnoreCase("LISTILIST") || dbname.equalsIgnoreCase("MAIZEDB") || dbname.equalsIgnoreCase("MEROPS") || dbname.equalsIgnoreCase("MIM") || dbname.equalsIgnoreCase("MYPULIST") || dbname.equalsIgnoreCase("OGP") || dbname.equalsIgnoreCase("PHCI-2DPAGE") || dbname.equalsIgnoreCase("PHOSSITE") || dbname.equalsIgnoreCase("PHOTOLIST") || dbname.equalsIgnoreCase("PMMA-2DPAGE") || dbname.equalsIgnoreCase("RAT-HEART-2DPAGE") || dbname.equalsIgnoreCase("REACTOME") || dbname.equalsIgnoreCase("SAGALIST") || dbname.equalsIgnoreCase("SIENA-2DPAGE") || dbname.equalsIgnoreCase("TAIR") || dbname.equalsIgnoreCase("TIGR") || dbname.equalsIgnoreCase("TRANSFAC") || dbname.equalsIgnoreCase("TUBERCULIST"))) {
                            if (dbname.equalsIgnoreCase("HSSP")) {
                                name = "entry name";
                            } else if (dbname.equalsIgnoreCase("GENEFARM")) {
                                name = "gene family";
                            } else if (dbname.equalsIgnoreCase("SMR")) {
                                name = "range";
                            } else if (dbname.equalsIgnoreCase("EMBL") || dbname.equalsIgnoreCase("DDBJ") || dbname.equalsIgnoreCase("GENBANK")) {
                                name = "protein id";
                            } else if (dbname.equalsIgnoreCase("PROSITE")) {
                                name = "entry name";
                            }
                        }
                    } else if (acccount == 3) {
                        if (dbname.equalsIgnoreCase("HAMAP") || dbname.equalsIgnoreCase("PANTHER") || dbname.equalsIgnoreCase("PFAM") || dbname.equalsIgnoreCase("PIRSF") || dbname.equalsIgnoreCase("PRODOM") || dbname.equalsIgnoreCase("SMART") || dbname.equalsIgnoreCase("TIGRFAMS")) {
                            name = "number of hits";
                        } else if (dbname.equalsIgnoreCase("GO")) {
                            name = "evidence";
                        } else if (dbname.equalsIgnoreCase("PDB")) {
                            name = "chains";
                        } else if (dbname.equalsIgnoreCase("EMBL") || dbname.equalsIgnoreCase("DDBJ") || dbname.equalsIgnoreCase("GENBANK")) {
                            name = "status identifier";
                        } else if (dbname.equalsIgnoreCase("PROSITE")) {
                            name = "status";
                        }
                    } else if (dbname.equalsIgnoreCase("EMBL") || dbname.equalsIgnoreCase("DDBJ") || dbname.equalsIgnoreCase("GENBANK")) {
                        name = "molecule type";
                    }
                    this.xml.attribute("type", name);
                    this.xml.attribute("value", n.getValue());
                    this.xml.closeTag(PROPERTY_TAG);
                    ++acccount;
                }
            }
            this.xml.closeTag(DBXREF_TAG);
        }
        this.xml.openTag(PROTEIN_EXISTS_TAG);
        this.xml.attribute("type", proteinExists);
        this.xml.closeTag(PROTEIN_EXISTS_TAG);
        for (ComparableTerm t : kws) {
            this.xml.openTag(KEYWORD_TAG);
            this.xml.attribute("id", t.getIdentifier());
            this.xml.print(t.getName());
            this.xml.closeTag(KEYWORD_TAG);
        }
        for (RichFeature f : rs.getFeatureSet()) {
            RichLocation rl;
            String descr = null;
            String ftid = null;
            String ref = null;
            String status = null;
            String original = null;
            String locseq = null;
            ArrayList<String> variation = new ArrayList<String>();
            for (Note n : f.getNoteSet()) {
                if (n.getTerm().equals(Terms.getFTIdTerm())) {
                    ftid = n.getValue();
                    continue;
                }
                if (n.getTerm().equals(Terms.getFeatureDescTerm())) {
                    descr = n.getValue();
                    continue;
                }
                if (n.getTerm().equals(Terms.getFeatureStatusTerm())) {
                    status = n.getValue();
                    continue;
                }
                if (n.getTerm().equals(Terms.getFeatureRefTerm())) {
                    ref = n.getValue();
                    continue;
                }
                if (n.getTerm().equals(Terms.getFeatureOriginalTerm())) {
                    original = n.getValue();
                    continue;
                }
                if (n.getTerm().equals(Terms.getFeatureVariationTerm())) {
                    variation.add(n.getValue());
                    continue;
                }
                if (!n.getTerm().equals(Terms.getLocationSequenceTerm())) continue;
                locseq = n.getValue();
            }
            this.xml.openTag(FEATURE_TAG);
            this.xml.attribute("type", f.getTypeTerm().getName());
            if (ftid != null) {
                this.xml.attribute("id", ftid);
            }
            if (descr != null) {
                this.xml.attribute(FEATURE_DESC_ATTR, descr);
            }
            if (ref != null) {
                this.xml.attribute(REF_ATTR, ref);
            }
            if (status != null) {
                this.xml.attribute("value", status);
            }
            if (original != null) {
                this.xml.openTag(FEATURE_ORIGINAL_TAG);
                this.xml.print(original.trim());
                this.xml.closeTag(FEATURE_ORIGINAL_TAG);
            }
            Iterator j7 = variation.iterator();
            while (j7.hasNext()) {
                this.xml.openTag(FEATURE_VARIATION_TAG);
                this.xml.print(((String)j7.next()).trim());
                this.xml.closeTag(FEATURE_VARIATION_TAG);
            }
            this.xml.openTag(LOCATION_TAG);
            if (locseq != null) {
                this.xml.attribute("sequence", locseq.trim());
            }
            if ((rl = (RichLocation)f.getLocation()).getMinPosition().equals(rl.getMaxPosition())) {
                this.xml.openTag("position");
                if (rl.getMinPosition().getFuzzyStart() || rl.getMaxPosition().getFuzzyStart()) {
                    this.xml.attribute("value", "less than");
                } else if (rl.getMinPosition().getFuzzyEnd() || rl.getMaxPosition().getFuzzyEnd()) {
                    this.xml.attribute("value", "greater than");
                }
                this.xml.attribute("position", "" + rl.getMin());
                this.xml.closeTag("position");
            } else {
                this.xml.openTag(LOCATION_BEGIN_TAG);
                Position begin = rl.getMinPosition();
                if (begin.getFuzzyStart()) {
                    this.xml.attribute("value", "less than");
                } else if (begin.getFuzzyEnd()) {
                    this.xml.attribute("value", "greater than");
                }
                this.xml.attribute("position", "" + begin.getStart());
                this.xml.closeTag(LOCATION_BEGIN_TAG);
                this.xml.openTag(LOCATION_END_TAG);
                Position end = rl.getMaxPosition();
                if (end.getFuzzyStart()) {
                    this.xml.attribute("value", "less than");
                } else if (end.getFuzzyEnd()) {
                    this.xml.attribute("value", "greater than");
                }
                this.xml.attribute("position", "" + end.getEnd());
                this.xml.closeTag(LOCATION_END_TAG);
            }
            this.xml.closeTag(LOCATION_TAG);
            this.xml.closeTag(FEATURE_TAG);
        }
        for (Integer evidenceID : evidenceIDs) {
            String cat = (String)evcats.get(evidenceID);
            String type = (String)evtypes.get(evidenceID);
            String date = (String)evdates.get(evidenceID);
            String attr = (String)evattrs.get(evidenceID);
            this.xml.openTag("evidence");
            this.xml.attribute(KEY_ATTR, "" + key++);
            this.xml.attribute(EVIDENCE_CATEGORY_ATTR, cat);
            this.xml.attribute(EVIDENCE_DATE_ATTR, date);
            this.xml.attribute("type", type);
            if (attr != null) {
                this.xml.attribute(EVIDENCE_ATTRIBUTE_ATTR, attr);
            }
            this.xml.closeTag("evidence");
        }
        int mw = 0;
        try {
            mw = (int)MassCalc.getMolecularWeight(rs);
        }
        catch (IllegalSymbolException e) {
            throw new RuntimeException("Found illegal symbol", e);
        }
        CRC64Checksum crc = new CRC64Checksum();
        String seqstr = rs.seqString();
        crc.update(seqstr.getBytes(), 0, seqstr.length());
        this.xml.openTag("sequence");
        this.xml.attribute("version", "" + rs.getVersion());
        this.xml.attribute(SEQUENCE_LENGTH_ATTR, "" + rs.length());
        this.xml.attribute("mass", "" + mw);
        this.xml.attribute(SEQUENCE_CHECKSUM_ATTR, "" + crc);
        this.xml.attribute("modified", udat == null ? cdat : udat);
        String[] lines = StringTools.wordWrap(rs.seqString(), "\\s+", this.getLineWidth());
        for (int i = 0; i < lines.length; ++i) {
            this.xml.println(lines[i]);
        }
        this.xml.closeTag("sequence");
        this.xml.closeTag(ENTRY_TAG);
        if (copyright != null) {
            this.xml.openTag(COPYRIGHT_TAG);
            this.xml.println(copyright);
            this.xml.closeTag(COPYRIGHT_TAG);
        }
        this.pw.flush();
    }

    @Override
    public String getDefaultFormat() {
        return UNIPROTXML_FORMAT;
    }

    static {
        RichSequence.IOTools.registerFormat(UniProtXMLFormat.class);
        rppat = Pattern.compile("SEQUENCE OF (\\d+)-(\\d+)");
        xmlSchema = Pattern.compile(".*http://www\\.uniprot\\.org/support/docs/uniprot\\.xsd.*");
    }

    private class UniProtXMLHandler
    extends DefaultHandler {
        private RichSequenceFormat parent;
        private SymbolTokenization symParser;
        private RichSeqIOListener rlistener;
        private Namespace ns;
        private StringBuffer m_currentString;
        private NCBITaxon tax;
        private RichFeature.Template templ;
        private StringBuffer proteinDesc;
        private boolean firstNameInProteinGroup;
        private boolean firstDomainInProteinGroup;
        private boolean firstComponentInProteinGroup;
        private int currGene;
        private String geneNameClass;
        private String organismNameClass;
        private Map currNames = new TreeMap();
        private StringBuffer organelleDesc;
        private List currDBXrefs = new ArrayList();
        private List currComments = new ArrayList();
        private String currRefLocation;
        private List currRefAuthors;
        private String currRefTitle;
        private int currRefStart;
        private int currRefEnd;
        private int currRefRank;
        private String currPersonIs;
        private int currRCID;
        private int currEvID;
        private String currKWID;
        private UniProtCommentParser currUCParser;
        private UniProtCommentParser.Interaction currUCParserInteract;
        private UniProtCommentParser.Event currUCParserEvent;
        private UniProtCommentParser.Isoform currUCParserIsoform;
        private String currLocIsFor;
        private String currTextIsFor;
        private String currNoteIsFor;
        private String currSeqIsFor;
        private String currIDIsFor;
        private String currNameIsFor;
        private int interactantCount;
        private StringBuffer currLocStr;
        private int featNoteRank;

        private UniProtXMLHandler(RichSequenceFormat parent, SymbolTokenization symParser, RichSeqIOListener rlistener, Namespace ns) {
            this.parent = parent;
            this.symParser = symParser;
            this.rlistener = rlistener;
            this.ns = ns;
            this.m_currentString = new StringBuffer();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            block101: {
                String val = this.m_currentString.toString().trim();
                try {
                    if (qName.equals(UniProtXMLFormat.COPYRIGHT_TAG)) {
                        this.rlistener.addSequenceProperty(Terms.getCopyrightTerm(), val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.ACCESSION_TAG)) {
                        this.rlistener.setAccession(val);
                        break block101;
                    }
                    if (qName.equals("name")) {
                        if (this.currNameIsFor.equals("ENTRY")) {
                            this.rlistener.setName(val);
                        } else if (this.currNameIsFor.equals("PROTEIN")) {
                            if (this.firstNameInProteinGroup) {
                                this.proteinDesc.append(" ");
                                this.proteinDesc.append(val);
                            } else {
                                this.proteinDesc.append(" (");
                                this.proteinDesc.append(val);
                                this.proteinDesc.append(")");
                            }
                            this.firstNameInProteinGroup = false;
                        } else if (this.currNameIsFor.equals("GENE")) {
                            if (this.geneNameClass.equals("primary")) {
                                this.rlistener.addSequenceProperty(Terms.getGeneNameTerm(), this.currGene + ":" + val);
                            } else if (this.geneNameClass.equals("synonym")) {
                                this.rlistener.addSequenceProperty(Terms.getGeneSynonymTerm(), this.currGene + ":" + val);
                            } else if (this.geneNameClass.equals("ordered locus")) {
                                this.rlistener.addSequenceProperty(Terms.getOrderedLocusNameTerm(), this.currGene + ":" + val);
                            } else if (this.geneNameClass.equals("ORF")) {
                                this.rlistener.addSequenceProperty(Terms.getORFNameTerm(), this.currGene + ":" + val);
                            }
                        } else if (this.currNameIsFor.equals("ORGANISM")) {
                            String ournameclass = "common name";
                            if (this.organismNameClass.equals("abbreviation")) {
                                ournameclass = "acronym";
                            } else if (this.organismNameClass.equals("full")) {
                                ournameclass = "equivalent name";
                            } else if (this.organismNameClass.equals("scientific")) {
                                ournameclass = "scientific name";
                            } else if (this.organismNameClass.equals("synonym")) {
                                ournameclass = "synonym";
                            }
                            if (!this.currNames.containsKey(ournameclass)) {
                                this.currNames.put(ournameclass, new TreeSet());
                            }
                            ((Set)this.currNames.get(ournameclass)).add(val);
                        } else if (this.currNameIsFor.equals("ORGANELLE")) {
                            this.organelleDesc.append(", Plasmid ");
                            this.organelleDesc.append(val);
                        } else if (this.currNameIsFor.equals("ISOFORM")) {
                            this.currUCParserIsoform.getNames().add(val);
                        }
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.PROTEIN_TAG)) {
                        if (!this.firstDomainInProteinGroup || !this.firstComponentInProteinGroup) {
                            this.proteinDesc.append("]");
                        }
                        this.proteinDesc.append(".");
                        this.rlistener.setDescription(this.proteinDesc.toString());
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.ORGANISM_TAG)) {
                        this.currNameIsFor = "";
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.GENELOCATION_TAG)) {
                        String total = this.organelleDesc.toString().substring(3);
                        int lastComma = total.lastIndexOf(44);
                        if (lastComma > -1) {
                            this.organelleDesc.insert(lastComma + 1, " and");
                            total = this.organelleDesc.toString();
                        }
                        this.rlistener.addSequenceProperty(Terms.getOrganelleTerm(), total);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.RC_SPECIES_TAG)) {
                        this.rlistener.addSequenceProperty(Terms.getSpeciesTerm(), this.currRCID + ":" + val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.RC_TISSUE_TAG)) {
                        this.rlistener.addSequenceProperty(Terms.getTissueTerm(), this.currRCID + ":" + val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.RC_TRANSP_TAG)) {
                        this.rlistener.addSequenceProperty(Terms.getTransposonTerm(), this.currRCID + ":" + val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.RC_PLASMID_TAG)) {
                        this.rlistener.addSequenceProperty(Terms.getPlasmidTerm(), this.currRCID + ":" + val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.TITLE_TAG)) {
                        this.currRefTitle = val;
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.LOCATOR_TAG)) {
                        this.currRefLocation = val;
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.RP_LINE_TAG)) {
                        this.currComments.add(val);
                        Matcher m = rppat.matcher(val);
                        if (m.matches()) {
                            this.currRefStart = Integer.parseInt(m.group(1));
                            this.currRefEnd = Integer.parseInt(m.group(2));
                        }
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.REFERENCE_TAG) && !this.parent.getElideReferences()) {
                        CrossRef useForDocRef = null;
                        for (CrossRef dbx : this.currDBXrefs) {
                            SimpleRankedCrossRef rdbx = new SimpleRankedCrossRef(dbx, 0);
                            this.rlistener.setRankedCrossRef(rdbx);
                            if (useForDocRef == null) {
                                useForDocRef = dbx;
                                continue;
                            }
                            if (!dbx.getDbname().equalsIgnoreCase("MEDLINE") && (!dbx.getDbname().equalsIgnoreCase("PUBMED") || useForDocRef.getDbname().equalsIgnoreCase("MEDLINE"))) continue;
                            useForDocRef = dbx;
                        }
                        String currRefRemark = null;
                        if (this.currComments.size() > 0) {
                            currRefRemark = (String)this.currComments.iterator().next();
                        }
                        try {
                            DocRef dr = (DocRef)RichObjectFactory.getObject(SimpleDocRef.class, new Object[]{this.currRefAuthors, this.currRefLocation, this.currRefTitle});
                            if (useForDocRef != null) {
                                dr.setCrossref(useForDocRef);
                            }
                            dr.setRemark(currRefRemark);
                            SimpleRankedDocRef rdr = new SimpleRankedDocRef(dr, this.currRefStart != -999 ? new Integer(this.currRefStart) : null, this.currRefEnd != -999 ? new Integer(this.currRefEnd) : null, this.currRefRank);
                            this.rlistener.setRankedDocRef(rdr);
                        }
                        catch (ChangeVetoException e) {
                            throw new ParseException(e);
                        }
                        this.currDBXrefs.clear();
                        this.currComments.clear();
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.KEYWORD_TAG)) {
                        ComparableTerm t = Terms.getUniprotKWOnto().getOrCreateTerm(val);
                        try {
                            t.setIdentifier(this.currKWID);
                        }
                        catch (ChangeVetoException e) {
                            throw new ParseException(e);
                        }
                        this.rlistener.addSequenceProperty(Terms.getKeywordTerm(), val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.LOCATION_TAG)) {
                        if (this.currLocIsFor.equals("FEATURE")) {
                            this.templ.location = UniProtLocationParser.parseLocation(this.currLocStr.toString());
                        } else if (this.currLocIsFor.equals("COMMENT")) {
                            RichLocation l = UniProtLocationParser.parseLocation(this.currLocStr.toString());
                            this.currUCParser.setMolWeightRangeStart(l.getMin());
                            this.currUCParser.setMolWeightRangeEnd(l.getMax());
                        }
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.FEATURE_TAG)) {
                        this.rlistener.startFeature(this.templ);
                        this.rlistener.endFeature();
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.FEATURE_ORIGINAL_TAG)) {
                        try {
                            SimpleNote note = new SimpleNote(Terms.getFeatureOriginalTerm(), val, this.featNoteRank++);
                            ((RichAnnotation)this.templ.annotation).addNote(note);
                            break block101;
                        }
                        catch (ChangeVetoException e) {
                            SAXException pe = new SAXException("Could not create location terms");
                            pe.initCause(e);
                            throw pe;
                        }
                    }
                    if (qName.equals(UniProtXMLFormat.FEATURE_VARIATION_TAG)) {
                        try {
                            SimpleNote note = new SimpleNote(Terms.getFeatureVariationTerm(), val, this.featNoteRank++);
                            ((RichAnnotation)this.templ.annotation).addNote(note);
                            break block101;
                        }
                        catch (ChangeVetoException e) {
                            SAXException pe = new SAXException("Could not create location terms");
                            pe.initCause(e);
                            throw pe;
                        }
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_TAG)) {
                        this.rlistener.setComment(this.currUCParser.generate());
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.TEXT_TAG)) {
                        if (this.currTextIsFor.equals("COMMENT")) {
                            this.currUCParser.setText(val);
                        } else if (this.currTextIsFor.equals("ABSORPTION")) {
                            this.currUCParser.setAbsorptionNote(val);
                        } else if (this.currTextIsFor.equals("KINETICS")) {
                            this.currUCParser.setKineticsNote(val);
                        }
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_ABS_MAX_TAG)) {
                        this.currUCParser.setAbsorptionMax(val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_KIN_KM_TAG)) {
                        this.currUCParser.getKMs().add(val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_KIN_VMAX_TAG)) {
                        this.currUCParser.getVMaxes().add(val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_PH_TAG)) {
                        this.currUCParser.setPHDependence(val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_REDOX_TAG)) {
                        this.currUCParser.setRedoxPotential(val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_TEMPERATURE_TAG)) {
                        this.currUCParser.setTemperatureDependence(val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_ORGANISMS_TAG)) {
                        if (val.equalsIgnoreCase("true")) {
                            this.currUCParserInteract.setOrganismsDiffer(true);
                        } else {
                            this.currUCParserInteract.setOrganismsDiffer(false);
                        }
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_EXPERIMENTS_TAG)) {
                        this.currUCParserInteract.setNumberExperiments(Integer.parseInt(val));
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.NOTE_TAG)) {
                        if (this.currNoteIsFor.equals("COMMENT")) {
                            this.currUCParser.setNote(val);
                        } else if (this.currNoteIsFor.equals("ISOFORM")) {
                            this.currUCParser.setNote(val);
                        }
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_EVENT_TAG)) {
                        this.currUCParserEvent.setComment(val);
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_ISOFORM_TAG)) {
                        this.currSeqIsFor = "ENTRY";
                        this.currNoteIsFor = "COMMENT";
                        break block101;
                    }
                    if (qName.equals("id")) {
                        if (this.currIDIsFor.equals("ISOFORM")) {
                            this.currUCParserIsoform.getIsoIDs().add(val);
                        } else if (this.currIDIsFor.equals("INTERACTION")) {
                            this.currUCParserInteract.setID(val);
                        }
                        break block101;
                    }
                    if (qName.equals(UniProtXMLFormat.COMMENT_INTERACT_LABEL_TAG)) {
                        this.currUCParserInteract.setLabel(val);
                        break block101;
                    }
                    if (qName.equals("sequence")) {
                        if (!this.currSeqIsFor.equals("ENTRY") || this.parent.getElideSymbols()) break block101;
                        try {
                            SimpleSymbolList sl = new SimpleSymbolList(this.symParser, val.replaceAll("\\s+", "").replaceAll("[\\.|~]", "-"));
                            this.rlistener.addSymbols(this.symParser.getAlphabet(), sl.toList().toArray(new Symbol[0]), 0, sl.length());
                            break block101;
                        }
                        catch (Exception e) {
                            throw new ParseException(e);
                        }
                    }
                    if (qName.equals(UniProtXMLFormat.ENTRY_TAG)) {
                        Iterator j = this.currComments.iterator();
                        while (j.hasNext()) {
                            this.rlistener.setComment((String)j.next());
                        }
                        for (CrossRef dbx : this.currDBXrefs) {
                            SimpleRankedCrossRef rdbx = new SimpleRankedCrossRef(dbx, 0);
                            this.rlistener.setRankedCrossRef(rdbx);
                        }
                        this.currComments.clear();
                        this.currDBXrefs.clear();
                    }
                }
                catch (ParseException e) {
                    throw new SAXException(e);
                }
            }
            this.m_currentString.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.m_currentString.append(ch, start, length);
        }
    }

    public static class Terms
    extends RichSequence.Terms {
        private static ComparableTerm UNIPROTXML_TERM = null;
        private static ComparableTerm PROTEINTYPE_TERM = null;
        private static ComparableTerm EVIDENCE_CATEGORY_TERM = null;
        private static ComparableTerm EVIDENCE_TYPE_TERM = null;
        private static ComparableTerm EVIDENCE_DATE_TERM = null;
        private static ComparableTerm EVIDENCE_ATTR_TERM = null;
        private static ComparableTerm FEATURE_STATUS_TERM = null;
        private static ComparableTerm FEATURE_REF_TERM = null;
        private static ComparableTerm FEATURE_ORIGINAL_TERM = null;
        private static ComparableTerm FEATURE_VARIATION_TERM = null;
        private static ComparableTerm LOCATION_SEQUENCE_TERM = null;
        private static ComparableTerm UNIPROT_PROTEIN_EXISTS_TERM = null;
        public static final String CONTAINS_PREFIX = "Contains:";
        public static final String INCLUDES_PREFIX = "Includes:";
        public static final String GENENAME_KEY = "primary";
        public static final String GENESYNONYM_KEY = "synonym";
        public static final String ORDLOCNAME_KEY = "ordered locus";
        public static final String ORFNAME_KEY = "ORF";
        public static final String NCBI_TAXON_KEY = "NCBI Taxonomy";
        public static final String COMMON_NAME_KEY = "common";
        public static final String FULL_NAME_KEY = "full";
        public static final String SCIENTIFIC_NAME_KEY = "scientific";
        public static final String SYNONYM_NAME_KEY = "synonym";
        public static final String ABBREV_NAME_KEY = "abbreviation";
        public static final String LOC_FUZZY_START_KEY = "less than";
        public static final String LOC_FUZZY_END_KEY = "greater than";
        private static ComparableOntology uniprotKWOnto = null;

        public static ComparableTerm getProteinExistsTerm() {
            if (UNIPROT_PROTEIN_EXISTS_TERM == null) {
                UNIPROT_PROTEIN_EXISTS_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("UniProt protein exists");
            }
            return UNIPROT_PROTEIN_EXISTS_TERM;
        }

        public static ComparableOntology getUniprotKWOnto() {
            if (uniprotKWOnto == null) {
                uniprotKWOnto = (ComparableOntology)RichObjectFactory.getObject(SimpleComparableOntology.class, new Object[]{"uniprot_kw"});
            }
            return uniprotKWOnto;
        }

        public static ComparableTerm getUniProtXMLTerm() {
            if (UNIPROTXML_TERM == null) {
                UNIPROTXML_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm(UniProtXMLFormat.UNIPROTXML_FORMAT);
            }
            return UNIPROTXML_TERM;
        }

        public static ComparableTerm getProteinTypeTerm() {
            if (PROTEINTYPE_TERM == null) {
                PROTEINTYPE_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("protein_type");
            }
            return PROTEINTYPE_TERM;
        }

        public static ComparableTerm getEvidenceCategoryTerm() {
            if (EVIDENCE_CATEGORY_TERM == null) {
                EVIDENCE_CATEGORY_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("evidence_category");
            }
            return EVIDENCE_CATEGORY_TERM;
        }

        public static ComparableTerm getEvidenceTypeTerm() {
            if (EVIDENCE_TYPE_TERM == null) {
                EVIDENCE_TYPE_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("evidence_type");
            }
            return EVIDENCE_TYPE_TERM;
        }

        public static ComparableTerm getEvidenceDateTerm() {
            if (EVIDENCE_DATE_TERM == null) {
                EVIDENCE_DATE_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("evidence_date");
            }
            return EVIDENCE_DATE_TERM;
        }

        public static ComparableTerm getEvidenceAttrTerm() {
            if (EVIDENCE_ATTR_TERM == null) {
                EVIDENCE_ATTR_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("evidence_attr");
            }
            return EVIDENCE_ATTR_TERM;
        }

        public static ComparableTerm getFeatureRefTerm() {
            if (FEATURE_REF_TERM == null) {
                FEATURE_REF_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("feature_ref");
            }
            return FEATURE_REF_TERM;
        }

        public static ComparableTerm getFeatureStatusTerm() {
            if (FEATURE_STATUS_TERM == null) {
                FEATURE_STATUS_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("feature_status");
            }
            return FEATURE_STATUS_TERM;
        }

        public static ComparableTerm getFeatureOriginalTerm() {
            if (FEATURE_ORIGINAL_TERM == null) {
                FEATURE_ORIGINAL_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("feature_original");
            }
            return FEATURE_ORIGINAL_TERM;
        }

        public static ComparableTerm getFeatureVariationTerm() {
            if (FEATURE_VARIATION_TERM == null) {
                FEATURE_VARIATION_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("feature_variation");
            }
            return FEATURE_VARIATION_TERM;
        }

        public static ComparableTerm getLocationSequenceTerm() {
            if (LOCATION_SEQUENCE_TERM == null) {
                LOCATION_SEQUENCE_TERM = RichObjectFactory.getDefaultOntology().getOrCreateTerm("locseq");
            }
            return LOCATION_SEQUENCE_TERM;
        }
    }
}

