/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.taxa;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojavax.bio.taxa.SimpleNCBITaxonName;

public class SimpleNCBITaxonNameTest
extends TestCase {
    SimpleNCBITaxonName tax;
    String nameClass = "abc";
    String name = "aaa";

    public SimpleNCBITaxonNameTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.tax = new SimpleNCBITaxonName(this.nameClass, this.name);
    }

    protected void tearDown() throws Exception {
        this.tax = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleNCBITaxonNameTest.class);
        return suite;
    }

    public void testSetNameClass() {
        System.out.println("testSetNameClass");
        String newNameClass = "newClass";
        this.tax.setNameClass(newNameClass);
        SimpleNCBITaxonNameTest.assertEquals((String)newNameClass, (String)this.tax.getNameClass());
    }

    public void testGetNameClass() {
        System.out.println("testGetNameClass");
        SimpleNCBITaxonNameTest.assertEquals((String)this.nameClass, (String)this.tax.getNameClass());
    }

    public void testSetName() {
        System.out.println("testSetName");
        String newName = "newName";
        this.tax.setName(newName);
        SimpleNCBITaxonNameTest.assertEquals((String)newName, (String)this.tax.getName());
    }

    public void testGetName() {
        System.out.println("testGetName");
        SimpleNCBITaxonNameTest.assertEquals((String)this.name, (String)this.tax.getName());
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleNCBITaxonNameTest.assertTrue((boolean)this.tax.equals(this.tax));
        SimpleNCBITaxonNameTest.assertFalse((boolean)this.tax.equals(new Object()));
        SimpleNCBITaxonName tax2 = new SimpleNCBITaxonName(this.nameClass, this.name);
        SimpleNCBITaxonNameTest.assertTrue((boolean)this.tax.equals(tax2));
        SimpleNCBITaxonNameTest.assertTrue((boolean)tax2.equals(this.tax));
        tax2 = new SimpleNCBITaxonName("foo", this.name);
        SimpleNCBITaxonNameTest.assertTrue((!this.tax.equals(tax2) ? 1 : 0) != 0);
        SimpleNCBITaxonNameTest.assertTrue((!tax2.equals(this.tax) ? 1 : 0) != 0);
        tax2 = new SimpleNCBITaxonName(this.nameClass, "foo");
        SimpleNCBITaxonNameTest.assertTrue((!this.tax.equals(tax2) ? 1 : 0) != 0);
        SimpleNCBITaxonNameTest.assertTrue((!tax2.equals(this.tax) ? 1 : 0) != 0);
        tax2 = new SimpleNCBITaxonName("foo", "foo");
        SimpleNCBITaxonNameTest.assertTrue((!this.tax.equals(tax2) ? 1 : 0) != 0);
        SimpleNCBITaxonNameTest.assertTrue((!tax2.equals(this.tax) ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleNCBITaxonNameTest.assertTrue((this.tax.compareTo(this.tax) == 0 ? 1 : 0) != 0);
        SimpleNCBITaxonName tax2 = new SimpleNCBITaxonName(this.nameClass, this.name);
        SimpleNCBITaxonNameTest.assertTrue((this.tax.compareTo(tax2) == 0 ? 1 : 0) != 0);
        SimpleNCBITaxonNameTest.assertTrue((tax2.compareTo(this.tax) == 0 ? 1 : 0) != 0);
        tax2 = new SimpleNCBITaxonName("foo", this.name);
        SimpleNCBITaxonNameTest.assertTrue((this.tax.compareTo(tax2) < 1 ? 1 : 0) != 0);
        SimpleNCBITaxonNameTest.assertTrue((tax2.compareTo(this.tax) > 1 ? 1 : 0) != 0);
        tax2 = new SimpleNCBITaxonName(this.nameClass, "foo");
        SimpleNCBITaxonNameTest.assertTrue((this.tax.compareTo(tax2) < 1 ? 1 : 0) != 0);
        SimpleNCBITaxonNameTest.assertTrue((tax2.compareTo(this.tax) > 1 ? 1 : 0) != 0);
        tax2 = new SimpleNCBITaxonName("foo", "foo");
        SimpleNCBITaxonNameTest.assertTrue((this.tax.compareTo(tax2) < 1 ? 1 : 0) != 0);
        SimpleNCBITaxonNameTest.assertTrue((tax2.compareTo(this.tax) > 1 ? 1 : 0) != 0);
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        SimpleNCBITaxonName tax2 = new SimpleNCBITaxonName(this.nameClass, this.name);
        SimpleNCBITaxonNameTest.assertEquals((int)this.tax.hashCode(), (int)tax2.hashCode());
    }

    public void testToString() {
        System.out.println("testToString");
        String expected = this.nameClass + ":" + this.name;
        SimpleNCBITaxonNameTest.assertEquals((String)expected, (String)this.tax.toString());
    }
}

