/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.taxa.io;

import java.io.BufferedReader;
import java.io.IOException;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.taxa.NCBITaxon;
import org.biojavax.bio.taxa.SimpleNCBITaxon;
import org.biojavax.bio.taxa.io.NCBITaxonomyLoader;

public class SimpleNCBITaxonomyLoader
implements NCBITaxonomyLoader {
    @Override
    public NCBITaxon readNode(BufferedReader nodes) throws IOException, ParseException {
        if (nodes == null) {
            throw new IllegalArgumentException("Nodes file cannot be null");
        }
        String line = nodes.readLine();
        if (line != null) {
            String[] parts = line.split("\\|");
            Integer tax_id = Integer.valueOf(parts[0].trim());
            String pti = parts[1].trim();
            Integer parent_tax_id = pti.length() > 0 ? new Integer(pti) : null;
            String rank = parts[2].trim();
            Integer genetic_code = new Integer(parts[6].trim());
            Integer mito_code = new Integer(parts[8].trim());
            String isTaxonHidden = parts[10].trim();
            NCBITaxon t = this.findTaxon(new Object[]{tax_id});
            try {
                t.setParentNCBITaxID(parent_tax_id);
                t.setNodeRank(rank);
                t.setGeneticCode(genetic_code);
                t.setMitoGeneticCode(mito_code);
                t.setTaxonHidden(Integer.parseInt(isTaxonHidden) == 1);
            }
            catch (ChangeVetoException e) {
                throw new ParseException(e);
            }
            return t;
        }
        return null;
    }

    protected NCBITaxon findTaxon(Object[] theKeys) {
        return (SimpleNCBITaxon)RichObjectFactory.getObject(SimpleNCBITaxon.class, theKeys);
    }

    @Override
    public NCBITaxon readName(BufferedReader names) throws IOException, ParseException {
        if (names == null) {
            throw new IllegalArgumentException("Names file cannot be null");
        }
        String line = names.readLine();
        if (line != null) {
            String[] parts = line.split("\\|");
            Integer tax_id = Integer.valueOf(parts[0].trim());
            String name = parts[1].trim();
            String nameClass = parts[3].trim();
            NCBITaxon t = (NCBITaxon)RichObjectFactory.getObject(SimpleNCBITaxon.class, new Object[]{tax_id});
            try {
                t.addName(nameClass, name);
            }
            catch (ChangeVetoException e) {
                throw new ParseException(e);
            }
            return t;
        }
        return null;
    }
}

