/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.GeneticAlgorithm;
import org.biojavax.ga.Organism;
import org.biojavax.ga.Population;
import org.biojavax.ga.functions.CrossOverFunction;
import org.biojavax.ga.functions.FitnessFunction;
import org.biojavax.ga.functions.MutationFunction;
import org.biojavax.ga.functions.ProportionalSelection;
import org.biojavax.ga.impl.SimpleGeneticAlgorithm;
import org.biojavax.ga.impl.SimpleOrganism;
import org.biojavax.ga.impl.SimplePopulation;

public class ProportionalSelectionTest
extends TestCase {
    private ProportionalSelection ps;
    private Population pop;
    private GeneticAlgorithm ga;

    public ProportionalSelectionTest(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.pop = new SimplePopulation("test");
        for (int i = 0; i < 5; ++i) {
            this.pop.addOrganism(new SimpleOrganism("a" + i));
            this.pop.addOrganism(new SimpleOrganism("b" + i));
        }
        this.ps = new ProportionalSelection();
        this.ga = new SimpleGeneticAlgorithm(this.pop, MutationFunction.NO_MUTATION, CrossOverFunction.NO_CROSS, this.ps);
        this.ga.setFitnessFunction(new FitnessFunction(){

            @Override
            public double[] fitness(Organism org, Population pop, GeneticAlgorithm genAlg) {
                double[] dArray;
                if (org.getName().startsWith("a")) {
                    double[] dArray2 = new double[1];
                    dArray = dArray2;
                    dArray2[0] = 1.0;
                } else {
                    double[] dArray3 = new double[1];
                    dArray = dArray3;
                    dArray3[0] = 0.0;
                }
                return dArray;
            }
        });
    }

    protected void tearDown() throws Exception {
        this.ps = null;
        this.pop = null;
        this.ga = null;
        super.tearDown();
    }

    public void testSelect() {
        try {
            this.ps.select(this.pop, this.ga);
        }
        catch (ChangeVetoException ex) {
            ProportionalSelectionTest.fail((String)ex.getMessage());
        }
        int count = 0;
        Iterator i = this.pop.organisms();
        while (i.hasNext()) {
            Organism o = (Organism)i.next();
            if (!o.getName().startsWith("a")) continue;
            ++count;
        }
        ProportionalSelectionTest.assertTrue((count == 10 ? 1 : 0) != 0);
    }
}

