/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.SymbolList;
import org.biojavax.ga.functions.GACrossResult;
import org.biojavax.ga.functions.SimpleCrossOverFunction;

public class SimpleCrossOverFunctionTest
extends TestCase {
    private SimpleCrossOverFunction simpleCrossOverFunction = null;

    public SimpleCrossOverFunctionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.simpleCrossOverFunction = new SimpleCrossOverFunction();
        this.simpleCrossOverFunction.setMaxCrossOvers(1);
        this.simpleCrossOverFunction.setCrossOverProbs(new double[]{0.0, 0.0, 1.0, 0.0});
    }

    protected void tearDown() throws Exception {
        this.simpleCrossOverFunction = null;
        super.tearDown();
    }

    public void testPerformCrossOver() throws Exception {
        SymbolList chromB;
        SymbolList chromA = DNATools.createDNA("aaaaaaaa");
        GACrossResult cross = this.simpleCrossOverFunction.performCrossOver(chromA, chromB = DNATools.createDNA("gggggggg"));
        SimpleCrossOverFunctionTest.assertTrue((cross.getCrossOverPositions().length == 1 ? 1 : 0) != 0);
        SimpleCrossOverFunctionTest.assertEquals((Object)cross.getCrossOverPositions()[0], (Object)new PointLocation(3));
        SimpleCrossOverFunctionTest.assertEquals((Object)cross.getChromosomes()[0], (Object)DNATools.createDNA("aagggggg"));
        SimpleCrossOverFunctionTest.assertEquals((Object)chromA, (Object)DNATools.createDNA("aagggggg"));
        SimpleCrossOverFunctionTest.assertEquals((Object)cross.getChromosomes()[1], (Object)DNATools.createDNA("ggaaaaaa"));
        SimpleCrossOverFunctionTest.assertEquals((Object)chromB, (Object)DNATools.createDNA("ggaaaaaa"));
    }
}

