/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import java.util.HashSet;
import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojavax.ga.functions.SimpleMutationFunction;
import org.biojavax.ga.util.GATools;

public class SimpleMutationFunctionTest
extends TestCase {
    public SimpleMutationFunctionTest(String s) {
        super(s);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testMutate() {
        SimpleMutationFunction func = new SimpleMutationFunction();
        try {
            SymbolList seq = DNATools.createDNA("aaaaaaaaa");
            func.mutate(seq);
            func.setMutationProbs(new double[]{0.0, 0.0, 1.0, 0.0});
            func.setMutationSpectrum(GATools.standardMutationDistribution(DNATools.getDNA()));
            func.mutate(seq);
            HashSet<AtomicSymbol> syms = new HashSet<AtomicSymbol>();
            syms.add(DNATools.c());
            syms.add(DNATools.g());
            syms.add(DNATools.t());
            Symbol ambig = DNATools.getDNA().getAmbiguity(syms);
            SimpleMutationFunctionTest.assertTrue((seq.symbolAt(3) != DNATools.a() ? 1 : 0) != 0);
            SimpleMutationFunctionTest.assertTrue((boolean)ambig.getMatches().contains(seq.symbolAt(3)));
        }
        catch (Exception e) {
            SimpleMutationFunctionTest.fail((String)e.getMessage());
        }
    }
}

