/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.impl;

import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.GeneticAlgorithm;
import org.biojavax.ga.Organism;
import org.biojavax.ga.Population;
import org.biojavax.ga.functions.CrossOverFunction;
import org.biojavax.ga.functions.FitnessFunction;
import org.biojavax.ga.functions.MutationFunction;
import org.biojavax.ga.functions.SelectionFunction;
import org.biojavax.ga.impl.SimplePopulation;

public abstract class AbstractGeneticAlgorithm
extends AbstractChangeable
implements GeneticAlgorithm {
    protected Population population = new SimplePopulation();
    private CrossOverFunction crossF;
    private SelectionFunction selectF;
    private MutationFunction mutF;
    private FitnessFunction fit;

    protected AbstractGeneticAlgorithm() {
    }

    @Override
    public final CrossOverFunction getCrossOverFunction() {
        return this.crossF;
    }

    @Override
    public FitnessFunction getFitnessFunction() {
        return this.fit;
    }

    @Override
    public final MutationFunction getMutationFunction() {
        return this.mutF;
    }

    @Override
    public final Population getPopulation() {
        return this.population;
    }

    @Override
    public final SelectionFunction getSelectionFunction() {
        return this.selectF;
    }

    public void initPopulation() {
        if (this.population != null && this.fit != null) {
            for (Organism o : this.population.getOrganisms()) {
                o.setFitness(this.fit.fitness(o, this.population, this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCrossOverFunction(CrossOverFunction function) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.crossF = function;
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, GeneticAlgorithm.POPULATION, function, this.crossF);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.crossF = function;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setFitnessFunction(FitnessFunction func) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.fit = func;
            this.initPopulation();
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, GeneticAlgorithm.FITNESS_FUNCTION, func, this.fit);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.FITNESS_FUNCTION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.fit = func;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setMutationFunction(MutationFunction function) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.mutF = function;
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, GeneticAlgorithm.POPULATION, function, this.mutF);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.mutF = function;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPopulation(Population pop) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.population = pop;
            this.initPopulation();
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, GeneticAlgorithm.POPULATION, pop, this.population);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.population = pop;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setSelectionFunction(SelectionFunction function) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.selectF = function;
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, GeneticAlgorithm.POPULATION, function, this.selectF);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.selectF = function;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }
}

