/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.impl;

import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.Organism;
import org.biojavax.ga.exception.IllegalOrganismException;
import org.biojavax.ga.impl.SimpleOrganism;
import org.biojavax.ga.impl.SimplePopulation;

public class SimplePopulationTest
extends TestCase {
    private SimplePopulation pop;
    private Organism o;

    public SimplePopulationTest(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.pop = new SimplePopulation("pop");
        this.o = new SimpleOrganism();
        this.o.setName("org");
        SymbolList[] csomes = new SymbolList[]{DNATools.createDNA("aaaaagggggtttttccccc")};
        this.o.setChromosomes(csomes);
        this.pop.addOrganism(this.o);
    }

    protected void tearDown() throws Exception {
        this.pop = null;
        this.o = null;
        super.tearDown();
    }

    public void testGetOrganismByName() {
        String name1 = "org";
        Organism organismRet = this.pop.getOrganismByName(name1);
        SimplePopulationTest.assertEquals((Object)organismRet, (Object)this.o);
    }

    public void testGetOrganisms() {
        Set setRet = this.pop.getOrganisms();
        SimplePopulationTest.assertTrue((boolean)setRet.contains(this.o));
        SimplePopulationTest.assertTrue((setRet.size() == 1 ? 1 : 0) != 0);
        try {
            this.pop.addOrganism(this.o.replicate("org2"));
        }
        catch (Exception ex) {
            SimplePopulationTest.fail((String)ex.getMessage());
        }
        SimplePopulationTest.assertTrue((this.pop.getOrganisms().size() == 2 ? 1 : 0) != 0);
    }

    public void testOrganisms() {
        Iterator it = this.pop.organisms();
        SimplePopulationTest.assertTrue((boolean)it.hasNext());
        SimplePopulationTest.assertTrue((boolean)it.next().equals(this.o));
    }

    public void addOrganism() {
        try {
            this.pop.addOrganism(this.o.replicate("org2"));
            SimplePopulationTest.assertTrue((this.pop.size() == 2 ? 1 : 0) != 0);
        }
        catch (IllegalOrganismException ex) {
            SimplePopulationTest.fail((String)ex.getMessage());
        }
        catch (ChangeVetoException ex) {
            SimplePopulationTest.fail((String)ex.getMessage());
        }
    }

    public void addAndRemoveOrganisms() {
        Organism[] orgs = new SimpleOrganism[10];
        for (int i = 0; i < orgs.length; ++i) {
            orgs[i] = this.o.replicate(this.o.getName() + i);
        }
        try {
            this.pop.addOrganisms(orgs);
            SimplePopulationTest.assertTrue((this.pop.size() == 11 ? 1 : 0) != 0);
            this.pop.removeOrganisms(orgs);
            SimplePopulationTest.assertTrue((this.pop.size() == 1 ? 1 : 0) != 0);
            this.pop.removeOrganism(this.o);
            SimplePopulationTest.assertTrue((this.pop.size() == 0 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            SimplePopulationTest.fail((String)ex.getMessage());
        }
    }
}

