/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.util;

import junit.framework.TestCase;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojavax.ga.util.GATools;

public class GAToolsTest
extends TestCase {
    Symbol a = DNATools.a();
    Symbol c = DNATools.c();
    Symbol g = DNATools.g();
    Symbol t = DNATools.t();

    public GAToolsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testStandardMutationDistribution() throws Exception {
        OrderNDistribution d = GATools.standardMutationDistribution(DNATools.getDNA());
        GAToolsTest.assertTrue((d.getDistribution(this.a).getWeight(this.a) == 0.0 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.a).getWeight(this.c) == 0.3333333333333333 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.a).getWeight(this.g) == 0.3333333333333333 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.a).getWeight(this.t) == 0.3333333333333333 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.c).getWeight(this.c) == 0.0 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.c).getWeight(this.a) == 0.3333333333333333 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.c).getWeight(this.g) == 0.3333333333333333 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.c).getWeight(this.t) == 0.3333333333333333 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.g).getWeight(this.g) == 0.0 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.g).getWeight(this.a) == 0.3333333333333333 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.g).getWeight(this.c) == 0.3333333333333333 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.g).getWeight(this.t) == 0.3333333333333333 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.t).getWeight(this.t) == 0.0 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.t).getWeight(this.a) == 0.3333333333333333 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.t).getWeight(this.g) == 0.3333333333333333 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.t).getWeight(this.c) == 0.3333333333333333 ? 1 : 0) != 0);
    }

    public void testUniformMutationDistribution() throws Exception {
        OrderNDistribution d = GATools.uniformMutationDistribution(DNATools.getDNA());
        GAToolsTest.assertTrue((d.getDistribution(this.a).getWeight(this.a) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.a).getWeight(this.c) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.a).getWeight(this.g) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.a).getWeight(this.t) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.c).getWeight(this.a) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.c).getWeight(this.c) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.c).getWeight(this.g) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.c).getWeight(this.t) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.g).getWeight(this.a) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.g).getWeight(this.c) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.g).getWeight(this.g) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.g).getWeight(this.t) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.t).getWeight(this.a) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.t).getWeight(this.c) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.t).getWeight(this.g) == 0.25 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((d.getDistribution(this.t).getWeight(this.t) == 0.25 ? 1 : 0) != 0);
    }

    public void testBinaryAlphabet() {
        FiniteAlphabet bin = GATools.getBinaryAlphabet();
        GAToolsTest.assertEquals((String)bin.getName(), (String)"GA_Binary");
        FiniteAlphabet bin2 = (FiniteAlphabet)AlphabetManager.alphabetForName("GA_Binary");
        GAToolsTest.assertNotNull((Object)bin);
        GAToolsTest.assertNotNull((Object)bin2);
        GAToolsTest.assertTrue((bin == bin2 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((bin2 == bin ? 1 : 0) != 0);
        GAToolsTest.assertEquals((Object)bin, (Object)bin2);
        GAToolsTest.assertEquals((Object)bin2, (Object)bin);
        GAToolsTest.assertTrue((bin.size() == 2 ? 1 : 0) != 0);
        GAToolsTest.assertTrue((boolean)bin.contains(GATools.one()));
        GAToolsTest.assertTrue((boolean)bin.contains(GATools.one()));
        AtomicSymbol one = GATools.one();
        AtomicSymbol x = GATools.one();
        GAToolsTest.assertTrue((one == x ? 1 : 0) != 0);
        GAToolsTest.assertTrue((x == one ? 1 : 0) != 0);
        GAToolsTest.assertEquals((Object)one, (Object)x);
        GAToolsTest.assertEquals((Object)x, (Object)one);
        AtomicSymbol zero = GATools.zero();
        x = GATools.zero();
        GAToolsTest.assertTrue((zero == x ? 1 : 0) != 0);
        GAToolsTest.assertTrue((x == zero ? 1 : 0) != 0);
        GAToolsTest.assertEquals((Object)zero, (Object)x);
        GAToolsTest.assertEquals((Object)x, (Object)zero);
    }

    public void testCreateBinary() {
        String bin = "00101000101010101010100101010010101010";
        try {
            SymbolList symL = GATools.createBinary(bin);
            GAToolsTest.assertNotNull((Object)symL);
            GAToolsTest.assertTrue((bin.length() == 38 ? 1 : 0) != 0);
            String out = symL.seqString();
            GAToolsTest.assertNotNull((Object)out);
            GAToolsTest.assertEquals((String)bin, (String)out);
        }
        catch (IllegalSymbolException ex) {
            GAToolsTest.fail((String)ex.getMessage());
        }
    }
}

