/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.biojavax.ga.util.WeightedSet;

public class WeightedSetTest
extends TestCase {
    private WeightedSet weightedSet = null;

    public WeightedSetTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.weightedSet = new WeightedSet();
    }

    protected void tearDown() throws Exception {
        this.weightedSet = null;
        super.tearDown();
    }

    public void testAdd() {
        Object o = new Object();
        boolean expectedReturn = true;
        boolean actualReturn = this.weightedSet.add(o);
        WeightedSetTest.assertEquals((String)"return value", (boolean)expectedReturn, (boolean)actualReturn);
        WeightedSetTest.assertTrue((this.weightedSet.getWeight(o) == 0.0 ? 1 : 0) != 0);
        WeightedSetTest.assertTrue((this.weightedSet.size() == 1 ? 1 : 0) != 0);
        actualReturn = this.weightedSet.add(o);
        expectedReturn = false;
        WeightedSetTest.assertEquals((String)"return value", (boolean)expectedReturn, (boolean)actualReturn);
        WeightedSetTest.assertTrue((this.weightedSet.size() == 1 ? 1 : 0) != 0);
    }

    public void testAddAll() {
        ArrayList<Object> c = new ArrayList<Object>();
        Object o = new Object();
        String s = "";
        c.add(o);
        c.add(s);
        boolean expectedReturn = true;
        boolean actualReturn = this.weightedSet.addAll(c);
        WeightedSetTest.assertEquals((String)"return value", (boolean)expectedReturn, (boolean)actualReturn);
        WeightedSetTest.assertTrue((this.weightedSet.size() == 2 ? 1 : 0) != 0);
        WeightedSetTest.assertTrue((this.weightedSet.getWeight(o) == 0.0 ? 1 : 0) != 0);
        WeightedSetTest.assertTrue((this.weightedSet.getWeight(s) == 0.0 ? 1 : 0) != 0);
    }

    public void testAsMap() {
        this.weightedSet.add("one");
        Map m = this.weightedSet.asMap();
        WeightedSetTest.assertTrue((boolean)m.containsKey("one"));
        Double expectedReturn = new Double(0.0);
        Double actualReturn = (Double)m.get("one");
        WeightedSetTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testClear() {
        this.weightedSet.setWeight("one", 0.5);
        this.weightedSet.setWeight("two", 0.5);
        this.weightedSet.clear();
        WeightedSetTest.assertTrue((this.weightedSet.getTotalWeight() == 0.0 ? 1 : 0) != 0);
        WeightedSetTest.assertTrue((!this.weightedSet.contains("one") ? 1 : 0) != 0);
        WeightedSetTest.assertTrue((!this.weightedSet.contains("two") ? 1 : 0) != 0);
    }

    public void testContains() {
        Object o = new Object();
        boolean expectedReturn = false;
        boolean actualReturn = this.weightedSet.contains(o);
        WeightedSetTest.assertEquals((String)"return value", (boolean)expectedReturn, (boolean)actualReturn);
        this.weightedSet.add(o);
        expectedReturn = true;
        actualReturn = this.weightedSet.contains(o);
        WeightedSetTest.assertEquals((String)"return value", (boolean)expectedReturn, (boolean)actualReturn);
    }

    public void testContainsAll() {
        ArrayList<Object> c = new ArrayList<Object>();
        Object o = new Object();
        String s = "";
        c.add(o);
        c.add(s);
        boolean expectedReturn = false;
        boolean actualReturn = this.weightedSet.containsAll(c);
        WeightedSetTest.assertEquals((String)"return value", (boolean)expectedReturn, (boolean)actualReturn);
        this.weightedSet.addAll(c);
        expectedReturn = true;
        actualReturn = this.weightedSet.containsAll(c);
        WeightedSetTest.assertEquals((String)"return value", (boolean)expectedReturn, (boolean)actualReturn);
    }

    public void testGetTotalWeight() {
        Double expectedReturn = new Double(1.5);
        this.weightedSet.setWeight("one", 0.5);
        this.weightedSet.setWeight("two", 0.5);
        this.weightedSet.setWeight("three", 0.5);
        Double actualReturn = new Double(this.weightedSet.getTotalWeight());
        WeightedSetTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testGetWeight() throws NoSuchElementException {
        this.weightedSet.setWeight("one", 0.5);
        this.weightedSet.setWeight("two", 0.5);
        this.weightedSet.setWeight("three", 0.5);
        this.weightedSet.setWeight("four", 0.5);
        Double expectedReturn = new Double(0.25);
        Double actualReturn = new Double(this.weightedSet.getWeight("one"));
        WeightedSetTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testIsEmpty() {
        this.weightedSet.setWeight("four", 0.5);
        boolean expectedReturn = false;
        boolean actualReturn = this.weightedSet.isEmpty();
        WeightedSetTest.assertEquals((String)"return value", (boolean)expectedReturn, (boolean)actualReturn);
    }

    public void testRemove() {
        this.weightedSet.setWeight("one", 0.5);
        this.weightedSet.setWeight("two", 0.5);
        this.weightedSet.setWeight("three", 0.5);
        this.weightedSet.setWeight("four", 0.5);
        this.weightedSet.setWeight("five", 0.5);
        this.weightedSet.remove("one");
        WeightedSetTest.assertTrue((this.weightedSet.getTotalWeight() == 2.0 ? 1 : 0) != 0);
        WeightedSetTest.assertTrue((this.weightedSet.getWeight("five") == 0.25 ? 1 : 0) != 0);
    }

    public void testRetainAll() {
        this.weightedSet.setWeight("one", 0.5);
        this.weightedSet.setWeight("two", 0.5);
        this.weightedSet.setWeight("three", 0.5);
        this.weightedSet.setWeight("four", 0.5);
        this.weightedSet.setWeight("five", 0.5);
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add("two");
        boolean expectedReturn = true;
        boolean actualReturn = this.weightedSet.retainAll(c);
        WeightedSetTest.assertEquals((String)"return value", (boolean)expectedReturn, (boolean)actualReturn);
        WeightedSetTest.assertTrue((boolean)this.weightedSet.contains("one"));
        WeightedSetTest.assertTrue((boolean)this.weightedSet.containsAll(c));
        WeightedSetTest.assertTrue((!this.weightedSet.contains("three") ? 1 : 0) != 0);
    }

    public void testSample() {
        this.weightedSet.setWeight("one", 0.5);
        String expectedReturn = "one";
        Object actualReturn = this.weightedSet.sample();
        WeightedSetTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
        this.weightedSet.setWeight("two", 4.5);
    }

    public void testSetWeight() {
        String o = "one";
        double w = 0.3;
        this.weightedSet.setWeight(o, w);
        WeightedSetTest.assertTrue((this.weightedSet.getTotalWeight() == 0.3 ? 1 : 0) != 0);
        WeightedSetTest.assertTrue((this.weightedSet.getWeight(o) == 1.0 ? 1 : 0) != 0);
    }

    public void testSetWeight2() {
        String o = "one";
        double w = 2.5;
        this.weightedSet.setWeight(o, w);
        WeightedSetTest.assertTrue((this.weightedSet.getTotalWeight() == 2.5 ? 1 : 0) != 0);
        WeightedSetTest.assertTrue((this.weightedSet.getWeight(o) == 1.0 ? 1 : 0) != 0);
    }

    public void testSetWeight3() {
        String o = "one";
        double w = 2.5;
        String p = "two";
        double x = 2.5;
        this.weightedSet.setWeight(o, w);
        WeightedSetTest.assertTrue((this.weightedSet.getTotalWeight() == 2.5 ? 1 : 0) != 0);
        WeightedSetTest.assertTrue((this.weightedSet.getWeight(o) == 1.0 ? 1 : 0) != 0);
        this.weightedSet.setWeight(p, x);
        WeightedSetTest.assertTrue((this.weightedSet.getTotalWeight() == 5.0 ? 1 : 0) != 0);
        WeightedSetTest.assertTrue((this.weightedSet.getWeight(o) == 0.5 ? 1 : 0) != 0);
        WeightedSetTest.assertTrue((this.weightedSet.getWeight(p) == 0.5 ? 1 : 0) != 0);
    }

    public void testSize() {
        int expectedReturn = 0;
        int actualReturn = this.weightedSet.size();
        WeightedSetTest.assertEquals((String)"return value", (int)expectedReturn, (int)actualReturn);
        this.weightedSet.setWeight("one", 0.5);
        this.weightedSet.setWeight("two", 0.5);
        this.weightedSet.setWeight("three", 0.5);
        this.weightedSet.setWeight("four", 0.5);
        this.weightedSet.setWeight("five", 0.5);
        expectedReturn = 5;
        actualReturn = this.weightedSet.size();
        WeightedSetTest.assertEquals((String)"return value", (int)expectedReturn, (int)actualReturn);
    }
}

