/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ontology;

import java.util.NoSuchElementException;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.Term;
import org.biojava.ontology.Triple;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.RichObjectFactory;
import org.biojavax.ontology.ComparableOntology;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.ontology.SimpleComparableOntology;
import org.biojavax.ontology.SimpleComparableTerm;
import org.biojavax.ontology.SimpleComparableTriple;

public class SimpleComparableOntologyTest
extends TestCase {
    SimpleComparableOntology ont;
    String name = "a_test";
    ComparableTerm term;
    Triple t3;
    ChangeListener.ChangeEventRecorder cr;

    public SimpleComparableOntologyTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.cr = new ChangeListener.ChangeEventRecorder();
        this.ont = new SimpleComparableOntology(this.name);
        this.term = this.ont.getOrCreateTerm("foo");
        this.t3 = this.ont.createTriple(this.term, this.term, this.term, "t3", "");
        this.ont.addChangeListener(this.cr);
    }

    protected void tearDown() throws Exception {
        this.ont.removeChangeListener(this.cr);
        this.term = null;
        this.ont = null;
        this.cr = null;
        RichObjectFactory.clearLRUCache(SimpleComparableTerm.class);
        RichObjectFactory.clearLRUCache(SimpleComparableTriple.class);
        RichObjectFactory.clearLRUCache(SimpleComparableOntology.class);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleComparableOntologyTest.class);
        return suite;
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleComparableOntologyTest.assertTrue((this.ont.compareTo(this.ont) == 0 ? 1 : 0) != 0);
        SimpleComparableOntology ont2 = new SimpleComparableOntology(this.name);
        SimpleComparableOntologyTest.assertTrue((this.ont.compareTo(ont2) == 0 ? 1 : 0) != 0);
        SimpleComparableOntologyTest.assertTrue((ont2.compareTo(this.ont) == 0 ? 1 : 0) != 0);
        ont2 = new SimpleComparableOntology("xyz");
        SimpleComparableOntologyTest.assertTrue((this.ont.compareTo(ont2) < 1 ? 1 : 0) != 0);
        SimpleComparableOntologyTest.assertTrue((ont2.compareTo(this.ont) > 1 ? 1 : 0) != 0);
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleComparableOntologyTest.assertFalse((boolean)this.ont.equals(null));
        SimpleComparableOntologyTest.assertFalse((boolean)this.ont.equals(new Object()));
        SimpleComparableOntologyTest.assertTrue((boolean)this.ont.equals(this.ont));
        SimpleComparableOntology ont2 = new SimpleComparableOntology(this.name);
        SimpleComparableOntologyTest.assertTrue((boolean)this.ont.equals(ont2));
        SimpleComparableOntologyTest.assertTrue((boolean)ont2.equals(this.ont));
        ont2 = new SimpleComparableOntology("xyz");
        SimpleComparableOntologyTest.assertTrue((!this.ont.equals(ont2) ? 1 : 0) != 0);
        SimpleComparableOntologyTest.assertTrue((!ont2.equals(this.ont) ? 1 : 0) != 0);
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        SimpleComparableOntology ont2 = new SimpleComparableOntology(this.name);
        SimpleComparableOntologyTest.assertTrue((this.ont.hashCode() == ont2.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() {
        System.out.println("testToString");
        SimpleComparableOntologyTest.assertEquals((String)this.name, (String)this.ont.toString());
    }

    public void testContainsTerm() {
        System.out.println("testContainsTerm");
        SimpleComparableOntologyTest.assertTrue((boolean)this.ont.containsTerm(this.term.getName()));
        SimpleComparableOntologyTest.assertFalse((boolean)this.ont.containsTerm("bar"));
    }

    public void testGetTerm() {
        System.out.println("testGetTerm");
        SimpleComparableOntologyTest.assertEquals((Object)this.term, (Object)this.ont.getTerm(this.term.getName()));
        try {
            this.ont.getTerm("foobar");
            SimpleComparableOntologyTest.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testGetOrCreateTerm() {
        System.out.println("testGetOrCreateTerm");
        int size = this.ont.getTerms().size();
        SimpleComparableOntologyTest.assertEquals((Object)this.term, (Object)this.ont.getOrCreateTerm(this.term.getName()));
        SimpleComparableOntologyTest.assertEquals((int)size, (int)this.ont.getTerms().size());
        ComparableTerm foo = this.ont.getOrCreateTerm("foobar");
        SimpleComparableOntologyTest.assertNotNull((Object)foo);
        SimpleComparableOntologyTest.assertEquals((int)(size + 1), (int)this.ont.getTerms().size());
    }

    public void testGetOrImportTerm() {
        System.out.println("testGetOrImportTerm");
        int size = this.ont.getTerms().size();
        ComparableTerm t = this.ont.getOrImportTerm(this.term);
        SimpleComparableOntologyTest.assertEquals((Object)this.term, (Object)t);
        SimpleComparableOntologyTest.assertEquals((int)size, (int)this.ont.getTerms().size());
        ComparableTerm t2 = new SimpleComparableTerm(new SimpleComparableOntology("test2"), "hkhjj", null);
        t2 = this.ont.getOrImportTerm(t2);
        SimpleComparableOntologyTest.assertTrue((boolean)this.ont.containsTerm(t2.getName()));
        SimpleComparableOntologyTest.assertEquals((int)(size + 1), (int)this.ont.getTerms().size());
    }

    public void testCreateTerm() {
        System.out.println("testCreateTerm");
        try {
            Term term = this.ont.createTerm("bar", "");
            SimpleComparableOntologyTest.assertEquals((Object)term, (Object)this.ont.getTerm("bar"));
            SimpleComparableOntologyTest.assertNotNull((Object)this.cr.getEvent());
            ChangeEvent ce = this.cr.getEvent();
            SimpleComparableOntologyTest.assertEquals((Object)ComparableOntology.TERM, (Object)ce.getType());
            SimpleComparableOntologyTest.assertEquals((Object)term, (Object)ce.getChange());
            SimpleComparableOntologyTest.assertNull((Object)ce.getPrevious());
            try {
                this.ont.createTerm("bar", "");
                SimpleComparableOntologyTest.fail((String)"Expected AlreadyExistsException");
            }
            catch (AlreadyExistsException alreadyExistsException) {}
        }
        catch (Exception ex) {
            SimpleComparableOntologyTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testImportTerm() {
        System.out.println("testImportTerm");
        int size = this.ont.getTerms().size();
        try {
            this.ont.importTerm(this.term, this.term.getName());
        }
        catch (Exception ex) {
            SimpleComparableOntologyTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleComparableOntologyTest.assertEquals((int)size, (int)this.ont.getTerms().size());
        SimpleComparableTerm t2 = new SimpleComparableTerm(new SimpleComparableOntology("test2"), "hkhjj", null);
        try {
            this.ont.importTerm(t2, t2.getName());
        }
        catch (Exception ex) {
            SimpleComparableOntologyTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        SimpleComparableOntologyTest.assertTrue((boolean)this.ont.containsTerm(t2.getName()));
        SimpleComparableOntologyTest.assertEquals((int)(size + 1), (int)this.ont.getTerms().size());
    }

    public void testCreateTriple() {
        System.out.println("testCreateTriple");
        int size = this.ont.getTriples(null, null, null).size();
        ComparableTerm obj = this.ont.getOrCreateTerm("foo");
        ComparableTerm subj = this.ont.getOrCreateTerm("bar");
        ComparableTerm pred = this.ont.getOrCreateTerm("is_a");
        try {
            Triple trip = this.ont.createTriple(subj, obj, pred, "Triple", "");
            SimpleComparableOntologyTest.assertTrue((boolean)this.ont.containsTriple(subj, obj, pred));
            SimpleComparableOntologyTest.assertEquals((int)(size + 1), (int)this.ont.getTriples(null, null, null).size());
            SimpleComparableOntologyTest.assertNotNull((Object)this.cr.getEvent());
            ChangeEvent ce = this.cr.getEvent();
            SimpleComparableOntologyTest.assertEquals((Object)ComparableOntology.TRIPLE, (Object)ce.getType());
            SimpleComparableOntologyTest.assertEquals((Object)trip, (Object)ce.getChange());
            SimpleComparableOntologyTest.assertNull((Object)ce.getPrevious());
            try {
                trip = this.ont.createTriple(subj, obj, pred, "Triple", "");
                SimpleComparableOntologyTest.fail((String)"Expected AlreadyExistsException");
            }
            catch (AlreadyExistsException ex) {}
        }
        catch (Exception ex) {
            SimpleComparableOntologyTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testDeleteTerm() {
        System.out.println("testDeleteTerm");
        int termSize = this.ont.getTerms().size();
        int tripleSize = this.ont.getTriples(null, null, null).size();
        try {
            this.ont.deleteTerm(this.term);
            SimpleComparableOntologyTest.assertFalse((boolean)this.ont.containsTerm(this.term.getName()));
            SimpleComparableOntologyTest.assertEquals((int)(termSize - 1), (int)this.ont.getTerms().size());
            SimpleComparableOntologyTest.assertEquals((int)(tripleSize - 1), (int)this.ont.getTriples(null, null, null).size());
            SimpleComparableOntologyTest.assertNotNull((Object)this.cr.getEvent());
            ChangeEvent ce = this.cr.getEvent();
            SimpleComparableOntologyTest.assertEquals((Object)ComparableOntology.TERM, (Object)ce.getType());
            SimpleComparableOntologyTest.assertEquals((Object)this.term, (Object)ce.getPrevious());
            SimpleComparableOntologyTest.assertNull((Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleComparableOntologyTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetTriples() {
        System.out.println("testGetTriples");
        SimpleComparableOntologyTest.assertEquals((int)1, (int)this.ont.getTriples(null, null, null).size());
        SimpleComparableOntologyTest.assertEquals((int)1, (int)this.ont.getTriples(this.term, null, null).size());
        SimpleComparableOntologyTest.assertEquals((int)1, (int)this.ont.getTriples(null, this.term, null).size());
        SimpleComparableOntologyTest.assertEquals((int)1, (int)this.ont.getTriples(null, null, this.term).size());
        SimpleComparableOntologyTest.assertEquals((int)1, (int)this.ont.getTriples(this.term, null, this.term).size());
        SimpleComparableOntologyTest.assertEquals((int)1, (int)this.ont.getTriples(null, this.term, this.term).size());
        SimpleComparableOntologyTest.assertEquals((int)1, (int)this.ont.getTriples(this.term, this.term, null).size());
        SimpleComparableOntologyTest.assertEquals((int)1, (int)this.ont.getTriples(this.term, this.term, this.term).size());
        SimpleComparableOntologyTest.assertTrue((boolean)this.ont.getTriples(null, null, null).contains(this.t3));
    }

    public void testSetTripleSet() {
        System.out.println("testSetTripleSet");
        TreeSet s = new TreeSet();
        try {
            this.ont.setTripleSet(s);
        }
        catch (ChangeVetoException ex) {
            SimpleComparableOntologyTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetTripleSet() {
        System.out.println("testGetTripleSet");
        SimpleComparableOntologyTest.assertNotNull((Object)this.ont.getTripleSet());
        SimpleComparableOntologyTest.assertTrue((boolean)this.ont.getTripleSet().contains(this.t3));
        try {
            Term term2 = this.ont.createTerm("foo2", null);
            this.ont.getTripleSet().add(new SimpleComparableTriple(this.ont, this.term, this.term, (ComparableTerm)term2));
        }
        catch (Exception ex) {
            SimpleComparableOntologyTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetTerms() {
        System.out.println("testGetTerms");
        SimpleComparableOntologyTest.assertNotNull((Object)this.ont.getTerms());
        SimpleComparableOntologyTest.assertEquals((int)1, (int)this.ont.getTerms().size());
    }

    public void testSetTermSet() {
        System.out.println("testSetTermSet");
        TreeSet s = new TreeSet();
        try {
            this.ont.setTermSet(s);
        }
        catch (ChangeVetoException ex) {
            SimpleComparableOntologyTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetTermSet() {
        System.out.println("testGetTermSet");
        SimpleComparableOntologyTest.assertNotNull((Object)this.ont.getTermSet());
        SimpleComparableOntologyTest.assertTrue((boolean)this.ont.getTermSet().contains(this.term));
        try {
            Term term2 = this.ont.createTerm("foo2", null);
            this.ont.getTripleSet().add(term2);
        }
        catch (Exception ex) {
            SimpleComparableOntologyTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testContainsTriple() {
        System.out.println("testContainsTriple");
        SimpleComparableOntologyTest.assertTrue((boolean)this.ont.containsTriple(this.t3.getSubject(), this.t3.getObject(), this.t3.getPredicate()));
        SimpleComparableOntologyTest.assertFalse((boolean)this.ont.containsTriple(this.t3.getSubject(), this.t3.getObject(), this.ont.getOrCreateTerm("another_term")));
    }

    public void testCreateVariable() {
        System.out.println("testCreateVariable");
        try {
            this.ont.createVariable("name", "desc");
            SimpleComparableOntologyTest.fail((String)"Should throw an Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetDescription() {
        System.out.println("testGetDescription");
        SimpleComparableOntologyTest.assertNull((Object)this.ont.getDescription());
    }

    public void testSetDescription() {
        System.out.println("testSetDescription");
        String desc = "desc";
        try {
            this.ont.setDescription(desc);
            SimpleComparableOntologyTest.assertEquals((String)desc, (String)this.ont.getDescription());
            SimpleComparableOntologyTest.assertNotNull((Object)this.cr.getEvent());
            ChangeEvent ce = this.cr.getEvent();
            SimpleComparableOntologyTest.assertEquals((Object)ComparableOntology.DESCRIPTION, (Object)ce.getType());
            SimpleComparableOntologyTest.assertEquals((Object)desc, (Object)ce.getChange());
            SimpleComparableOntologyTest.assertNull((Object)ce.getPrevious());
        }
        catch (ChangeVetoException ex) {
            SimpleComparableOntologyTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetName() {
        System.out.println("testGetName");
        SimpleComparableOntologyTest.assertEquals((String)this.name, (String)this.ont.getName());
    }

    public void testGetOps() {
        System.out.println("testGetOps");
        SimpleComparableOntologyTest.assertNotNull((Object)this.ont.getOps());
    }
}

