/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ontology;

import java.util.Arrays;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleCrossRef;
import org.biojavax.SimpleRankedCrossRef;
import org.biojavax.ontology.ComparableOntology;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.ontology.SimpleComparableOntology;
import org.biojavax.ontology.SimpleComparableTerm;

public class SimpleComparableTermTest
extends TestCase {
    SimpleComparableTerm t1;
    SimpleComparableTerm t2;
    ComparableOntology ont = new SimpleComparableOntology("test_onto");
    String name = "foo";
    Object[] synonyms = new String[]{"foo2", "foo3"};
    ChangeListener.ChangeEventRecorder cr;

    public SimpleComparableTermTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.cr = new ChangeListener.ChangeEventRecorder();
        this.t1 = new SimpleComparableTerm(this.ont, this.name, null);
        this.t1.addChangeListener(this.cr);
        this.t2 = new SimpleComparableTerm(this.ont, this.name, this.synonyms);
    }

    protected void tearDown() throws Exception {
        this.t1.removeChangeListener(this.cr);
        this.cr = null;
        this.t1 = null;
        this.t2 = null;
        RichObjectFactory.clearLRUCache(SimpleComparableTerm.class);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleComparableTermTest.class);
        return suite;
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        SimpleComparableTermTest.assertEquals((int)this.t1.hashCode(), (int)this.t2.hashCode());
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleComparableTermTest.assertTrue((boolean)this.t1.equals(this.t1));
        SimpleComparableTermTest.assertTrue((boolean)this.t1.equals(this.t2));
        SimpleComparableTermTest.assertTrue((boolean)this.t2.equals(this.t1));
        this.t2 = new SimpleComparableTerm(this.ont, "bar", null);
        SimpleComparableTermTest.assertTrue((!this.t1.equals(this.t2) ? 1 : 0) != 0);
        SimpleComparableTermTest.assertTrue((!this.t2.equals(this.t1) ? 1 : 0) != 0);
        this.t2 = new SimpleComparableTerm(new SimpleComparableOntology("another_ont"), this.name, null);
        SimpleComparableTermTest.assertTrue((!this.t1.equals(this.t2) ? 1 : 0) != 0);
        SimpleComparableTermTest.assertTrue((!this.t2.equals(this.t1) ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleComparableTermTest.assertTrue((this.t1.compareTo(this.t1) == 0 ? 1 : 0) != 0);
        SimpleComparableTermTest.assertTrue((this.t1.compareTo(this.t2) == 0 ? 1 : 0) != 0);
        SimpleComparableTermTest.assertTrue((this.t2.compareTo(this.t1) == 0 ? 1 : 0) != 0);
        this.t2 = new SimpleComparableTerm(this.ont, "bar", null);
        SimpleComparableTermTest.assertTrue((this.t1.compareTo(this.t2) > 0 ? 1 : 0) != 0);
        SimpleComparableTermTest.assertTrue((this.t2.compareTo(this.t1) < 0 ? 1 : 0) != 0);
        this.t2 = new SimpleComparableTerm(new SimpleComparableOntology("another_ont"), this.name, null);
        SimpleComparableTermTest.assertTrue((this.t1.compareTo(this.t2) > 0 ? 1 : 0) != 0);
        SimpleComparableTermTest.assertTrue((this.t2.compareTo(this.t1) < 0 ? 1 : 0) != 0);
    }

    public void testAddSynonym() {
        System.out.println("testAddSynonym");
        String syn = "another_name";
        this.t1.addSynonym(syn);
        SimpleComparableTermTest.assertTrue((Arrays.binarySearch(this.t1.getSynonyms(), syn) != -1 ? 1 : 0) != 0);
        this.t2.addSynonym(syn);
        SimpleComparableTermTest.assertEquals((int)3, (int)this.t2.getSynonyms().length);
    }

    public void testRemoveSynonym() {
        System.out.println("testRemoveSynonym");
        String synonym = "foo2";
        this.t2.removeSynonym(synonym);
        SimpleComparableTermTest.assertEquals((int)1, (int)this.t2.getSynonyms().length);
        SimpleComparableTermTest.assertTrue((Arrays.binarySearch(this.t1.getSynonyms(), synonym) == -1 ? 1 : 0) != 0);
    }

    public void testGetSynonyms() {
        System.out.println("testGetSynonyms");
        SimpleComparableTermTest.assertNotNull((Object)this.t1.getSynonyms());
    }

    public void testGetRankedCrossRefs() {
        System.out.println("testGetRankedCrossRefs");
        SimpleComparableTermTest.assertNotNull((Object)this.t1.getRankedCrossRefs());
        try {
            this.t1.getRankedCrossRefs().add(new SimpleRankedCrossRef(new SimpleCrossRef("db", "acc", 1), 0));
        }
        catch (Exception ex) {
            SimpleComparableTermTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testSetRankedCrossRefs() {
        System.out.println("testSetRankedCrossRefs");
        try {
            TreeSet<SimpleRankedCrossRef> s = new TreeSet<SimpleRankedCrossRef>();
            s.add(new SimpleRankedCrossRef(new SimpleCrossRef("db", "acc", 1), 0));
            this.t1.setRankedCrossRefs(s);
            SimpleComparableTermTest.assertEquals(s, (Object)this.t1.getRankedCrossRefs());
        }
        catch (Exception ex) {
            SimpleComparableTermTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testAddRankedCrossRef() {
        System.out.println("testAddRankedCrossRef");
        SimpleRankedCrossRef xref = new SimpleRankedCrossRef(new SimpleCrossRef("db", "acc", 1), 0);
        try {
            this.t1.addRankedCrossRef(xref);
            SimpleComparableTermTest.assertTrue((boolean)this.t1.getRankedCrossRefs().contains(xref));
            ChangeEvent ev = this.cr.getEvent();
            SimpleComparableTermTest.assertNotNull((Object)ev);
            SimpleComparableTermTest.assertEquals((Object)ComparableTerm.RANKEDCROSSREF, (Object)ev.getType());
            SimpleComparableTermTest.assertNull((Object)ev.getPrevious());
            SimpleComparableTermTest.assertEquals((Object)xref, (Object)ev.getChange());
        }
        catch (Exception ex) {
            SimpleComparableTermTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testRemoveRankedCrossRef() {
        System.out.println("testRemoveRankedCrossRef");
        SimpleRankedCrossRef xref = new SimpleRankedCrossRef(new SimpleCrossRef("db", "acc", 1), 0);
        try {
            this.t1.addRankedCrossRef(xref);
            SimpleComparableTermTest.assertTrue((boolean)this.t1.getRankedCrossRefs().contains(xref));
            this.t1.removeRankedCrossRef(xref);
            ChangeEvent ev = this.cr.getEvent();
            SimpleComparableTermTest.assertNotNull((Object)ev);
            SimpleComparableTermTest.assertEquals((Object)ComparableTerm.RANKEDCROSSREF, (Object)ev.getType());
            SimpleComparableTermTest.assertEquals((Object)xref, (Object)ev.getPrevious());
            SimpleComparableTermTest.assertNull((Object)ev.getChange());
        }
        catch (Exception ex) {
            SimpleComparableTermTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetName() {
        System.out.println("testGetName");
        SimpleComparableTermTest.assertEquals((String)this.name, (String)this.t1.getName());
    }

    public void testGetDescription() {
        System.out.println("testGetDescription");
        SimpleComparableTermTest.assertNull((Object)this.t1.getDescription());
    }

    public void testSetDescription() {
        System.out.println("testSetDescription");
        try {
            this.t1.setDescription(null);
        }
        catch (Exception ex) {
            SimpleComparableTermTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        String desc = "my_desc";
        try {
            this.t1.setDescription(desc);
            SimpleComparableTermTest.assertEquals((String)desc, (String)this.t1.getDescription());
            ChangeEvent ev = this.cr.getEvent();
            SimpleComparableTermTest.assertNotNull((Object)ev);
            SimpleComparableTermTest.assertEquals((Object)ComparableTerm.DESCRIPTION, (Object)ev.getType());
            SimpleComparableTermTest.assertNull((Object)ev.getPrevious());
            SimpleComparableTermTest.assertEquals((Object)desc, (Object)ev.getChange());
        }
        catch (Exception ex) {
            SimpleComparableTermTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetOntology() {
        System.out.println("testGetOntology");
        SimpleComparableTermTest.assertEquals((Object)this.ont, (Object)this.t1.getOntology());
    }

    public void testToString() {
        System.out.println("testToString");
        String expected = this.ont + ":" + this.name;
        SimpleComparableTermTest.assertEquals((String)expected, (String)this.t1.toString());
        try {
            this.t1.setObsolete(new Boolean(true));
            expected = this.ont + ":" + this.name + " [obsolete]";
            SimpleComparableTermTest.assertEquals((String)expected, (String)this.t1.toString());
        }
        catch (Exception ex) {
            SimpleComparableTermTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetAnnotation() {
        System.out.println("testGetAnnotation");
        SimpleComparableTermTest.assertEquals((Object)RichAnnotation.EMPTY_ANNOTATION, (Object)this.t1.getAnnotation());
    }

    public void testGetIdentifier() {
        System.out.println("testGetIdentifier");
        SimpleComparableTermTest.assertNull((Object)this.t1.getIdentifier());
    }

    public void testSetIdentifier() {
        System.out.println("testSetIdentifier");
        try {
            this.t1.setDescription(null);
        }
        catch (Exception ex) {
            SimpleComparableTermTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        String ident = "my_ident";
        try {
            this.t1.setIdentifier(ident);
            SimpleComparableTermTest.assertEquals((String)ident, (String)this.t1.getIdentifier());
            ChangeEvent ev = this.cr.getEvent();
            SimpleComparableTermTest.assertNotNull((Object)ev);
            SimpleComparableTermTest.assertEquals((Object)ComparableTerm.IDENTIFIER, (Object)ev.getType());
            SimpleComparableTermTest.assertNull((Object)ev.getPrevious());
            SimpleComparableTermTest.assertEquals((Object)ident, (Object)ev.getChange());
        }
        catch (Exception ex) {
            SimpleComparableTermTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetObsolete() {
        System.out.println("testGetObsolete");
        SimpleComparableTermTest.assertFalse((boolean)this.t1.getObsolete());
    }

    public void testSetObsolete() {
        System.out.println("testSetObsolete");
        Boolean obs = Boolean.TRUE;
        try {
            this.t1.setObsolete(obs);
            SimpleComparableTermTest.assertEquals((Object)obs, (Object)this.t1.getObsolete());
            ChangeEvent ev = this.cr.getEvent();
            SimpleComparableTermTest.assertNotNull((Object)ev);
            SimpleComparableTermTest.assertEquals((Object)ComparableTerm.OBSOLETE, (Object)ev.getType());
            SimpleComparableTermTest.assertEquals((Object)Boolean.FALSE, (Object)ev.getPrevious());
            SimpleComparableTermTest.assertEquals((Object)obs, (Object)ev.getChange());
        }
        catch (Exception ex) {
            SimpleComparableTermTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }
}

