/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ontology;

import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojavax.RichAnnotation;
import org.biojavax.ontology.ComparableOntology;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.ontology.ComparableTriple;
import org.biojavax.ontology.SimpleComparableOntology;
import org.biojavax.ontology.SimpleComparableTerm;
import org.biojavax.ontology.SimpleComparableTriple;

public class SimpleComparableTripleTest
extends TestCase {
    ChangeListener.ChangeEventRecorder cr;
    SimpleComparableTriple trip;
    ComparableTerm subj;
    ComparableTerm obj;
    ComparableTerm pred;
    ComparableOntology ont = new SimpleComparableOntology("test");
    ComparableTerm subj2;
    ComparableTerm obj2;
    ComparableTerm pred2;
    ComparableOntology ont2;

    public SimpleComparableTripleTest(String testName) {
        super(testName);
        this.subj = new SimpleComparableTerm(this.ont, "subj", null);
        this.obj = new SimpleComparableTerm(this.ont, "obj", null);
        this.pred = new SimpleComparableTerm(this.ont, "pred", null);
        this.ont2 = new SimpleComparableOntology("test2");
        this.subj2 = new SimpleComparableTerm(this.ont, "subj2", null);
        this.obj2 = new SimpleComparableTerm(this.ont, "obj2", null);
        this.pred2 = new SimpleComparableTerm(this.ont, "pred2", null);
    }

    protected void setUp() throws Exception {
        this.cr = new ChangeListener.ChangeEventRecorder();
        this.trip = new SimpleComparableTriple(this.ont, this.subj, this.obj, this.pred);
        this.trip.addChangeListener(this.cr);
    }

    protected void tearDown() throws Exception {
        this.trip.removeChangeListener(this.cr);
        this.trip = null;
        this.cr = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleComparableTripleTest.class);
        return suite;
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleComparableTripleTest.assertTrue((this.trip.compareTo(this.trip) == 0 ? 1 : 0) != 0);
        SimpleComparableTriple trip2 = new SimpleComparableTriple(this.ont, this.subj, this.obj, this.pred);
        SimpleComparableTripleTest.assertTrue((this.trip.compareTo(trip2) == 0 ? 1 : 0) != 0);
        SimpleComparableTripleTest.assertTrue((trip2.compareTo(this.trip) == 0 ? 1 : 0) != 0);
        trip2 = new SimpleComparableTriple(this.ont2, this.subj, this.obj, this.pred);
        SimpleComparableTripleTest.assertTrue((this.trip.compareTo(trip2) < 0 ? 1 : 0) != 0);
        SimpleComparableTripleTest.assertTrue((trip2.compareTo(this.trip) > 0 ? 1 : 0) != 0);
        trip2 = new SimpleComparableTriple(this.ont, this.subj2, this.obj, this.pred);
        SimpleComparableTripleTest.assertTrue((this.trip.compareTo(trip2) < 0 ? 1 : 0) != 0);
        SimpleComparableTripleTest.assertTrue((trip2.compareTo(this.trip) > 0 ? 1 : 0) != 0);
        trip2 = new SimpleComparableTriple(this.ont, this.subj, this.obj2, this.pred);
        SimpleComparableTripleTest.assertTrue((this.trip.compareTo(trip2) < 0 ? 1 : 0) != 0);
        SimpleComparableTripleTest.assertTrue((trip2.compareTo(this.trip) > 0 ? 1 : 0) != 0);
        trip2 = new SimpleComparableTriple(this.ont, this.subj, this.obj, this.pred2);
        SimpleComparableTripleTest.assertTrue((this.trip.compareTo(trip2) < 0 ? 1 : 0) != 0);
        SimpleComparableTripleTest.assertTrue((trip2.compareTo(this.trip) > 0 ? 1 : 0) != 0);
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleComparableTripleTest.assertTrue((boolean)this.trip.equals(this.trip));
        SimpleComparableTriple trip2 = new SimpleComparableTriple(this.ont, this.subj, this.obj, this.pred);
        SimpleComparableTripleTest.assertTrue((boolean)this.trip.equals(trip2));
        SimpleComparableTripleTest.assertTrue((boolean)((Object)trip2).equals(this.trip));
        trip2 = new SimpleComparableTriple(this.ont2, this.subj, this.obj, this.pred);
        SimpleComparableTripleTest.assertTrue((!this.trip.equals(trip2) ? 1 : 0) != 0);
        SimpleComparableTripleTest.assertTrue((!((Object)trip2).equals(this.trip) ? 1 : 0) != 0);
        trip2 = new SimpleComparableTriple(this.ont, this.subj2, this.obj, this.pred);
        SimpleComparableTripleTest.assertTrue((!this.trip.equals(trip2) ? 1 : 0) != 0);
        SimpleComparableTripleTest.assertTrue((!((Object)trip2).equals(this.trip) ? 1 : 0) != 0);
        trip2 = new SimpleComparableTriple(this.ont, this.subj, this.obj2, this.pred);
        SimpleComparableTripleTest.assertTrue((!this.trip.equals(trip2) ? 1 : 0) != 0);
        SimpleComparableTripleTest.assertTrue((!((Object)trip2).equals(this.trip) ? 1 : 0) != 0);
        trip2 = new SimpleComparableTriple(this.ont, this.subj, this.obj, this.pred2);
        SimpleComparableTripleTest.assertTrue((!this.trip.equals(trip2) ? 1 : 0) != 0);
        SimpleComparableTripleTest.assertTrue((!((Object)trip2).equals(this.trip) ? 1 : 0) != 0);
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        SimpleComparableTriple trip2 = new SimpleComparableTriple(this.ont, this.subj, this.obj, this.pred);
        SimpleComparableTripleTest.assertTrue((this.trip.hashCode() == trip2.hashCode() ? 1 : 0) != 0);
        SimpleComparableTripleTest.assertTrue((this.trip.hashCode() == trip2.hashCode() ? 1 : 0) != 0);
    }

    public void testGetName() {
        System.out.println("testGetName");
        SimpleComparableTripleTest.assertEquals((String)this.trip.toString(), (String)this.trip.getName());
    }

    public void testGetSubject() {
        System.out.println("testGetSubject");
        SimpleComparableTripleTest.assertEquals((Object)this.subj, (Object)this.trip.getSubject());
    }

    public void testGetObject() {
        System.out.println("testGetObject");
        SimpleComparableTripleTest.assertEquals((Object)this.obj, (Object)this.trip.getObject());
    }

    public void testGetPredicate() {
        System.out.println("testGetPredicate");
        SimpleComparableTripleTest.assertEquals((Object)this.pred, (Object)this.trip.getPredicate());
    }

    public void testAddDescriptor() {
        System.out.println("testAddDescriptor");
        SimpleComparableTerm term = new SimpleComparableTerm(this.ont, "foo", null);
        try {
            this.trip.addDescriptor(null);
            SimpleComparableTripleTest.fail((String)"Cannot be null");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            SimpleComparableTripleTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            this.trip.addDescriptor(term);
            ChangeEvent ce = this.cr.getEvent();
            SimpleComparableTripleTest.assertNotNull((Object)ce);
            SimpleComparableTripleTest.assertEquals((Object)ComparableTriple.DESCRIPTOR, (Object)ce.getType());
            SimpleComparableTripleTest.assertNull((Object)ce.getPrevious());
            SimpleComparableTripleTest.assertEquals((Object)term, (Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleComparableTripleTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testRemoveDescriptor() {
        System.out.println("testRemoveDescriptor");
        SimpleComparableTerm term = new SimpleComparableTerm(this.ont, "foo", null);
        try {
            this.trip.addDescriptor(term);
        }
        catch (Exception ex) {
            SimpleComparableTripleTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            this.trip.removeDescriptor(null);
            SimpleComparableTripleTest.fail((String)"Cannot be null");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            SimpleComparableTripleTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            this.trip.removeDescriptor(term);
            ChangeEvent ce = this.cr.getEvent();
            SimpleComparableTripleTest.assertNotNull((Object)ce);
            SimpleComparableTripleTest.assertEquals((Object)ComparableTriple.DESCRIPTOR, (Object)ce.getType());
            SimpleComparableTripleTest.assertEquals((Object)term, (Object)ce.getPrevious());
            SimpleComparableTripleTest.assertNull((Object)ce.getChange());
        }
        catch (Exception ex) {
            SimpleComparableTripleTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testGetDescriptors() {
        System.out.println("testGetDescriptors");
        SimpleComparableTripleTest.assertNotNull((Object)this.trip.getDescriptors());
        SimpleComparableTripleTest.assertTrue((this.trip.getDescriptors().size() == 0 ? 1 : 0) != 0);
    }

    public void testSetDescriptors() {
        System.out.println("testSetDescriptors");
        TreeSet desc = new TreeSet();
        try {
            this.trip.setDescriptors(null);
        }
        catch (Exception ex) {
            SimpleComparableTripleTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
        try {
            this.trip.setDescriptors(desc);
        }
        catch (Exception ex) {
            SimpleComparableTripleTest.fail((String)("Not expecting " + ex.getClass().getName()));
        }
    }

    public void testRemoveSynonym() {
        System.out.println("testRemoveSynonym");
        try {
            this.trip.removeSynonym("Synonym");
            SimpleComparableTripleTest.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAddSynonym() {
        System.out.println("testAddSynonym");
        try {
            this.trip.addSynonym("Synonym");
            SimpleComparableTripleTest.fail((String)"Should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetSynonyms() {
        System.out.println("testGetSynonyms");
        SimpleComparableTripleTest.assertNotNull((Object)this.trip.getSynonyms());
        SimpleComparableTripleTest.assertTrue((this.trip.getSynonyms().length == 0 ? 1 : 0) != 0);
    }

    public void testGetOntology() {
        System.out.println("testGetOntology");
        SimpleComparableTripleTest.assertEquals((Object)this.ont, (Object)this.trip.getOntology());
    }

    public void testGetDescription() {
        System.out.println("testGetDescription");
        SimpleComparableTripleTest.assertEquals((String)"", (String)this.trip.getDescription());
    }

    public void testGetAnnotation() {
        System.out.println("testGetAnnotation");
        SimpleComparableTripleTest.assertEquals((Object)RichAnnotation.EMPTY_ANNOTATION, (Object)this.trip.getAnnotation());
    }

    public void testToString() {
        System.out.println("testToString");
        String expected = this.ont + ":" + this.pred + "(" + this.subj + "," + this.obj + ")";
        SimpleComparableTripleTest.assertEquals((String)expected, (String)this.trip.toString());
    }
}

