/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package jp.sourceforge.simplefh;

import java.io.File;
import java.io.IOException;

/**
 * SimpleFileAccessor<br>
 * <br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public interface SimpleFileAccessor
{

	/**
	 * Get directory name from path (like UNIX command)
	 * 
	 * @param path
	 * 		target path
	 * @return dirname
	 */
	public String dirname(String path);

	/**
	 * Get directory name from path (like UNIX command)
	 * 
	 * @param file
	 * 		target file
	 * @return
	 */
	public String dirname(File file);

	public String basename(String path);

	public String basename(File file);

	public void copy(String src, String dest) throws IOException;

	public void copy(File srcFile, String dest) throws IOException;

	public void delete(String filepath) throws IOException;

	public void delete(File targetFile) throws IOException;

	public void move(String fromPath, String toPath) throws IOException;

	public void move(File targetFile, String toPath) throws IOException;

	public void rename(String resourcePathOrFilePath, String newFilename)
			throws IOException;

	public void rename(File file, String newFilename) throws IOException;

	public void touch(String resourcePathOrFilePath) throws IOException;

	public void touch(File file) throws IOException;

}
