/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package jp.sourceforge.simplefh;

import java.io.IOException;
import java.util.List;

/**
 * SimpleFileWriter<br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public interface SimpleFileWriter
{
	public void write(String[] lines) throws IOException;

	public void write(List<String> lines) throws IOException;

	public void write(String strContent) throws IOException;

	public void write(byte[] content) throws IOException;

	public String getFile();

	public void setFile(String resourcePathOrFilePath);

	public String getLineBreak();

	public void setLineBreak(String lineBreak);

	public String getEncoding();

	public void setEncoding(String encoding);
}
