package jp.sourceforge.simplefh.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

import jp.sourceforge.simplefh.SimpleFileAccessor;
import jp.sourceforge.simplefh.SimpleFileWriter;

public class SimpleFileAccessorImpl implements SimpleFileAccessor
{

	SimpleFileWriter writer = new SimpleFileWriterImpl();
	private static final String BACK_SLASH = "\\";
	private static final String SLASH = "/";
	private static final String PIPE = "|";
	private static final String DIR_SEPARATOR = File.separator;
	private static final String DIR_SEPARATOR_REGEXP;
	static
	{
		if (DIR_SEPARATOR.equals(BACK_SLASH))
		{
			DIR_SEPARATOR_REGEXP = BACK_SLASH + BACK_SLASH + PIPE + SLASH;
		} else
		{
			DIR_SEPARATOR_REGEXP = SLASH;
		}
	}

	/**
	 * Get directory name from path (like UNIX command)
	 * 
	 * @param path
	 * 		target path
	 * @return dirname
	 */
	public String dirname(String path)
	{
		String[] tmpArr = path.split(DIR_SEPARATOR_REGEXP);
		StringBuffer sb = new StringBuffer();
		int len = tmpArr.length - 1;
		for (int i = 0; i < len; i++)
		{
			sb.append(tmpArr[i]);
			sb.append(DIR_SEPARATOR);
		}
		return sb.toString();
	}

	/**
	 * Get directory name from path (like UNIX command)
	 * 
	 * @param file
	 * 		target file
	 * @return
	 */
	public String dirname(File file)
	{
		String path = file.getPath();
		return dirname(path);
	}

	public String basename(String path)
	{
		String[] tmpArr = path.split(DIR_SEPARATOR_REGEXP);
		int basenameIdx = tmpArr.length - 1;
		return tmpArr[basenameIdx];
	}

	public String basename(File file)
	{
		String path = file.getPath();
		return basename(path);
	}

	public void copy(String src, String dest) throws IOException
	{
		FileChannel srcChannel = new FileInputStream(src).getChannel();
		FileChannel destChannel = new FileOutputStream(dest).getChannel();
		srcChannel.transferTo(0, srcChannel.size(), destChannel);
	}

	public void copy(File srcFile, String dest) throws IOException
	{
		FileChannel srcChannel = new FileInputStream(srcFile).getChannel();
		FileChannel destChannel = new FileOutputStream(dest).getChannel();
		srcChannel.transferTo(0, srcChannel.size(), destChannel);
	}

	public void delete(String filepath) throws IOException
	{
		File targetFile = new File(filepath);
		try
		{
			delete(targetFile);
		} catch (IOException e)
		{
			throw new IOException("Cannot delete file : " + filepath);
		}
	}

	public void delete(File targetFile) throws IOException
	{
		if (!targetFile.delete())
		{
			throw new IOException("Cannot delete file : " + targetFile.getPath());
		}
	}

	public void move(String fromPath, String toPath) throws IOException
	{
		File targetFile = new File(fromPath);
		try
		{
			move(targetFile, toPath);
		} catch (IOException e)
		{
			throw new IOException("Cannot move file from : " + fromPath + ", to : "
					+ toPath);
		}
	}

	public void move(File targetFile, String toPath) throws IOException
	{
		if (!targetFile.renameTo(new File(toPath)))
		{
			throw new IOException("Cannot move file from : " + targetFile.getPath()
					+ ", to : " + toPath);
		}
	}

	public void rename(String resourcePathOrFilePath, String newFilename)
			throws IOException
	{
		File targetFile = new File(resourcePathOrFilePath);
		rename(targetFile, newFilename);
	}

	public void rename(File file, String newFilename) throws IOException
	{
		if (!file.renameTo(new File(dirname(file) + File.pathSeparator + basename(file))))
		{
			throw new IOException("Cannot rename file from : " + file.getPath()
					+ ", to : " + newFilename);
		}
	}

	public void touch(String resourcePathOrFilePath) throws IOException
	{
		writer.setFile(resourcePathOrFilePath);
		byte[] bytes = new byte[0];
		writer.write(bytes);
	}

	public void touch(File file) throws IOException
	{
		String path = file.getPath();
		writer.setFile(path);
		byte[] bytes = new byte[0];
		writer.write(bytes);
	}

}
