/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package jp.sourceforge.simplefh.impl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

import jp.sourceforge.simplefh.SimpleFileWriter;
import jp.sourceforge.simplefh.constant.BR;
import jp.sourceforge.simplefh.constant.Encoding;
import jp.sourceforge.simplefh.util.FileResourceUtil;

/**
 * SimpleFileWriterImpl<br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public class SimpleFileWriterImpl implements SimpleFileWriter
{

	// TODO 改行コードを固定させる実装

	private String encoding = Encoding.MS932;
	private String file = null;
	private String lineBreak = BR.CRLF;

	public void write(String[] lines) throws IOException
	{
		StringBuffer sb = new StringBuffer();
		int len = lines.length;
		for (int i = 0; i < len; i++)
		{
			sb.append(lines[i]);
			sb.append(this.lineBreak);
		}
		String strContent = sb.toString();
		write(strContent);
	}

	public void write(List<String> lines) throws IOException
	{
		StringBuffer sb = new StringBuffer();
		int len = lines.size();
		for (int i = 0; i < len; i++)
		{
			sb.append(lines.get(i));
			sb.append(this.lineBreak);
		}
		String strContent = sb.toString();
		write(strContent);
	}

	public void write(String strContent) throws IOException
	{
		byte[] content = strContent.getBytes(this.encoding);
		write(content);
	}

	public void write(byte[] content) throws IOException
	{
		FileOutputStream fos = null;
		try
		{
			fos = new FileOutputStream(this.file);
			fos.write(content);
		} catch (NullPointerException npe)
		{
			throw new RuntimeException("Output file is required.");
		} catch (IOException e)
		{
			e.printStackTrace();
			throw e;
		} finally
		{
			FileResourceUtil.close(fos);
		}
	}

	public String getFile()
	{
		return file;
	}

	public void setFile(String resourcePathOrFilePath)
	{
		this.file = resourcePathOrFilePath;
	}

	public String getLineBreak()
	{
		return lineBreak;
	}

	public void setLineBreak(String lineBreak)
	{
		this.lineBreak = lineBreak;
	}

	public String getEncoding()
	{
		return encoding;
	}

	public void setEncoding(String encoding)
	{
		this.encoding = encoding;
	}

}
