/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */
package jp.sourceforge.javacpt.impl;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

import jp.sourceforge.javacpt.Printer;

/**
 * PrinterImpl<br>
 * <br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public class PrinterImpl implements Printer
{

	private Logger logger;

	/**
	 * Default constructor
	 */
	public PrinterImpl()
	{
	}

	/**
	 * Constructor
	 * 
	 * @param logger
	 *            logger
	 */
	public PrinterImpl(Logger logger)
	{
		this.logger = logger;
	}

	/**
	 * Print in ERROR level
	 * 
	 * @param str
	 *            String message to print
	 */
	public void errorPrint(String msg)
	{
		if (logger != null)
		{
			try
			{
				errorPrint((Class<?>) ComparativePerformanceTestImpl.class,
						ComparativePerformanceTestImpl.class.getMethod(
								"printResult", (Class[]) null), msg);
			} catch (Exception devonly)
			{
				devonly.printStackTrace();
			}
		} else
		{
			System.err.println(msg);
		}
	}

	/**
	 * Print in ERROR level
	 * 
	 * @param clazz
	 *            class that logging occurred
	 * @param method
	 *            method that logging occurred
	 * @param str
	 *            String message to print
	 */
	public void errorPrint(Class<?> clazz, Method method, String msg)
	{
		if (logger != null)
		{
			this.logger.logp(Level.SEVERE, clazz.getName(), method.getName(),
					msg);
		} else
		{
			System.out.println(msg);
		}
	}

	/**
	 * Print in INFO level
	 * 
	 * @param str
	 *            String message to print
	 */
	public void infoPrint(String msg)
	{
		if (logger != null)
		{
			try
			{
				infoPrint((Class<?>) ComparativePerformanceTestImpl.class,
						ComparativePerformanceTestImpl.class.getMethod(
								"printResult", (Class[]) null), msg);
			} catch (Exception devonly)
			{
				devonly.printStackTrace();
			}
		} else
		{
			System.out.println(msg);
		}
	}

	/**
	 * Print in INFO level
	 * 
	 * @param clazz
	 *            class that logging occurred
	 * @param method
	 *            method that logging occurred
	 * @param str
	 *            String message to print
	 */
	public void infoPrint(Class<?> clazz, Method method, String msg)
	{
		if (logger != null)
		{
			this.logger
					.logp(Level.INFO, clazz.getName(), method.getName(), msg);
		} else
		{
			System.out.println(msg);
		}
	}

	/**
	 * Get Logger
	 * 
	 * @return logger
	 */
	public Logger getLogger()
	{
		return logger;
	}

	/**
	 * Set Logger
	 * 
	 * @param logger
	 *            Logger object
	 */
	public void setLogger(Logger logger)
	{
		this.logger = logger;
	}

}
