package sample.iter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.sourceforge.javacpt.ComparativePerformanceTest;
import jp.sourceforge.javacpt.impl.ComparativePerformanceTestImpl;

public class LoopCheck {

	public static void main(String[] args) throws Exception {

		int executeTimes = 10000;
		LoopCheck instance = new LoopCheck();
		List<String> targetList = new ArrayList<String>();
		for (int i = 0; i < 1000; i++) {
			targetList.add("hoge");
		}

		ComparativePerformanceTest test1 = new ComparativePerformanceTestImpl(
				"indexLoop");
		Method method1 = LoopCheck.class.getMethod("indexLoop", List.class);
		test1.execute(executeTimes, instance, method1, targetList);

		ComparativePerformanceTest test21 = new ComparativePerformanceTestImpl(
				"iteratorExecute1");
		Method method21 = LoopCheck.class.getMethod("iteratorExecute1",
				List.class);
		test21.execute(executeTimes, instance, method21, targetList);

		ComparativePerformanceTest test22 = new ComparativePerformanceTestImpl(
				"iteratorExecute2");
		Method method22 = LoopCheck.class.getMethod("iteratorExecute2",
				List.class);
		test22.execute(executeTimes, instance, method22, targetList);

		ComparativePerformanceTest test3 = new ComparativePerformanceTestImpl(
				"enhancedForLoop");
		Method method3 = LoopCheck.class.getMethod("enhancedForLoop",
				List.class);
		test3.execute(executeTimes, instance, method3, targetList);

	}

	public void indexLoop(List<String> targetList) {
		int len = targetList.size();
		for (int i = 0; i < len; i++) {
			String each = targetList.get(i);
		}
	}

	public void iteratorExecute1(List<String> targetList) {
		for (Iterator<String> iter = targetList.iterator(); iter.hasNext();) {
			String each = iter.next();
		}
	}

	public void iteratorExecute2(List<String> targetList) {
		Iterator<String> iter = targetList.iterator();
		while (iter.hasNext()) {
			String each = iter.next();
		}
	}

	public void enhancedForLoop(List<String> targetList) {
		for (String each : targetList) {
		}
	}

}
