package sample.iter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.sourceforge.javacpt.ComparativePerformanceTest;
import jp.sourceforge.javacpt.ComparativePerformanceTestHelper;

public class LoopCheck2
{

	public static void main(String[] args) throws Exception
	{

		int executeTimes = 10000;
		LoopCheck2 instance = new LoopCheck2();

		List<String> targetList = new ArrayList<String>();
		for (int i = 0; i < 1000; i++)
		{
			targetList.add("hoge");
		}

		ComparativePerformanceTest test = ComparativePerformanceTestHelper
				.initialize(executeTimes, instance);
		ComparativePerformanceTestHelper.invoke(test, "indexLoop", "indexLoop",
				List.class, targetList);
		ComparativePerformanceTestHelper.invoke(test, "iteratorExecute1",
				"iteratorExecute1", List.class, targetList);
		ComparativePerformanceTestHelper.invoke(test, "iteratorExecute2",
				"iteratorExecute2", List.class, targetList);
		ComparativePerformanceTestHelper.invoke(test, "enhancedForLoop",
				"enhancedForLoop", List.class, targetList);
	}

	public void indexLoop(List<String> targetList)
	{
		int len = targetList.size();
		for (int i = 0; i < len; i++)
		{
			String each = targetList.get(i);
		}
	}

	public void iteratorExecute1(List<String> targetList)
	{
		for (Iterator<String> iter = targetList.iterator(); iter.hasNext();)
		{
			String each = iter.next();
		}
	}

	public void iteratorExecute2(List<String> targetList)
	{
		Iterator<String> iter = targetList.iterator();
		while (iter.hasNext())
		{
			String each = iter.next();
		}
	}

	public void enhancedForLoop(List<String> targetList)
	{
		for (String each : targetList)
		{
		}
	}

}
