package sample.map;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import jp.sourceforge.javacpt.ComparativePerformanceTest;
import jp.sourceforge.javacpt.impl.ComparativePerformanceTestImpl;

public class Instanciation {

	public static void main(String[] args) throws Exception {

		int executeTimes = 100000;
		Object instance = new Instanciation();

		Method executeMethod0 = Instanciation.class.getMethod("getHashtable");
		ComparativePerformanceTest test0 = new ComparativePerformanceTestImpl(
				Hashtable.class.toString());
		test0.execute(executeTimes, instance, executeMethod0, (Object[]) null);

		Method executeMethod1 = Instanciation.class.getMethod("getHashMap");
		ComparativePerformanceTest test1 = new ComparativePerformanceTestImpl(
				HashMap.class.toString());
		test1.execute(executeTimes, instance, executeMethod1, (Object[]) null);

		Method executeMethod2 = Instanciation.class
				.getMethod("getConcurrentHashMap");
		ComparativePerformanceTest test2 = new ComparativePerformanceTestImpl(
				ConcurrentHashMap.class.toString());
		test2.execute(executeTimes, instance, executeMethod2, (Object[]) null);

	}

	public static Map<Object, Object> getHashtable() {
		return new Hashtable<Object, Object>();
	}

	public static Map<Object, Object> getHashMap() {
		return new HashMap<Object, Object>();
	}

	public static Map<Object, Object> getConcurrentHashMap() {
		return new ConcurrentHashMap<Object, Object>();
	}

}
