package sample.map;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import jp.sourceforge.javacpt.ComparativePerformanceTest;
import jp.sourceforge.javacpt.impl.ComparativePerformanceTestImpl;

public class PutAndRemove {

	public static void main(String[] args) throws Exception {

		int executeTimes = 100000;
		Object instance = new PutAndRemove();

		Method executeMethod = PutAndRemove.class.getMethod("putAndRemove",
				Map.class);

		Map<Object, Object> target0 = new Hashtable<Object, Object>();
		ComparativePerformanceTest test0 = new ComparativePerformanceTestImpl(
				Hashtable.class.toString());
		test0.execute(executeTimes, instance, executeMethod, target0);

		Map<Object, Object> target1 = new HashMap<Object, Object>();
		ComparativePerformanceTest test1 = new ComparativePerformanceTestImpl(
				HashMap.class.toString());
		test1.execute(executeTimes, instance, executeMethod, target1);

		Map<Object, Object> target2 = new ConcurrentHashMap<Object, Object>();
		ComparativePerformanceTest test2 = new ComparativePerformanceTestImpl(
				ConcurrentHashMap.class.toString());
		test2.execute(executeTimes, instance, executeMethod, target2);

	}

	public static void putAndRemove(Map<Object, Object> target) {
		target.put("hoge", "foo");
		target.remove("hoge");
	}
}
