package org.lightdi.container.config;

import java.util.ArrayList;
import java.util.List;

import org.lightdi.container.meta.MetaComponentRef;

public final class ComponentConfig
{
	private String name;
	private String className;
	private Object value;
	private String instanceType;

	private List<ConstructorArg> constructorArgs = new ArrayList<ConstructorArg>();
	private List<SetterArg> setterArgs = new ArrayList<SetterArg>();
	private List<InitMethod> initMethods = new ArrayList<InitMethod>();

	public static class Arg
	{
		public Arg()
		{
		}

		private String value;
		private String className;
		private MetaComponentRef ref;

		public String getValue()
		{
			return value;
		}

		public void setValue(String value)
		{
			this.value = value;
		}

		public String getClassName()
		{
			return className;
		}

		public void setClassName(String className)
		{
			this.className = className;
		}

		public MetaComponentRef getRef()
		{
			return ref;
		}

		public void setRef(MetaComponentRef ref)
		{
			this.ref = ref;
		}

	}

	public static class InitMethod
	{
		public InitMethod()
		{
		}

		private String methodName;
		private List<Arg> args = new ArrayList<Arg>();

		public String getMethodName()
		{
			return methodName;
		}

		public void setMethodName(String methodName)
		{
			this.methodName = methodName;
		}

		public List<Arg> getArgs()
		{
			return args;
		}

		public void setArgs(List<Arg> args)
		{
			this.args = args;
		}

	}

	public static class ConstructorArg
	{
		public ConstructorArg()
		{
		}

		private String value;
		private String className;
		private MetaComponentRef ref;

		public String getValue()
		{
			return value;
		}

		public void setValue(String value)
		{
			this.value = value;
		}

		public String getClassName()
		{
			return className;
		}

		public void setClassName(String className)
		{
			this.className = className;
		}

		public MetaComponentRef getRef()
		{
			return ref;
		}

		public void setRef(MetaComponentRef ref)
		{
			this.ref = ref;
		}

	}

	public static class SetterArg
	{
		public SetterArg()
		{
		}

		private String name;
		private String value;
		private String className;
		private MetaComponentRef ref;

		public String getName()
		{
			return name;
		}

		public void setName(String name)
		{
			this.name = name;
		}

		public String getValue()
		{
			return value;
		}

		public void setValue(String value)
		{
			this.value = value;
		}

		public String getClassName()
		{
			return className;
		}

		public void setClassName(String className)
		{
			this.className = className;
		}

		public MetaComponentRef getRef()
		{
			return ref;
		}

		public void setRef(MetaComponentRef ref)
		{
			this.ref = ref;
		}

	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public String getClassName()
	{
		return className;
	}

	public void setClassName(String className)
	{
		this.className = className;
	}

	public String getInstanceType()
	{
		return instanceType;
	}

	public void setInstanceType(String instanceType)
	{
		this.instanceType = instanceType;
	}

	public List<ConstructorArg> getConstructorArgs()
	{
		if (constructorArgs == null)
			constructorArgs = new ArrayList<ConstructorArg>();
		return constructorArgs;
	}

	public void setConstructorArgs(List<ConstructorArg> constructorArgs)
	{
		this.constructorArgs = constructorArgs;
	}

	public List<SetterArg> getSetterArgs()
	{
		if (setterArgs == null)
			setterArgs = new ArrayList<SetterArg>();
		return setterArgs;
	}

	public void setSetterArgs(List<SetterArg> setterArgs)
	{
		this.setterArgs = setterArgs;
	}

	public Object getValue()
	{
		return value;
	}

	public void setValue(Object value)
	{
		this.value = value;
	}

	public List<InitMethod> getInitMethods()
	{
		return initMethods;
	}

	public void setInitMethods(List<InitMethod> initMethods)
	{
		this.initMethods = initMethods;
	}

}
